/*
 * dia_SAFeatureMediaFileCounter.h
 *
 *  Created on:   07.09.2021
 *      Author:   aoo2kor
 */

#ifndef DIA_SAFEATUREMEDIAFILECOUNTER_H_
#define DIA_SAFEATUREMEDIAFILECOUNTER_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__
#include "project/interfaces/dia_IMediaFileCounterListener.h"
#endif

//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO

#include "mplay_fi_if.h"

class amt_tclServiceData;

class dia_SAFeatureMediaFileCounter
      : public dia_SystemAdapterFeature,
      public dia_IMediaFileCounter
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureMediaFileCounter);

public:
   //! default class constructor
   dia_SAFeatureMediaFileCounter ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
   //! class destructor
   virtual ~dia_SAFeatureMediaFileCounter ( void );

   struct DeviceMapping
   {
      //! MediaPlayer FI Device Type
      mplay_fi_tcl_e8_MPlayDeviceType::tenType mMPlayType;
      //! associated dia_IMediaPlayer Device Type
      dia_eMediaPlayerDeviceType m_eDeviceType;
   };

   struct IndexStateMapping
   {
      //! MediaPlayer FI Device Indexed State
      mplay_fi_tcl_e8_MPlayDeviceIndexedState::tenType mMPlayType;
      //! associated dia_IMediaPlayer Indexed State
      dia_eMediaPlayerDeviceIndexedState m_eIndexedState;
   };

   struct ConnectionStateMapping
   {
      //! MediaPlayer FI Device Connection State
      mplay_fi_tcl_e8_MPlayConnectionState::tenType mMPlayType;
      //! associated dia_IMediaPlayer Connection State
      dia_eMediaPlayerConnectionState m_eConnectionState;
   };

   //! Adaptation from MediaPlayer FI Device Type to associated dia_IMediaPlayer Device Type
   tDiaResult loadDeviceMappings ( const DeviceMapping mapping[], tU32 numOfItems );
   //-------------------------------------------------------------------------
   //! Adaptation from MediaPlayer FI Device Indexed State to associated dia_IMediaPlayer Device Indexed State
   tDiaResult loadIndexStateMappings ( const IndexStateMapping mapping[], tU32 numOfItems );
   //-------------------------------------------------------------------------
   //! Adaptation from MediaPlayer FI Device Indexed State to associated dia_IMediaPlayer Device Connection State
   tDiaResult loadConnectionStateMappings ( const ConnectionStateMapping mapping[], tU32 numOfItems );
   //-------------------------------------------------------------------------
   //
   //  Implementation of dia_IMediaFileCounter interface
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult mediaFile_noOfFilesCounter_Get ( void );

protected:
   //! handle the result of mediaFile_noOfFilesCounter_Get
   void vHandleMediaFileCounter(amt_tclServiceData* poMessage) const;

   //! Return the Diagnosis-internal MediaPlayer Device Type
   dia_eMediaPlayerDeviceType getDeviceType ( mplay_fi_tcl_e8_MPlayDeviceType::tenType deviceType ) const;

   typedef std::map<mplay_fi_tcl_e8_MPlayDeviceType::tenType, dia_eMediaPlayerDeviceType> tDeviceMap;
   tDeviceMap mDeviceMap;

    //! Return the Diagnosis-internal MediaPlayer Device Indexed State
   dia_eMediaPlayerDeviceIndexedState getIndexedState ( mplay_fi_tcl_e8_MPlayDeviceIndexedState::tenType indexedState ) const;

   typedef std::map<mplay_fi_tcl_e8_MPlayDeviceIndexedState::tenType, dia_eMediaPlayerDeviceIndexedState> tIndexStateMap;
   tIndexStateMap mIndexStateMap;

    //! Return the Diagnosis-internal MediaPlayer Device Connection State
   dia_eMediaPlayerConnectionState getConnectionState(mplay_fi_tcl_e8_MPlayConnectionState::tenType ConnectionState) const;

   typedef std::map<mplay_fi_tcl_e8_MPlayConnectionState::tenType, dia_eMediaPlayerConnectionState> tConnectionStateMap;
   tConnectionStateMap mConnectionStateMap;

   //! overloaded to register for all needed FIDs when the service is available
   // virtual tBool bOnServiceStateAvailable ( tU16 u16SrvID, tU16 u16SubId );

   tBool bSendMessage (
         const tU8  u8MessageType,
         const tU16 u16FID,
         const tU8  u8Opcode,
         const tU16 u16MsgLength,
         const tU8  u8MsgBuffer[]
         );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureMediaFileCounter)
};

#endif /* dia_SAFeatureMediaFileCounter_H_ */
