/*
 * dia_SAFeatureMediaFileCounter.cpp
 *
 *  Created on: 07.09.2021
 *      Author: aoo2kor
 */

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MEDIAFILECOUNTER_LISTENER__
#include "project/interfaces/dia_IMediaFileCounterListener.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

// TODO: interface is not released, use this for time being
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_CPRAFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO

#include "mplay_fi_if.h"

#include "dia_SAFeatureMediaFileCounter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureMediaFileCounter.cpp.trc.h"
#endif

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP( dia_SAFeatureMediaFileCounter, dia_SystemAdapterFeature )
            ON_MESSAGE(MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS,   vHandleMediaFileCounter)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureMediaFileCounter::dia_SAFeatureMediaFileCounter  (
      tCString name,      // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
      )
   : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureMediaFileCounter::dia_SAFeatureMediaFileCounter");

}

//-----------------------------------------------------------------------------

dia_SAFeatureMediaFileCounter::~dia_SAFeatureMediaFileCounter ( void )
{ }

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMediaFileCounter::loadDeviceMappings ( const DeviceMapping mapping[], tU32 numOfItems )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureMediaFileCounter::loadDeviceMappings");

   tDiaResult retCode = DIA_FAILED;

   if ( mapping )
   {
      for ( tU32 i=0; i<numOfItems; ++i )
      {
         mDeviceMap[mapping[i].mMPlayType] = mapping[i].m_eDeviceType;
      }
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMediaFileCounter::loadIndexStateMappings ( const IndexStateMapping mapping[], tU32 numOfItems )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureMediaFileCounter::loadIndexStateMappings");

   tDiaResult retCode = DIA_FAILED;

   if ( mapping )
   {
      for ( tU32 i=0; i<numOfItems; ++i )
      {
         mIndexStateMap[mapping[i].mMPlayType] = mapping[i].m_eIndexedState;
      }
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMediaFileCounter::loadConnectionStateMappings(const ConnectionStateMapping mapping[], tU32 numOfItems)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureMediaFileCounter::loadConnectionStateMappings");

   tDiaResult retCode = DIA_FAILED;

   if (mapping)
   {
      for (tU32 i = 0; i < numOfItems; ++i)
      {
         mConnectionStateMap[mapping[i].mMPlayType] = mapping[i].m_eConnectionState;
      }
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get - send message.");
      gm_tclEmptyMessage oMessage (
               mAppID,
               mpSrvPlugin->getClientID(),
               mpSrvPlugin->getRegistrationID(),
               0,
               mpSrvPlugin->getServiceID(),
               MPLAY_MEDIAPLAYERFI_C_U16_MEDIAPLAYERDEVICECONNECTIONS,
               CCA_C_U8_OPCODE_UPREG
               );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeatureMediaFileCounter::mediaFile_noOfFilesCounter_Get - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------------------------------
void
dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      DIA_TR_INF("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter poMessage OK.");

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         fi_tclVisitorMessage oReceivedMsg( poMessage );
         mplay_mediaplayerfi_tclMsgMediaPlayerDeviceConnectionsStatus oReceivedData;
         (void)oReceivedMsg.s32GetData( oReceivedData );

         DIA_TR_INF(("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter - Received Data"));

         dia_IMediaFileCounterListener* pListener = OSAL_NULL;
         if ( (DIA_SUCCESS == querySysAdapterListener<dia_IMediaFileCounterListener>(&pListener)) && pListener )
         {
            std::vector<mplay_fi_tcl_MPlayDeviceInfoItem>::const_iterator it =oReceivedData.oDeviceInfo.oItems.begin();
            std::vector<dia_tDeviceInfoItem>   vecDeviceInfoItem;
            dia_tDeviceInfoItem                  tDeviceInfoItem;
            tU32 videoFileCounter=0;
            tU32 audioFileCounter=0;
            if (!oReceivedData.oDeviceInfo.oItems.empty())
            {
               DIA_TR_INF( "DeviceInfoItem.size() = %zu",oReceivedData.oDeviceInfo.oItems.size() );
               for (tU8 i=0; it != oReceivedData.oDeviceInfo.oItems.end(); ++it, ++i )
               {
                  mplay_fi_tcl_MPlayDeviceInfoItem oItems = (*it);
                  dia_eMediaPlayerDeviceType type = getDeviceType(oItems.e8DeviceType.enType);

                  if( type == DIA_EN_MEDIAPLAYER_DEVICE_TYPE_USB)
                  {
                      DIA_TR_INF( "Device Type received=USB");
                      dia_eMediaPlayerConnectionState ConnState = getConnectionState(oItems.e8ConnectionState.enType);
                      if (ConnState == DIA_EN_MEDIAPLAYER_CONNECTION_STATE_CONNECTED)
                     {
                        DIA_TR_INF("USB Mounted Success");
                        dia_eMediaPlayerDeviceIndexedState state = getIndexedState(oItems.e8DeviceIndexedState.enType);
                        if (state == DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_COMPLETE)
                        {
                           DIA_TR_INF("Device Indexed state received=COMPLETE");
                           tDeviceInfoItem.mDeviceTag = oItems.u8DeviceTag;                                          // u8DeviceTag size tU8
                           tDeviceInfoItem.mNumberOfVideoFiles = (tU32)(0xFFFFFFFFU & oItems.u32NumberOfVideoFiles); // u32NumberOfVideoFiles  size tU32*/
                           tDeviceInfoItem.mNumberOfFiles = (tU32)(0xFFFFFFFFU & oItems.u32NumberOfFiles);           // u32NumberOfFiles  size tU32*/
                           tDeviceInfoItem.mNumberOfImageFiles = (tU32)(0xFFFFFFFFU & oItems.u32NumberOfImageFiles); // u32NumberOfImageFiles  size tU32*/
                           tU32 NumberOfAudioFiles = tDeviceInfoItem.mNumberOfFiles - tDeviceInfoItem.mNumberOfVideoFiles - tDeviceInfoItem.mNumberOfImageFiles;
                           if (i != 0)
                           {
                              DIA_TR_INF("------------------------------------");
                           }

                           DIA_TR_INF("[%d]Device Tag          = %d", i, tDeviceInfoItem.mDeviceTag);
                           DIA_TR_INF("[%d]Video file Counter  = %d", i, tDeviceInfoItem.mNumberOfVideoFiles);
                           DIA_TR_INF("[%d]Total file Counter  = %d", i, tDeviceInfoItem.mNumberOfFiles);
                           DIA_TR_INF("[%d]Image file Counter  = %d", i, tDeviceInfoItem.mNumberOfImageFiles);
                           DIA_TR_INF("[%d]Audio file counter  = %d", i, NumberOfAudioFiles);

                           if (tDeviceInfoItem.mNumberOfVideoFiles >= videoFileCounter)
                           {
                              videoFileCounter = tDeviceInfoItem.mNumberOfVideoFiles;
                           }
                           if (NumberOfAudioFiles >= audioFileCounter)
                           {
                              audioFileCounter = NumberOfAudioFiles;
                           }
                        }
                     }
                  }
               }
            }
            //send to listener
            pListener->vOnVideoFile_noOfFilesCounter_Get( videoFileCounter);
            pListener->vOnAudioFile_noOfFilesCounter_Get( audioFileCounter);
            DIA_TR_INF("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter SUCCESS!");
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureMediaFileCounter --- opcode error received with error code 0x%04X", u16ErrorCode);
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter poMessage->u8GetOpCode() UNKNOWN => CODE==%d!", poMessage->u8GetOpCode());
      }

      (void) poMessage->bDelete();
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureMediaFileCounter::vHandleMediaFileCounter poMessage EMPTY!");
   }
}
//--------------------------------------------------------------------------------------------------------

dia_eMediaPlayerDeviceType
dia_SAFeatureMediaFileCounter::getDeviceType ( mplay_fi_tcl_e8_MPlayDeviceType::tenType deviceType ) const
{
   dia_eMediaPlayerDeviceType DeviceType = DIA_EN_MEDIAPLAYER_DEVICE_TYPE_UNKNOWN;

   tDeviceMap::const_iterator it = mDeviceMap.find(deviceType);
   if (it != mDeviceMap.end())
   {
      DeviceType = it->second;
   }

   return DeviceType;
}
//--------------------------------------------------------------------------------------------------------

dia_eMediaPlayerDeviceIndexedState
dia_SAFeatureMediaFileCounter::getIndexedState ( mplay_fi_tcl_e8_MPlayDeviceIndexedState::tenType indexedState ) const
{
   dia_eMediaPlayerDeviceIndexedState IndexedState = DIA_EN_MEDIAPLAYER_DEVICE_INDEXED_STATE_UNKNOWN;

   tIndexStateMap::const_iterator it = mIndexStateMap.find(indexedState);
   if (it != mIndexStateMap.end())
   {
      IndexedState = it->second;
   }

   return IndexedState;
}

//--------------------------------------------------------------------------------------------------------

dia_eMediaPlayerConnectionState
dia_SAFeatureMediaFileCounter::getConnectionState ( mplay_fi_tcl_e8_MPlayConnectionState::tenType connectionState ) const
{
   dia_eMediaPlayerConnectionState ConnectionState = DIA_EN_MEDIAPLAYER_CONNECTION_STATE_UNKNOWN;

   tConnectionStateMap::const_iterator it = mConnectionStateMap.find(connectionState);
   if (it != mConnectionStateMap.end())
   {
      ConnectionState = it->second;
   }

   return ConnectionState;
}
