/*
 * dia_SAFeatureHeatControl.h
 *
 *  Created on: 10.01.2012
 *      Author: gib2hi
 * 	--------------------------------------------------------------------------------------------------------------------------------------------
 * 	Date 	        Author	           Modification
 * 	9.7.16			dvd5kor			   Adapted the Fan related diagnostic services (Get and set) - AIVI-23253
 */

#ifndef DIA_SAFEATUREHEATCONTROL_H_
#define DIA_SAFEATUREHEATCONTROL_H_

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HEATCONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureHeatControl
   : public dia_SystemAdapterFeature,
     public dia_IHeatControl
{
public:
   //! constructor
      dia_SAFeatureHeatControl ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureHeatControl ( tVoid );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IHeatControl methods
   //
   //-------------------------------------------------------------------------

   //! request detailed information about the internal temperatures of the RNS
   virtual tDiaResult getTemperatures ( dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL );  //lint !e1735: checked that default param is equal to base class default param
   //! request detailed information about the internal state of temperature sensor
   virtual tDiaResult getSensorState ( dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL );  //lint !e1735: checked that default param is equal to base class default param
   //! request detailed information about the state of emergency functions
   virtual tDiaResult getFuncState( tVoid );  //lint !e1735: checked that default param is equal to base class default param
   //! set the fan speed of the requested fan
   virtual tDiaResult setFanSpeed (  dia_eFanState fanState, tU8 const fanSpeed, dia_eFanCtrlMode fanEvent );
   //! request detailed information about the internal temperatures of the RNS
   virtual tDiaResult getFanSpeed ( tVoid );

protected:
   //! deprecated default constructor
   dia_SAFeatureHeatControl ( tVoid );

   //! result handle function to react on an incoming CCA message carrying the device temperature
   tVoid vHandleRealTemperature ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleAbstractTemperature ( amt_tclServiceData* poMessage ) const;
   //! result handle function to react on an incoming CCA message carrying the device temperature state
   tVoid vHandleRealSensorState ( amt_tclServiceData* poMessage ) const;
   tVoid vHandleAbstractSensorState ( amt_tclServiceData* poMessage ) const;
   //! result handle function to react on an incoming CCA message carrying the device state of emergency functions
   tVoid vHandleEmergencyFunction ( amt_tclServiceData* poMessage ) const;
   //! result handle function to react on an incoming CCA message carrying the FAN mode control status
   tVoid vHandleFANMode ( amt_tclServiceData* poMessage ) const;
   //!
   dia_eHeatCtrlTemperatureID getTemperatureID ( heatctrl_fi_tcl_e8_SensorID::tenType heatCtrlID ) const;
   //!
   dia_eHeatCtrlTemperatureQuality getDiaQuality (heatctrl_fi_tcl_e8_TemperatureQualityType::tenType heatCtrlQuality) const;
   //!
   //dia_eHeatCtrlEmergencyFuncState getDiaEmergencyFuncState ( midw_fi_tcl_e8_EmergncyFunctionState::tenType diaEmergencyFunctState ) const;
   //!
   //dia_eHeatCtrlEmergencyFuncID getDiaEmergencyFuncID ( midw_fi_tcl_e8_EmergncyFunctionID::tenType heatCtrlEmergencyFuncID ) const;
   //Nandeesh ends here

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureHeatControl)
};

#endif /* DIA_SAFEATUREHEATCONTROL_H_ */
