/*
 * dia_SAFeatureHMINavigationDataUpdate.h
 *
 *  Created on: March 24, 2017
 *      Author: kaa1hi
 */

#ifndef DIA_SAFEATUREHMINAVIGATION_DATA_UPDATE_H_
#define DIA_SAFEATUREHMINAVIGATION_DATA_UPDATE_H_

#include <org/bosch/cm/navigation/NavigationDataUpdateServiceProxy.h>
#include <org/bosch/cm/navigation/NavigationDataUpdateServiceClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION_DATA_UPDATE_LISTENER__
#include <project/interfaces/dia_IHMINavigationDataUpdateListener.h>
#endif

using namespace org::bosch::cm::navigation::NavigationDataUpdateService;


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureHMINavigationDataUpdate
   : public dia_SystemAdapterFeatureASF<NavigationDataUpdateServiceProxy>,
     public NavigationDataUpdateServiceClientBase,
     public dia_IHMINavigationDataUpdate
{
public:
   //! constructor
      dia_SAFeatureHMINavigationDataUpdate (dia_SystemAdapterServicePluginASF<NavigationDataUpdateServiceProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureHMINavigationDataUpdate();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IHMINavigationDataUpdate methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult performFullUpdateViaUSB ( void ) ;
   virtual tDiaResult getNavDataUpdateStatus ( void ) ;

   //-------------------------------------------------------------------------
   //
   // Overloaded NavigationDataUpdateServiceClientBase methods
   //
   //-------------------------------------------------------------------------
   //reply for sendDiagPerformFullUpdateViaUSBRequest
   virtual void onDiagPerformFullUpdateViaUSBError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBError >& error);
   virtual void onDiagPerformFullUpdateViaUSBResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBResponse >& response);

   //replies for sendNavigationDataUpdateStatusInfoGet
   virtual void onNavigationDataUpdateStatusInfoError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoError >& error);
   virtual void onNavigationDataUpdateStatusInfoUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoUpdate >& update);

protected:
   //! to have thread synchronization (we have no impact on ASF thread here)
   virtual void diagPerformFullUpdateViaUSBResponse(const NavigationDataUpdateServiceAck /*ack*/);
   //! to have thread synchronization (we have no impact on ASF thread here)
   virtual void navigationDataUpdateStatusInfoUpdate(const NavigationDataUpdateStatusInfo /*info*/);

   //! deprecated default constructor
   dia_SAFeatureHMINavigationDataUpdate ();
};

#endif /* DIA_SAFEATUREHMINAVIGATION_DATA_UPDATE_H_ */
