/*
 * dia_SAFeatureHMINavigation.h
 *
 *  Created on: May 17, 2016
 *      Author: jas1hi
 /*********************************************************************************************
 * REVISION HISTORY:
 * ------------------------------------------------------------------------------------------------
 * Date 				| Rev. 				| Author 		   	| Modification
 * ------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------
 * 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file

 *******************************************************************************************************************************/

#ifndef DIA_SAFEATUREHMINAVIGATION_H_
#define DIA_SAFEATUREHMINAVIGATION_H_

#include <org/bosch/cm/navigation/NavigationServiceProxy.h>
#include <org/bosch/cm/navigation/NavigationServiceClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMINAVIGATION_LISTENER__
#include <project/interfaces/dia_IHMINavigationListener.h>
#endif

using namespace org::bosch::cm::navigation::NavigationService;


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureHMINavigation
      : public dia_SystemAdapterFeatureASF<NavigationServiceProxy>,
      public NavigationServiceClientBase,
      public dia_IHMINavigation
{
public:
   //! constructor
   dia_SAFeatureHMINavigation (dia_SystemAdapterServicePluginASF<NavigationServiceProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureHMINavigation();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IHMINavigation methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult getRouteCalculationDuration ( tVoid ) ;
   virtual tDiaResult registerToRouteCalculationDuration ( tVoid );
   virtual tDiaResult StartTripReplay(std::string tripfileName);
   virtual tDiaResult StopTripReplay();
   virtual tDiaResult SeekTripReplay();
   virtual tDiaResult registerToTripReplayStatusInfo( tVoid );
   virtual tDiaResult getDatasetVersion ( tVoid) ;
   virtual tDiaResult registerToDatasetVersion ( tVoid );

   //-------------------------------------------------------------------------
   //
   // Overloaded NavigationServiceClientBase methods
   //
   //-------------------------------------------------------------------------
   virtual tVoid onRouteCalculationDurationError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< RouteCalculationDurationError >& error);
   virtual tVoid onRouteCalculationDurationUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< RouteCalculationDurationUpdate >& update);
   virtual tVoid onRouteCalculationDurationUpdate ( tU32 routeCalDurationToFinalDest, tU32 routeCalDurationToNextDest ); //lint !e1411 Warning : Member with different signature hides virtual member


   virtual tVoid onStartTripReplayError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StartTripReplayError >& error);
   virtual tVoid onStartTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StartTripReplayResponse >& response);
   virtual tVoid onStartTripReplayResponse();
   virtual tVoid onStopTripReplayError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StopTripReplayError >& error);
   virtual tVoid onStopTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StopTripReplayResponse >& response);
   virtual tVoid onSeekTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< SeekTripReplayResponse >& response);
   virtual tVoid onStopTripReplayResponse();

   virtual tVoid onTripReplayStatusInfoError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< TripReplayStatusInfoError >& error);
   virtual tVoid onTripReplayStatusInfoUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< TripReplayStatusInfoUpdate >& update);
   virtual tVoid onTripReplayStatusInfoUpdate(TripReplayStatus tripStatus ); //lint !e1411 Warning : Member with different signature hides virtual member

   virtual tVoid onDatasetVersionError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< DatasetVersionError >& error);
   virtual tVoid onDatasetVersionUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< DatasetVersionUpdate >& update);
   virtual tVoid onDatasetVersionUpdate ( const std::string& dataSetVersion );
  
protected:
   //! deprecated default constructor
   dia_SAFeatureHMINavigation ();
};



#endif /* DIA_SAFEATUREHMINAVIGATION_H_ */
