/*
 * dia_SAFeatureHMINavigation.cpp
 *
 *  Created on: May 17, 2016
 *      Author: jas1hi
 /*********************************************************************************************
 * REVISION HISTORY:
 * ------------------------------------------------------------------------------------------------
 * Date 				| Rev. 				| Author 		   	| Modification
 * ------------------------------------------------------------------------------------------------
 *--------------------------------------------------------------------------------------------------------------------
 * 09.02.2017		| 1.1	| NLK1KOR (RBEI)	|  AIVI-28703 Worker class for the Sensor simulation via sensor log file
 
 *******************************************************************************************************************************/

#include "dia_SAFeatureHMINavigation.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

dia_SAFeatureHMINavigation::dia_SAFeatureHMINavigation(dia_SystemAdapterServicePluginASF<NavigationServiceProxy>& pSrvPlugin)
   : dia_SystemAdapterFeatureASF<NavigationServiceProxy>(pSrvPlugin)
{
}

dia_SAFeatureHMINavigation::~dia_SAFeatureHMINavigation() {
   // TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
      // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::getRouteCalculationDuration ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::getRouteCalculationDuration");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendRouteCalculationDurationGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::getRouteCalculationDuration. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::getRouteCalculationDuration. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::registerToRouteCalculationDuration ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::registerToRouteCalculationDuration");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendRouteCalculationDurationRegister(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::registerToRouteCalculationDuration. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::registerToRouteCalculationDuration. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onRouteCalculationDurationError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< RouteCalculationDurationError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onRouteCalculationDurationError");

   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onRouteCalculationDurationError. ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onRouteCalculationDurationError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< RouteCalculationDurationUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate");

   RouteCalculationDuration routeCalculationDuration = update->getRouteCalculationDuration();
   tU32 durationToFinalDest = (tU32)routeCalculationDuration.getRouteCalDurationToFinalDest();
   tU32 durationToNextDest = (tU32)routeCalculationDuration.getRouteCalDurationToNextDest();

   DIA_TR_INF("dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate. toFinalDest: %d, toNextDest: %d", durationToFinalDest, durationToNextDest);

   getInstanceOfApplication()->postMessage (
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorTwoArgsNoReturnValue<dia_SAFeatureHMINavigation, tU32, tU32>(this, &dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate, durationToFinalDest, durationToNextDest)
               )
            );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate ( tU32 routeCalDurationToFinalDest, tU32 routeCalDurationToNextDest )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate(tU32, tU32)");

   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnRouteCalculationDuration(routeCalDurationToFinalDest, routeCalDurationToNextDest);
   }
   else
   {
      DIA_TR_WRN("dia_SAFeatureHMINavigation::onRouteCalculationDurationUpdate. querySysAdapterListener dia_IHMINavigationListener NULL");
   }
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::StartTripReplay(std::string tripfileName)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::StartTripReplay");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {

      act_t token = mpSrvPlugin->getProxy()->sendStartTripReplayRequest(*this, tripfileName);
      if (0 != token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::StartTripReplay. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::StartTripReplay. returned %s", (DIA_SUCCESS == retCode ? "SUCCESS" : "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStartTripReplayError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< RouteCalculationDurationError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStartTripReplayError");
   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnStartTripFileReplayResponse(DIA_FAILED);
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStartTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StartTripReplayResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStartTripReplayResponse");
   
   DIA_TR_INF("dia_SAFeatureHMINavigation::onStartTripReplayResponse");

   getInstanceOfApplication()->postMessage(
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric(
               OSAL_NEW dia_FunctorNoArgsNoReturnValue<dia_SAFeatureHMINavigation>(this, &dia_SAFeatureHMINavigation::onStartTripReplayResponse)
               )
            );
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::StopTripReplay()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::StopTripReplay");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {

      act_t token = mpSrvPlugin->getProxy()->sendStopTripReplayRequest(*this);
      if (0 != token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::StopTripReplay. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::StopTripReplay. returned %s", (DIA_SUCCESS == retCode ? "SUCCESS" : "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::SeekTripReplay()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::SeekTripReplay");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {

      act_t token = mpSrvPlugin->getProxy()->sendSeekTripReplayRequest(*this,0);
      if (0 != token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::SeekTripReplay. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::SeekTripReplay. returned %s", (DIA_SUCCESS == retCode ? "SUCCESS" : "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStopTripReplayError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StopTripReplayError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStopTripReplayError");
   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnStopTripFileReplayResponse(DIA_FAILED);
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStopTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< StopTripReplayResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStopTripReplayResponse");
  
   DIA_TR_INF("dia_SAFeatureHMINavigation::onStopTripReplayResponse");

   getInstanceOfApplication()->postMessage(
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric(
               OSAL_NEW dia_FunctorNoArgsNoReturnValue<dia_SAFeatureHMINavigation>(this, &dia_SAFeatureHMINavigation::onStopTripReplayResponse)
               )
            );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStopTripReplayResponse()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStopTripReplayResponse2");

   SeekTripReplay();
   DIA_TR_INF("dia_SAFeatureHMINavigation::onStopTripReplayResponse2");
   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnStopTripFileReplayResponse(DIA_SUCCESS);
   }
   else
   {
      DIA_TR_WRN("dia_SAFeatureHMINavigation::onStopTripReplayResponse2. querySysAdapterListener dia_IHMINavigationListener NULL");
   }

}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onSeekTripReplayResponse(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< SeekTripReplayResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onSeekTripReplayResponse");

   DIA_TR_INF("dia_SAFeatureHMINavigation::onSeekTripReplayResponse");   
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onStartTripReplayResponse()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onStartTripReplayResponse()");

   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnStartTripFileReplayResponse(DIA_SUCCESS);
   }
   else
   {
      DIA_TR_WRN("dia_SAFeatureHMINavigation::onStartTripReplayResponse. querySysAdapterListener dia_IHMINavigationListener NULL");
   }
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::registerToTripReplayStatusInfo ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::registerToTripReplayStatusInfo");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendTripReplayStatusInfoRegister(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::registerToTripReplayStatusInfo. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::registerToTripReplayStatusInfo. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onTripReplayStatusInfoError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< TripReplayStatusInfoError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onTripReplayStatusInfoError");

   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onTripReplayStatusInfoError. ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onTripReplayStatusInfoError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< TripReplayStatusInfoUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate");
 
   /*if(update->hasValue())
   {*/
   TripReplayStatusInfo tripStatusInfo = update->getTripReplayStatusInfo();

   TripReplayStatus tripStatus;
   tripStatus = tripStatusInfo.getStatus();

   DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: %d",tripStatus);

   getInstanceOfApplication()->postMessage (
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMINavigation,TripReplayStatus>(this, &dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate,tripStatus)
               )
            );
   /*}*/
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate (TripReplayStatus tripStatus )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate(enum)");

   //CID - 87107 Fix
   dia_TripReplayStatus tripStatusInternal = DIA_EN_UNKNOWN;
   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      switch(tripStatus)
      {
      case TripReplayStatus__UNKNOWN:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__UNKNOWN");
         tripStatusInternal = DIA_EN_UNKNOWN;
         break;
      case TripReplayStatus__RESERVED:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__RESERVED");
         tripStatusInternal = DIA_EN_RESERVED;
         break;
      case TripReplayStatus__NOT_ACTIVE:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__NOT_ACTIVE");
         tripStatusInternal = DIA_EN_NOT_ACTIVE;
         break;
      case TripReplayStatus__ACTIVE:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__ACTIVE");
         tripStatusInternal = DIA_EN_ACTIVE;
         break;
      case TripReplayStatus__FILE_NOT_FOUND_ERROR:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__FILE_NOT_FOUND_ERROR");
         tripStatusInternal = DIA_EN_FILE_NOT_FOUND_ERROR;
         break;
      case TripReplayStatus__INTERNAL_ERROR:
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__INTERNAL_ERROR");
         tripStatusInternal = DIA_EN_INTERNAL_ERROR;
         break;
      default :
         DIA_TR_INF("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate Trip Replay Status: TripReplayStatus__UNKNOWN");
         break;

      }
      pListener->vOnTripReplayStatusInfoUpdate(tripStatusInternal);
   }
   else
   {
      DIA_TR_WRN("dia_SAFeatureHMINavigation::onTripReplayStatusInfoUpdate. querySysAdapterListener dia_IHMINavigationListener NULL");
   }
}
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::getDatasetVersion ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::getDatasetVersion");

   tDiaResult retCode = DIA_FAILED;
 
   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendDatasetVersionGet(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::getDatasetVersion. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::getDatasetVersion. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMINavigation::registerToDatasetVersion ( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::registerToDatasetVersion");

   tDiaResult retCode = DIA_FAILED;

   if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
      act_t token = mpSrvPlugin->getProxy()->sendDatasetVersionRegister(*this);
      if (0!=token)
      {
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigation::registerToDatasetVersion. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigation::registerToDatasetVersion. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onDatasetVersionError(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< DatasetVersionError >& error)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onDatasetVersionError");

   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onDatasetVersionError. ErrorName     = \"%s\"", error->getName().c_str() );
   DIA_TR_ERR( "dia_SAFeatureHMINavigation::onDatasetVersionError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------
tVoid dia_SAFeatureHMINavigation::onDatasetVersionUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& proxy, const ::boost::shared_ptr< DatasetVersionUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onDatasetVersionUpdate");
   std::string dataSetVersion =  update ->getDatasetVersion();

   DIA_TR_INF("dia_SAFeatureHMINavigation::onDatasetVersionUpdate. dataSetVersion '%s'", dataSetVersion.c_str());

   getInstanceOfApplication()->postMessage (
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
               OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMINavigation,const std::string&>(this, &dia_SAFeatureHMINavigation::onDatasetVersionUpdate, dataSetVersion)
               )
            );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMINavigation::onDatasetVersionUpdate ( const std::string& dataSetVersion )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigation::onDatasetVersionUpdate(const std::string&)");

   DIA_TR_INF("dia_SAFeatureHMINavigation::onDatasetVersionUpdate(const std::string&): dataSetVersion: '%s'", dataSetVersion.c_str());
   dia_IHMINavigationListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnDataSetVersionStatus(dataSetVersion);
   }
   else
   {
      DIA_TR_WRN("dia_SAFeatureHMINavigation::onDatasetVersionUpdate. querySysAdapterListener dia_IHMINavigationListener NULL");
   }
}
//-----------------------------------------------------------------------------