/*
 * dia_SAFeatureHMIMonitor.h
 *
 *  Created on: Apr 13, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.02.2017		| 1.1	| NLK1KOR (RBEI)	| implemented : AIVI-28509 - Enable Disable HMI Monitor Info

 *-------------------------------------------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREHMIMONITOR_H_
#define DIA_SAFEATUREHMIMONITOR_H_

#include <bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceProxy.h>
#include <bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMIMONITOR_LISTENER__
#include <project/interfaces/dia_IHMIMonitorListener.h>
#endif

using namespace bosch::cm::ai::nissan::hmi::hmimonitorservice::HmiMonitorService;


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureHMIMonitor
   : public dia_SystemAdapterFeatureASF<HmiMonitorServiceProxy>,
     public HmiMonitorServiceClientBase,
     public dia_IHMIMonitor
{
public:
	//! constructor
	dia_SAFeatureHMIMonitor (dia_SystemAdapterServicePluginASF<HmiMonitorServiceProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeatureHMIMonitor();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();

	//-------------------------------------------------------------------------
	//
	// Overloaded dia_IHMIMonitor methods
	//
	//-------------------------------------------------------------------------
	virtual tDiaResult getHMIStartUpTimeInterval ( tVoid );
	virtual tDiaResult getHMIActiveForegroundScene ( tVoid );
	virtual tDiaResult registerToActiveRenderedViewName ( tVoid );
	virtual tDiaResult setHMIMonitorInfoServiceStatus(tBool);
	virtual tDiaResult registerToActiveRenderedUpperViewName ( tVoid );
	virtual tDiaResult getActiveForegroundSceneUpper(tVoid);
	virtual tDiaResult registerToNextActiveAppUpper ( tVoid );
	virtual tDiaResult registerToNextActiveAppLower ( tVoid );
	virtual tDiaResult getNextActiveForegroundSceneUpper( tVoid );
	virtual tDiaResult getNextActiveForegroundSceneLower( tVoid );
	
	//-------------------------------------------------------------------------
	//
	// Overloaded HmiMonitorServiceClientBase methods
	//
	//-------------------------------------------------------------------------
	virtual tVoid onGetActiveForegroundSceneError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetActiveForegroundSceneError >& error);
	virtual tVoid onGetActiveForegroundSceneResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetActiveForegroundSceneResponse >& response);
	virtual tVoid onGetActiveForegroundSceneResponse ( std::string activeSceneName ); //lint !e1411 Warning : Member with different signature hides virtual member

	virtual tVoid onGetStartUpTimeIntervalError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetStartUpTimeIntervalError >& error);
	virtual tVoid onGetStartUpTimeIntervalResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetStartUpTimeIntervalResponse >& response);
	virtual tVoid onGetStartUpTimeIntervalResponse(tU32 startupTimeInterval); //lint !e1411 Warning : Member with different signature hides virtual member

	virtual tVoid onActiveRenderedViewNameError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedViewNameError >& error);
	virtual tVoid onActiveRenderedViewNameUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedViewNameUpdate >& update);
	virtual tVoid onActiveRenderedViewNameUpdate(std::string activeSceneName); //lint !e1411 Warning : Member with different signature hides virtual member

	virtual tVoid onSetHMIInfoServiceStatusError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< SetHMIInfoServiceStatusError >& error);
	virtual tVoid onSetHMIInfoServiceStatusResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< SetHMIInfoServiceStatusResponse >& response);
	virtual tVoid onSetHMIInfoServiceStatusResponse(); //lint !e1411 Warning : Member with different signature hides virtual member
	virtual tVoid onSetHMIInfoServiceStatusError(); //lint !e1411 Warning : Member with different signature hides virtual member
	
	virtual tVoid onActiveRenderedUpperViewNameError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedUpperViewNameError >& error);
	virtual tVoid onActiveRenderedUpperViewNameUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedUpperViewNameUpdate >& update);
	virtual tVoid onActiveRenderedUpperViewNameUpdate( std::string activeUpperSceneName ); //lint !e1411 Warning : Member with different signature hides virtual member
	virtual tVoid onNextActiveAppUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppUpperError >& error);
	virtual tVoid onNextActiveAppUpperUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppUpperUpdate >& update);
	virtual tVoid onNextActiveAppUpperUpdate( std::string nextActiveAppUpper ); //lint !e1411 Warning : Member with different signature hides virtual member
	virtual tVoid onNextActiveAppLowerError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppLowerError >& error);
	virtual tVoid onNextActiveAppLowerUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppLowerUpdate >& update);
	virtual tVoid onNextActiveAppLowerUpdate( std::string nextActiveAppLower ); //lint !e1411 Warning : Member with different signature hides virtual member
    virtual tVoid onGetActiveForegroundSceneUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetActiveForegroundSceneUpperError >& error);
	virtual tVoid onGetActiveForegroundSceneUpperResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetActiveForegroundSceneUpperResponse >& response);	
	virtual tVoid onGetActiveForegroundSceneUpperResponse( std::string activeForegroundSceneUpper);
	virtual tVoid onGetNextActiveAppUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppUpperError >& error);
    virtual tVoid onGetNextActiveAppUpperResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppUpperResponse >& response);
    virtual tVoid onGetNextActiveAppUpperResponse( std::string activeSceneName );
	virtual tVoid onGetNextActiveAppLowerError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppLowerError >& error);
	virtual tVoid onGetNextActiveAppLowerResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppLowerResponse >& response);
	virtual tVoid onGetNextActiveAppLowerResponse( std::string activeSceneName );
protected:  
   //! deprecated default constructor
	dia_SAFeatureHMIMonitor ();
};

#endif /* DIA_SAFEATUREHMIMONITOR_H_ */
