/*
 * dia_SAFeatureHMIMonitor.cpp
 *
 *  Created on: Apr 13, 2016
 *      Author: jas1hi
 *--------------------------------------------------------------------------------------------------------------------
 * 16.02.2017		| 1.1	| NLK1KOR (RBEI)	| implemented : AIVI-28509 - Enable Disable HMI Monitor Info
 * 12.04.2017		| 1.2	| NLK1KOR (RBEI)	| Implemented AIVI-47067  secondary Screen Name,Next Upper application, Next Lower Application names.

 *-------------------------------------------------------------------------------------------------------------------
 */

#include "dia_SAFeatureHMIMonitor.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif


dia_SAFeatureHMIMonitor::dia_SAFeatureHMIMonitor(dia_SystemAdapterServicePluginASF<HmiMonitorServiceProxy>& pSrvPlugin)
	: dia_SystemAdapterFeatureASF<HmiMonitorServiceProxy>(pSrvPlugin)
{
}

//-----------------------------------------------------------------------------

dia_SAFeatureHMIMonitor::~dia_SAFeatureHMIMonitor()
{
	// TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureHMIMonitor::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureHMIMonitor::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMIMonitor::getHMIStartUpTimeInterval ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::getHMIStartUpTimeInterval");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendGetStartUpTimeIntervalRequest(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::getHMIStartUpTimeInterval. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::getHMIStartUpTimeInterval. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMIMonitor::getHMIActiveForegroundScene ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::getHMIActiveForegroundScene");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendGetActiveForegroundSceneRequest(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::getHMIActiveForegroundScene. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::getHMIActiveForegroundScene. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

tDiaResult dia_SAFeatureHMIMonitor::getActiveForegroundSceneUpper ( tVoid )  
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::getActiveForegroundSceneUpper");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendGetActiveForegroundSceneUpperRequest(*this);   
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::getActiveForegroundSceneUpper. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::getActiveForegroundSceneUpper. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

tDiaResult dia_SAFeatureHMIMonitor::registerToActiveRenderedViewName ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::registerToActiveRenderedViewName");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendActiveRenderedViewNameRegister(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::registerToActiveRenderedViewName. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::registerToActiveRenderedViewName. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

tDiaResult dia_SAFeatureHMIMonitor::registerToActiveRenderedUpperViewName ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::registerToActiveRenderedUpperViewName");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendActiveRenderedUpperViewNameRegister(*this);  
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::registerToActiveRenderedUpperViewName. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::registerToActiveRenderedUpperViewName. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}
//------------------------------------------------------------------------------------
tDiaResult dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneUpper ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneUpper");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendGetNextActiveAppUpperRequest(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneUpper. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneUpper. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}
//----------------------------------------------------------------------------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMIMonitor::registerToNextActiveAppUpper ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::registerToNextActiveAppUpper");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendNextActiveAppUpperRegister(*this);  
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::registerToNextActiveAppUpper. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::registerToNextActiveAppUpper. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}
//=============================================================================

tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& /*proxy*/, const ::boost::shared_ptr< GetActiveForegroundSceneError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& /*proxy*/, const ::boost::shared_ptr< GetActiveForegroundSceneResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse");

	std::string activeSceneName = response->getActiveSceneName();
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse. activeSceneName '%s'", activeSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse, activeSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse ( std::string activeSceneName )
{
    dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse(std::string)");

    DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse(std::string): activeSceneName: '%s'", activeSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnHMIActiveForegroundSceneStatus(activeSceneName);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneResponse. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& /*proxy*/, const ::boost::shared_ptr< GetStartUpTimeIntervalError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& /*proxy*/, const ::boost::shared_ptr< GetStartUpTimeIntervalResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse");

	tU32 startupTimeInterval = response->getStartUpTimeInterval();
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse. startupTimeInterval '%d'", startupTimeInterval);

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, tU32>(this, &dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse, startupTimeInterval)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse(tU32 startupTimeInterval)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse(tU32)");

	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse(tU32). startupTimeInterval '%d'", startupTimeInterval);
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnHMIStartupTimeIntervalStatus(startupTimeInterval);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onGetStartUpTimeIntervalResponse. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onActiveRenderedViewNameError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedViewNameError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onActiveRenderedViewNameError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onActiveRenderedViewNameError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedViewNameUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate");

	std::string activeSceneName = update->getActiveRenderedViewName();
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate. activeSceneName '%s'", activeSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate, activeSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate(std::string activeSceneName)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate(std::string)");

	DIA_TR_INF("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate(std::string): activeSceneName: '%s'", activeSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnHMIActiveForegroundSceneStatus(activeSceneName);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onActiveRenderedViewNameUpdate. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMIMonitor::setHMIMonitorInfoServiceStatus(tBool enablestatus)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::setHMIMonitorInfoServiceStatus");
	DIA_TR_INF("dia_SAFeatureHMIMonitor::setHMIMonitorInfoServiceStatus. returned enablestatus = %d", enablestatus);
	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
		act_t token = mpSrvPlugin->getProxy()->sendSetHMIInfoServiceStatusRequest(*this, enablestatus);
		if (0 != token)
		{
			retCode = DIA_SUCCESS;
		}
	}
	else
	{
		DIA_TR_ERR("dia_SAFeatureHMIMonitor::setHMIMonitorInfoServiceStatus. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::setHMIMonitorInfoServiceStatus. returned %s", (DIA_SUCCESS == retCode ? "SUCCESS" : "FAILED"));

	return retCode;
}



//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< SetHMIInfoServiceStatusResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusResponse");
	getInstanceOfApplication()->postMessage(
		OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric(
			OSAL_NEW dia_FunctorNoArgsNoReturnValue<dia_SAFeatureHMIMonitor>(this, &dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusResponse)
			)
		);
}
//-----------------------------------------------------------------------------
tVoid dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< SetHMIInfoServiceStatusError >& error)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError");

	DIA_TR_ERR("dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError");
	getInstanceOfApplication()->postMessage(
		OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric(
			OSAL_NEW dia_FunctorNoArgsNoReturnValue<dia_SAFeatureHMIMonitor>(this, &dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError)
			)
		);

}

//-----------------------------------------------------------------------------
tVoid dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusResponse() {
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusResponse");
}
//-----------------------------------------------------------------------------
tVoid dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError() {
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onSetHMIInfoServiceStatusError");
}
//-----------------------------------------------------------------------------

 tVoid dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedUpperViewNameError >& error) 
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< ActiveRenderedUpperViewNameUpdate >& update) 
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate");

	std::string activeUpperSceneName = update->getActiveRenderedUpperViewName();
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate. activeUpperSceneName '%s'", activeUpperSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
		OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate, activeUpperSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate( std::string activeUpperSceneName )
{
    dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onActiveRenderedUpperViewNameUpdate(std::string)");

    DIA_TR_INF("dia_SAFeatureHMIMonitor::nActiveRenderedUpperViewNameUpdate(std::string): activeUpperSceneName: '%s'", activeUpperSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
			   if(pListener)
	   {
		pListener->vOnHMIActiveForegroundSceneUpperStatus(activeUpperSceneName);
	   }
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onActiveForegroundSceneUpperUpdate. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}

//---------------------------------------------------------------------------------------------------------------------------------------
tDiaResult dia_SAFeatureHMIMonitor::registerToNextActiveAppLower ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::registerToNextActiveAppLower");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendNextActiveAppLowerRegister(*this);  
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::registerToNextActiveAppLower. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::registerToNextActiveAppLower. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}
//------------------------------------------------------------------------------------

tDiaResult dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneLower ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneLower");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendGetNextActiveAppLowerRequest(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneLower. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureHMIMonitor::getNextActiveForegroundSceneLower. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}
//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onNextActiveAppUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppUpperError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppUpperError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onNextActiveAppUpperError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onNextActiveAppUpperError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppUpperUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate");
    if(update->hasNextActiveAppUpper())
	{
		std::string nextActiveSceneName = update->getNextActiveAppUpper();
		DIA_TR_INF("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate. nextUpperSceneName '%s'", nextActiveSceneName.c_str());

	    getInstanceOfApplication()->postMessage (
		OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
	    OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate, nextActiveSceneName)
		 )
	);
	}
	else{
		DIA_TR_ERR("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate. NextactiveSceneName is empty!!!! ");
		
	}


}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate(std::string nextActiveSceneName)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate(std::string)");

	DIA_TR_INF("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate nextUpperSceneName: '%s'", nextActiveSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
	   if(pListener)
	   {
		pListener->vOnHMINextActiveForegroundSceneUpperStatus(nextActiveSceneName);
	   }
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}

//----------------------------------------------------------------------------------------------------------------------------------------------



tVoid dia_SAFeatureHMIMonitor::onNextActiveAppLowerError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppLowerError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppLowerError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onNextActiveAppLowerError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onNextActiveAppLowerError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< NextActiveAppLowerUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate");
    if(update->hasNextActiveAppLower())
	{
		std::string activeSceneName = update->getNextActiveAppLower();
		DIA_TR_INF("dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate.lowerNextSceneName '%s'", activeSceneName.c_str());

	    getInstanceOfApplication()->postMessage (
		OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
	    OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate, activeSceneName)
		 )
	);
	}
	else{
		DIA_TR_ERR("dia_SAFeatureHMIMonitor::onNextActiveAppUpperUpdate. lowerNextSceneName is empty!!!! ");
		
	}


}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate(std::string lowerActiveSceneName)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate(std::string)");

	DIA_TR_INF("dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate lowerNextSceneName: '%s'", lowerActiveSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
	   if(pListener)
	   {
		pListener->vOnHMINextActiveForegroundSceneLowerStatus(lowerActiveSceneName);
	   }
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onNextActiveAppLowerUpdate. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}
//-----------------------------------------------------------------------------


tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppUpperError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppUpperResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse");

	std::string activeSceneName = response->getAppIdUpper(); 
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse.NextUpperName '%s'", activeSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse, activeSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse( std::string activeSceneName )
{
    dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse(std::string)");

    DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse NextUpperName: '%s'", activeSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
	   if(pListener)
	   {
		pListener->vOnHMINextActiveForegroundSceneUpperStatus(activeSceneName);
	   }
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperResponse. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}

//-----------------------------------------------------------------------------


tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppLowerError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetNextActiveAppUpperError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetNextActiveAppLowerResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse");

	std::string lowerNextactiveSceneName = response->getAppIdLower(); 
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse.lowerNextName '%s'", lowerNextactiveSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse, lowerNextactiveSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse( std::string lowerNextActiveSceneName )
{
    dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse(std::string)");

    DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse lowerNextName: '%s'", lowerNextActiveSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
	   if(pListener)
	   {
		pListener->vOnHMINextActiveForegroundSceneLowerStatus(lowerNextActiveSceneName);
	   }
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onGetNextActiveAppLowerResponse. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperError(const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxy, const ::boost::shared_ptr< GetActiveForegroundSceneUpperError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperError");

	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse(const ::boost::shared_ptr< HmiMonitorServiceProxy >& /*proxy*/, const ::boost::shared_ptr< GetActiveForegroundSceneUpperResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse");

	std::string activeUpperSceneName = response->getActiveSceneNameUpper();
	DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse. activeUpperSceneName '%s'", activeUpperSceneName.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMIMonitor, std::string>(this, &dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse, activeUpperSceneName)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse ( std::string activeUpperSceneName )
{
    dia_tclFnctTrace trc("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse(std::string)");

    DIA_TR_INF("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse(std::string): activeUpperSceneName: '%s'", activeUpperSceneName.c_str());
	dia_IHMIMonitorListener* pListener = 0;
	if ((querySysAdapterListener<dia_IHMIMonitorListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnHMIActiveForegroundSceneUpperStatus(activeUpperSceneName);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureHMIMonitor::onGetActiveForegroundSceneUpperResponse. querySysAdapterListener dia_IHMIMonitorListener NULL");
	}
}
