/*
 * dia_SAFeatureFanStatistics.h
 *
 *  Created on: 15.12.2016
 *      Author: stc2hi
 *
 */

#ifndef __INCLUDED_DIA_SAFEATURE_FAN_STATISTICS__
#define __INCLUDED_DIA_SAFEATURE_FAN_STATISTICS__

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibDiagnosisDataListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_FAN_STATISTICS_LISTENER__
#include "project/interfaces/dia_IFanStatisticsListener.h"
#endif

using namespace std;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureFanStatistics
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IFanStatistics,
     public dia_IDiaglibDiagnosisDataListener
{
public:
   //! constructor
   dia_SAFeatureFanStatistics ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureFanStatistics ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual void vOnDiagnosisDataResult ( tU32 u32DiagnosisDataId, tenDiagDataResult enResult, const tDiaglibParamVector& oResult );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IFanStatistics methods
   //
   //-------------------------------------------------------------------------

   //! request the Fan activation statistics
   virtual tDiaResult getFanActivationStatistics ( void );

protected:
   //! deprecated default constructor
   dia_SAFeatureFanStatistics ( void );

   //! handle incoming CCA message
   void vHandleDiagnosisData ( amt_tclServiceData* poMessage ) ;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureFanStatistics)
};

#endif /* __INCLUDED_DIA_SAFEATURE_FAN_STATISTICS__ */
