/*
 * dia_SAFeatureErrorLogNotification.h
 *
 *  Created on: 18.01.2017
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SAFEATURE_ERRORLOG_NOTIFICATION__
#define __INCLUDED_DIA_SAFEATURE_ERRORLOG_NOTIFICATION__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_NOTIFICATION_LISTENER__
#include "project/interfaces/dia_IErrorLogNotificationListener.h"
#endif


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureErrorLogNotification
   : public dia_SystemAdapterFeature,
     public dia_IErrorLogNotification
{
public:
   // constructor
   dia_SAFeatureErrorLogNotification ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   // destructor
   virtual ~dia_SAFeatureErrorLogNotification();

   //
   // Implementation for the dia_IErrorLogNotification methods
   //
   virtual tDiaResult registerDtcStatusChange ( tU8 Group, tU32 DTCNumber, tU8 DTCStatusBitMask );
   virtual tDiaResult unregisterDtcStatusChange ( tU8 Group, tU32 DTCNumber, tU8 DTCStatusBitMask );

private:
   void handleDtcStatusChanged(amt_tclServiceData* poMessage, dia_IErrorLogNotificationListener* pListener) const;

protected:
   //! deprecated default constructor
   dia_SAFeatureErrorLogNotification ( void );

   void vHandleDtcStatusChanged(amt_tclServiceData* poMessage) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureErrorLogNotification)
};

#endif /* __INCLUDED_DIA_SAFEATURE_ERRORLOG_NOTIFICATION__ */
