/************************************************************************
* FILE:           dia_SAFeatureErrorLogNotification.cpp
* PROJECT:        Mazda
* SW-COMPONENT:   fc_diagnosis
* AUTHOR:         Andreas Evers
* DESCRIPTION:    System Adapter for vd_diaglog
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*************************************************************************
* October 2014 - refactoring of file according existing midw-FI
*************************************************************************/

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#include <midw_fi_if.h> //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SAFEATURE_ERRORLOG_NOTIFICATION__
#include "dia_SAFeatureErrorLogNotification.h"
#endif

#ifndef __INCLUDED_DIA_ERROR_INFO_INTERFACE__
#include <common/framework/errmgmt/dia_ErrorInfoInterface.h>
#endif


/*************************************************************************
*
* FUNCTION: MESSAGE MAP and ON_MESSAGE
*
* DESCRIPTION: the function will be called when a message with the corresponding FID arrives
*
* PARAMETER of ON_MESSAGE: FKTID and handle function called by server
*
* RETURNVALUE: none
*
**************************************************************************/

BEGIN_MSG_MAP(dia_SAFeatureErrorLogNotification, dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED,                    vHandleDtcStatusChanged)
END_MSG_MAP()

//-----------------------------------------------------------------------------

dia_SAFeatureErrorLogNotification::dia_SAFeatureErrorLogNotification  (
      tCString name,      // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
   : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureErrorLogNotification::dia_SAFeatureErrorLogNotification");
}
//-----------------------------------------------------------------------------

dia_SAFeatureErrorLogNotification::~dia_SAFeatureErrorLogNotification()
{
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureErrorLogNotification::registerDtcStatusChange(tU8 Group, tU32 DTCNumber, tU8 DTCStatusBitMask)
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogNotification::registerDtcStatusChange");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("DTCNumber = 0x%06X, DTCStatusBitMask = 0x%02X", DTCNumber, DTCStatusBitMask);

   midw_diaglogfi_tclMsgDtcStatusChangedUpReg oData;
   oData.Group = Group;
   oData.DTCNumber = DTCNumber;
   oData.DTCStatusBitMask = DTCStatusBitMask;
   //put the data into message
   fi_tclVisitorMessage oUpRegMsg(oData);
   //construct start message
   mpSrvPlugin->vInitServiceData(oUpRegMsg, MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED, AMT_C_U8_CCAMSG_OPCODE_UPREG);
   if (mpSrvPlugin->bTransmitMessage(&oUpRegMsg) == TRUE)
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("##### REGISTRATION TO DIAGLOG PROPERTY MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED FAILED #####");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureErrorLogNotification::unregisterDtcStatusChange(tU8 Group, tU32 DTCNumber, tU8 DTCStatusBitMask)
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogNotification::unregisterDtcStatusChange");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("DTCNumber = 0x%06X, DTCStatusBitMask = 0x%02X", DTCNumber, DTCStatusBitMask);

   midw_diaglogfi_tclMsgDtcStatusChangedRelUpReg oData;
   oData.Group = Group;
   oData.DTCNumber = DTCNumber;
   oData.DTCStatusBitMask = DTCStatusBitMask;
   //put the data into message
   fi_tclVisitorMessage oUpRegMsg(oData);
   //construct start message
   mpSrvPlugin->vInitServiceData(oUpRegMsg, MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED, AMT_C_U8_CCAMSG_OPCODE_RELUPREG);
   if (mpSrvPlugin->bTransmitMessage(&oUpRegMsg) == TRUE)
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("##### UNREGISTRATION TO DIAGLOG PROPERTY MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED FAILED #####");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureErrorLogNotification::vHandleDtcStatusChanged ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogNotification::vHandleDtcStatusChanged");

   if (poMessage != NULL)
   {
      dia_IErrorLogNotificationListener* pListener = OSAL_NULL;
      if ((querySysAdapterListener<dia_IErrorLogNotificationListener>(&pListener) == DIA_SUCCESS) && pListener)
      {
         // Msg must come from a server
         DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

         tU8 u8OpCode = poMessage->u8GetOpCode();

         switch ( u8OpCode )
         {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               DIA_TR_INF("dia_SAFeatureErrorLogNotification::vHandleDtcStatusChanged => AMT_C_U8_CCAMSG_OPCODE_STATUS");
               handleDtcStatusChanged(poMessage, pListener);
               break;
            }

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               DIA_TR_ERR("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
               mpSrvPlugin->vOnErrorMessage(poMessage);
               break;
            }

            default:
            {
               DIA_TR_ERR( "dia_SAFeatureErrorLogNotification::vHandleDtcStatusChanged: Unexpected OpCode = 0x%02X", u8OpCode);
               break;
            }
         }
      }
      else
      {
         DIA_TR_ERR( "dia_SAFeatureErrorLogNotification::vHandleDtcStatusChanged: Got no listener.");
      }
   }

   if(poMessage != NULL)
   {
      poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureErrorLogNotification::handleDtcStatusChanged(amt_tclServiceData* poMessage, dia_IErrorLogNotificationListener* pListener) const
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogNotification::handleDtcStatusChanged");

   // Get method result data into fi type
   fi_tclVisitorMessage oMsg(poMessage);
   midw_diaglogfi_tclMsgDtcStatusChangedStatus oResultData;
   (tVoid) oMsg.s32GetData(oResultData);

   tU32 DtcNumber = oResultData.DTCResponse.DTC;
   tU8 StatusOfDtc = oResultData.DTCResponse.StatusOfDtc;

   DIA_TR_INF("dia_SAFeatureErrorLogNotification::handleDtcStatusChanged => DtcNumber=0x%06X,StatusOfDtc=0x%02X", DtcNumber, StatusOfDtc);

   // only handle if status = true
   if (DtcNumber != 0)
   {
      pListener->vOnDtcStatusChanged(DtcNumber, StatusOfDtc);
   }
   else
   {
      DIA_TR_ERR("### dia_SAFeatureErrorLogNotification::handleDtcStatusChanged => DtcNumber is ZERO. Error.");
      dia_ErrorInfoInterface err(dia_IErrorLogNotificationListener::getUID());
      err.setErrorCode(DIA_E_CONDITIONS_NOT_CORRECT);
      pListener->vOnError(err);
   }
}
