/*
 * dia_SAFeatureDimmingControl.cpp
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 */
/*-----------------------------------------------------------------------------------------------------
* Date           | Author                              | Modification
* 18.06.2014     | Jeba Satheesh (jse5kor )            | Implementation changed from property to method
*
* 01.12.15    	 | sbr5kor	  		                   | AIVI-12208 & CMG3G-8222                      |
*******************************************************************************************************/
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#include "dia_SAFeatureDimmingControl.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureDimmingControl,dia_SystemAdapterFeature)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureDimmingControl::dia_SAFeatureDimmingControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::dia_SAFeatureDimmingControl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureDimmingControl::~dia_SAFeatureDimmingControl ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimmingControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_DISPLAY_DIMMING_U16);
   results.push_back(IOCONTROLID_KEYBOARD_DIMMING);
   results.push_back(IOCONTROLID_KEYBOARD_PWM);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimmingControl::setKeyIlluminationBrightness( const tU16 brightness )
{
    dia_tclFnctTrace oTrace("dia_SAFeatureDimmingControl::setKeyIlluminationBrightness");

    tDiaResult retCode = DIA_FAILED;

    trParameter param;
    param.enType = static_cast<tenParameterType>(IOCONTROLID_KEYBOARD_DIMMING_SET_PARAM1);
    param.u16Value = brightness;

    tDiaglibParamVector vecRequest;
    vecRequest.push_back(param);

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_KEYBOARD_DIMMING, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE)
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureDimmingControl::setKeyIlluminationBrightness - bIOControlStart - SUCCESS.");
    }
    else
    {
       DIA_TR_ERR("dia_SAFeatureDimmingControl::setKeyIlluminationBrightness - bIOControlStart - FAILED.");
    }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult 
dia_SAFeatureDimmingControl::freezeKeyIlluminationBrightness(tBool bFreeze)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDimmingControl::freezeKeyIlluminationBrightness");

   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   const tenIoControlAction enActionId = (bFreeze == TRUE)? EN_ACTION_FREEZE: EN_ACTION_UNFREEZE;

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_KEYBOARD_DIMMING, enActionId, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureDimmingControl::freezeKeyIlluminationBrightness - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::freezeKeyIlluminationBrightness - bIOControlStart - FAILED.");
   }

  return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimmingControl::setDisplayBrightness ( tU16 pwmValue )
{
	dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::setDisplayBrightness");

   tDiaResult retCode = DIA_FAILED;

   trParameter param;
   param.enType = static_cast<tenParameterType>(IOCONTROLID_DISPLAY_DIMMING_U16_SET_PARAM1);
   param.u16Value = pwmValue;

   tDiaglibParamVector vecRequest;
   vecRequest.push_back(param);

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_DISPLAY_DIMMING_U16, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureDimmingControl::setDisplayBrightness - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::setDisplayBrightness - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureDimmingControl::freezeDisplayBrightness(tBool bFreeze)
{
   dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::freezeDisplayBrightness");

   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   const tenIoControlAction enActionId = (bFreeze == TRUE)? EN_ACTION_FREEZE: EN_ACTION_UNFREEZE;

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_DISPLAY_DIMMING_U16, enActionId, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureDimmingControl::freezeDisplayBrightness - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::freezeDisplayBrightness - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    setKeyIlluminationPWM
*
* DESCRIPTION: send CCA MethodStart message to set key illumination
*
* PARAMETER:   const tU16 - brightness level
*
* RETURNVALUE: TRUE  - post message to Dimming without error
*              FALSE - post message to Dimming server failed
*
******************************************************************************/

tDiaResult
dia_SAFeatureDimmingControl::setKeyIlluminationPWM ( const tU16 brightness )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDimmingControl::setKeyIlluminationPWM");

   tDiaResult retCode = DIA_FAILED;

   trParameter param;
   param.enType = static_cast<tenParameterType>(IOCONTROLID_KEYBOARD_PWM_SET_PARAM1);
   param.u16Value = brightness;

   tDiaglibParamVector vecRequest;
   vecRequest.push_back(param);

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_KEYBOARD_PWM, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureDimmingControl::setKeyIlluminationPWM - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::setKeyIlluminationPWM - bIOControlStart - FAILED.");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult dia_SAFeatureDimmingControl::freezeKeyIlluminationPWM(tBool bFreeze)
{
   dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::freezeKeyIlluminationPWM");

   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   const tenIoControlAction enActionId = (bFreeze == TRUE)? EN_ACTION_FREEZE: EN_ACTION_UNFREEZE;

   if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_KEYBOARD_PWM, enActionId, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureDimmingControl::freezeKeyIlluminationPWM - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::freezeKeyIlluminationPWM - bIOControlStart - FAILED.");
   }

  return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDimmingControl::vHandleIOControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDimmingControl::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult)
{
   dia_tclFnctTrace trc("dia_SAFeatureDimmingControl::vOnIoCtrlResult()");

   dia_IDimmingControlListener* pDimmingControlListener = OSAL_NULL;

   if ((querySysAdapterListener<dia_IDimmingControlListener>(&pDimmingControlListener) == DIA_SUCCESS) && pDimmingControlListener)
   {
      tDiaResult ioControlOK = DIA_FAILED;
      if (enResult == EN_IO_CONTROL_OK)
      {
         DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
         ioControlOK = DIA_SUCCESS;
      }
      else
      {
          DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
      }

      switch (u32IoCtrlId)
      {
         case IOCONTROLID_KEYBOARD_DIMMING:
            DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_KEYBOARD_DIMMING.");

            switch(enActionId)
            {
               case EN_ACTION_FREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_FREEZE.");
                  pDimmingControlListener->vOnKeyBrightnessFreeze(TRUE);
                  break;

               case EN_ACTION_SET:
               {
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_SET.");
                  tU16 u16Result = 0;
                  if (oStartResult.size() == IOCONTROLID_KEYBOARD_DIMMING_RESULT_LEN)
                  {
                     const trParameter resultParam = oStartResult.at(IOCONTROLID_KEYBOARD_DIMMING_RESULT_KeyboardDimmingPermille);
                     if (resultParam.enType == static_cast<tenParameterType>(IOCONTROLID_KEYBOARD_DIMMING_RESULT_PARAM1))
                     {
                        u16Result = resultParam.u16Value;
                        DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - Param = 0x%02x .", u16Result);
                     }
                     else
                     {
                        DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT PARAM CAST FAILED !!");
                     }
                  }
                  else
                  {
                     DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT LEN CHECK FAILED !!");
                  }
                  pDimmingControlListener->vOnKeyBrightnessChangeResult(u16Result);
               }
               break;

               case EN_ACTION_UNFREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_UNFREEZE.");
                  pDimmingControlListener->vOnKeyBrightnessFreeze(FALSE);
                  break;

               default:
                  DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ACTIONID = UNKNOWN.");
                  break;
            }
            break;

         case IOCONTROLID_KEYBOARD_PWM:
            DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_KEYBOARD_PWM.");

            switch(enActionId)
            {
               case EN_ACTION_FREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_FREEZE.");
                  pDimmingControlListener->vOnKeyPWMFreeze(TRUE);
                  break;

               case EN_ACTION_SET:
               {
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_SET.");
                  tU16 u16Result = 0;
                  if (oStartResult.size() == IOCONTROLID_KEYBOARD_PWM_RESULT_LEN)
                  {
                     const trParameter resultParam = oStartResult.at(IOCONTROLID_KEYBOARD_PWM_RESULT_KeyboardDimmingPWMPermille);
                     if (resultParam.enType == static_cast<tenParameterType>(IOCONTROLID_KEYBOARD_PWM_RESULT_PARAM1))
                     {
                        u16Result = resultParam.u16Value;
                        DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - Param = 0x%02x .", u16Result);
                     }
                     else
                     {
                        DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT PARAM CAST FAILED !!");
                     }
                  }
                  else
                  {
                     DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT LEN CHECK FAILED !!");
                  }
                  pDimmingControlListener->vOnKeyPWMChangeResult(u16Result);
               }
               break;

               case EN_ACTION_UNFREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_UNFREEZE.");
                  pDimmingControlListener->vOnKeyPWMFreeze(FALSE);
                  break;

               default:
                  DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ACTIONID = UNKNOWN.");
                  break;
            }
            break;

         case IOCONTROLID_DISPLAY_DIMMING_U16:
            DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_DISPLAY_DIMMING_U16.");

            switch(enActionId)
            {
               case EN_ACTION_FREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_FREEZE.");
                  pDimmingControlListener->vOnDispBrightnessFreeze(TRUE);
                  break;

               case EN_ACTION_SET:
               {
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_SET.");
                  tU16 u16Result = 0;
                  if (oStartResult.size() == IOCONTROLID_DISPLAY_DIMMING_U16_RESULT_LEN)
                  {
                     const trParameter resultParam = oStartResult.at(IOCONTROLID_DISPLAY_DIMMING_U16_RESULT_DisplayDimming);
                     if (resultParam.enType == static_cast<tenParameterType>(IOCONTROLID_DISPLAY_DIMMING_U16_RESULT_PARAM1))
                     {
                        u16Result = resultParam.u16Value;
                        DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - Param = 0x%02x .", u16Result);
                     }
                     else
                     {
                        DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT PARAM CAST FAILED !!");
                     }
                  }
                  else
                  {
                     DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - RESULT LEN CHECK FAILED !!");
                  }
                  pDimmingControlListener->vOnDispBrightnessAck(u16Result);
               }
               break;

               case EN_ACTION_UNFREEZE:
                  DIA_TR_INF("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ActionID = EN_ACTION_UNFREEZE.");
                  pDimmingControlListener->vOnDispBrightnessFreeze(FALSE);
                  break;

               default:
                  DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - ACTIONID = UNKNOWN.");
                  break;
            }
            break;

         default:
            DIA_TR_ERR("dia_SAFeatureRearViewCamera::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
            break;
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureDimmingControl::vOnIoCtrlResult - No listener registered");
   }
}


