/*
 * dia_SAFeatureDimming.h
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 *
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 01.12.15    		| sbr5kor	  		 | AIVI-12208 & CMG3G-8222                    |
 * ------------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREDIMMING_H_
#define DIA_SAFEATUREDIMMING_H_

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

class dia_IDimmingListener;
using namespace std;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureDimming
   : public dia_SystemAdapterFeature,
     public dia_IDimming
{
public:
   //! constructor
   dia_SAFeatureDimming ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureDimming ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDimming methods
   //
   //-------------------------------------------------------------------------

   //! get the current dimming status
   virtual tDiaResult getDimmingStatus ( void ){ return DIA_E_NOT_IMPLEMENTED; }

   //! get the current active brightness as signalled by the car through PWM input
   virtual tDiaResult getWireDimmingInformation ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   //! get the current active keyboard brightness
   virtual tDiaResult getKeyBBrightnessInformation ( void );
   //! get the current active display brightness
   virtual tDiaResult getDispBrightnessInformation ( void );
   //! get the current display illumination mode
   virtual tDiaResult getDisplIlluminationMode ( void );
   //! current status of the dimming mode (evaluated and received from car)
   virtual tDiaResult getDimmingMode ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Provides the current brightness as signalled by the car through PWM input
   virtual tDiaResult getDimmingPWM ( void );
   //! get the current active display panel temperature
   virtual tDiaResult getDispPanelTempInformation ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   //! get the current halfclass information
   virtual tDiaResult getDimmingHalfClassInformation ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Provides the current status of the car's illumination switch and illumination value
   virtual tDiaResult getIlluminationStatus ( void );
   //! get the current light sensor status
   virtual tDiaResult getLightSensorStatus ( void ){ return DIA_E_NOT_IMPLEMENTED; }

   //! set day and night mode
   virtual tDiaResult setDayAndNightMode ( tU8 /*mode*/ ){ return DIA_E_NOT_IMPLEMENTED; }
   //! Asynchronous request to set key illumination brightness
   virtual tDiaResult dia_setKeyIlluminationBrightness ( const tU16 brightness );
   //! set day and night mode
   virtual tDiaResult getDayAndNightMode ( void ){ return DIA_E_NOT_IMPLEMENTED; }

   //! set emulation mode
   virtual tDiaResult setEmulationMode ( tU8 u8Mode );

   //! set display brightness
   virtual tDiaResult setDisplayBrightness ( tU16 pwmValue );

   /*ADDED: rva5cob*/
   //! get the current active keyboard illumination pwm
   virtual tDiaResult getKeyBPwmInformation ( void  );

      /*ADDED: rva5cob*/
    /**
    * \brief   Asynchronous request to set key illumination brightness pwm
    *          param u16Brightness key illumination brightness to set
    *          return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully			   
    *          */
   virtual tDiaResult dia_setKeyIlluminationPWM ( const tU16 brightness );

//   tBool bDayNightModeSetting( tU8 u8Action );
//
//   tBool bSendMessage( tU16 u16FID,
//           const tU8 u8Opcode,
//           tU16 u16Data );

protected:
   //! deprecated default constructor
   dia_SAFeatureDimming ( void );

   void vHandleLightSensorStatus ( amt_tclServiceData* /*poMessage */ ) const {  }
   void vHandleDayNightMode(amt_tclServiceData* /*poMessage */ ) const {  }
   void vHandleDimmingStatus ( amt_tclServiceData* poMessage ) const;
  // void vHandleDimmingInformation ( amt_tclServiceData* poMessage ) const;
   void vHandleKeyBBrightnessInformation ( amt_tclServiceData* poMessage ) const;
   void vHandleDispBrightnessInformation ( amt_tclServiceData* poMessage ) const;
   void vHandleDispPanelTempInformation ( amt_tclServiceData* /*poMessage */ ) const {  }
   void vHandleSetKeyIllumBrightnessInfo ( amt_tclServiceData* poMessage ) const;
   void vHandleSetKeyIllumPwmBrightnessInfo ( amt_tclServiceData* poMessage ) const;
   void vHandleSetBrightnessStatus ( amt_tclServiceData* poMessage ) const;
   void vHandleEmulationModeResult ( amt_tclServiceData* poMessage ) const;
   void vHandlePWMBrightness ( amt_tclServiceData* poMessage ) const;
   void vHandleDimmingState(amt_tclServiceData* poMessage) const;
   void vHandleIlluminationData(amt_tclServiceData* poMessage) const;
   void vHandleDimmingHalfClassInformation ( amt_tclServiceData* /*poMessage */ ) const {  }
   //void vHandleDispBrightnessLevelInformation ( amt_tclServiceData* poMessage ) const;
   //void vHandleSetBrightnessLevelStatus( amt_tclServiceData* poMessage ) const;
   void vHandleDimmingStatusInfo ( amt_tclServiceData* poMessage ) const;
   void vHandleDimmingPWMInfo ( amt_tclServiceData* poMessage ) const;

   void vHandleReadBackLightIllumination ( amt_tclServiceData* poMessage ) const;
   void vHandleSetBackLightIllumination ( amt_tclServiceData* poMessage ) const;
   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureDimming)
};

#endif /* DIA_SAFEATUREDIMMING_H_ */
