/*
 * dia_SAFeatureConfigItem.cpp
 *
 *  Created on: 27.06.2017
 *      Author: abe6kor
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_CONFIGITEM__
#include "dia_SAFeatureConfigItem.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

BEGIN_MSG_MAP( dia_SAFeatureConfigItem, dia_SystemAdapterFeature )
ON_MESSAGE(MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM, vHandleDiagConfigItem)
END_MSG_MAP()


dia_SAFeatureConfigItem::dia_SAFeatureConfigItem (
		tCString name,    // feature name
		dia_SystemAdapterServicePlugin& pSrvPlugin
)
: dia_SystemAdapterFeature(name,pSrvPlugin)
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::dia_SAFeatureConfigItem");
	m_poGWMain = diagnostics_tclApp::getInstance();
}

dia_SAFeatureConfigItem::~dia_SAFeatureConfigItem()
{}

//-----------------------------------------------------------------------------


tVoid
dia_SAFeatureConfigItem::vHandleDiagConfigItem ( amt_tclServiceData* poMessage )
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vHandleDiagConfigItem()");
	if ( m_poGWMain )
	{
		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_GET: /* --- the client asks for some data --- */
		{
			fi_tclVisitorMessage oInVisitorMsg(poMessage);
			midw_diagnosticsfi_tclMsgDiagConfigItemGet oDiagConfigItemGet;
			if (OSAL_OK == oInVisitorMsg.s32GetData(oDiagConfigItemGet))
			{
				tU32 u32CcaConfigItemType = (tU32) oDiagConfigItemGet.ConfigItem;
				DIA_TR_INF("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Trying to read DiagConfigItem entry = 0x%x",u32CcaConfigItemType);

				ahl_tNotification notification = {0,0,0,0};
				notification.u16AppID = poMessage->u16GetSourceAppID();
				notification.u16RegisterID = poMessage->u16GetRegisterID();
				notification.u16CmdCounter = poMessage->u16GetCmdCounter();
				notification.u16SubID = poMessage->u16GetSourceSubID();

				vSendDiagConfigItemEntry(&notification, u32CcaConfigItemType);
			}
			else
			{
				DIA_ASSERT_ALWAYS();
			}
		}
		break;

		case AMT_C_U8_CCAMSG_OPCODE_SET: /* --- the client asks for some data --- */
		{
			fi_tclVisitorMessage oInVisitorMsg(poMessage);
			midw_diagnosticsfi_tclMsgDiagConfigItemSet oDiagConfigItemSet;
			if (OSAL_OK == oInVisitorMsg.s32GetData(oDiagConfigItemSet))
			{
				//CID - 124500 Fix
				ahl_tNotification notification = {0,0,0,0};
				notification.u16AppID = poMessage->u16GetSourceAppID();
				notification.u16RegisterID = poMessage->u16GetRegisterID();
				notification.u16CmdCounter = poMessage->u16GetCmdCounter();
				notification.u16SubID = poMessage->u16GetSourceSubID();

				tU32 u32CcaConfigItemType = (tU32) oDiagConfigItemSet.ConfigItem;
				DIA_TR_INF("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Trying to write DiagConfigItem entry = 0x%x",u32CcaConfigItemType);

				dia_IConfigItem* pConfigItem = 0;
				if ((queryConfMgrInterface<dia_IConfigItem>(&pConfigItem) == DIA_SUCCESS) && pConfigItem)
				{
					tDiaResult retCode = pConfigItem->setConfigItem(u32CcaConfigItemType, oDiagConfigItemSet.ConfigItemContent.itemList);
					if (retCode == DIA_SUCCESS)
					{
						vSendDiagConfigItemEntry(&notification, u32CcaConfigItemType);
					}
					else if (retCode == DIA_E_TEMPORARY_NOT_AVAILABLE)
					{
						DIA_TR_INF("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Start writing Data asynchronously.");

						ahl_tNotification* pCookie = OSAL_NEW ahl_tNotification;
						*pCookie = notification;
						retCode = pConfigItem->setConfigItem(u32CcaConfigItemType, oDiagConfigItemSet.ConfigItemContent.itemList, this, pCookie);
						if (retCode != DIA_SUCCESS)
						{
							DIA_TR_ERR("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Requesting ConfigItem Not asynchronously available.");
						}

					}
					else
					{
						DIA_TR_ERR("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Requesting ConfigItem Not available.");
						vSendError(notification.u16AppID,notification.u16RegisterID,notification.u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
					}
				}
				else
				{
					DIA_TR_ERR("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Requesting ConfigManager queryInterface FAILED.");
					vSendError(notification.u16AppID,notification.u16RegisterID,notification.u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
				}
			}
			else
			{
				DIA_ASSERT_ALWAYS();
			}
		}
		break;
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:   /* ---   upreg: register client  --- */
		{
			if( !bUpreg(poMessage) )
			{
				// create and send error  message
				amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_UPREG_FAILURE);
				m_poGWMain->enPostMessage(&oErrorMessage);
			}
			else
			{
				fi_tclVisitorMessage oInVisitorMsg(poMessage);
				midw_diagnosticsfi_tclMsgDiagConfigItemUpReg oDiagConfigItemUpReg;
				if (OSAL_OK == oInVisitorMsg.s32GetData(oDiagConfigItemUpReg))
				{
					tU32 u32CcaConfigItemType = (tU32) oDiagConfigItemUpReg.ConfigItem;
					DIA_TR_INF("dia_SAFeatureConfigItem::vHandleDiagConfigItem - Trying to read DiagConfigItem entry = 0x%x",u32CcaConfigItemType);

					ahl_tNotification notification = {0,0,0,0};
					notification.u16AppID = poMessage->u16GetSourceAppID();
					notification.u16RegisterID = poMessage->u16GetRegisterID();
					notification.u16CmdCounter = poMessage->u16GetCmdCounter();
					notification.u16SubID = poMessage->u16GetSourceSubID();

					vSendDiagConfigItemEntry(&notification, u32CcaConfigItemType);
				}
				else
				{
					DIA_ASSERT_ALWAYS();
				}
			}

		}
		break;
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: /* ---   unreg: unregister client  --- */
		{
			if( !bRelUpreg(poMessage) )
			{
				// create and send error  message
				amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_RELUPREG_FAILURE);
				m_poGWMain->enPostMessage(&oErrorMessage);
			}
			else
			{
				DIA_ASSERT_ALWAYS();
			}
		}
		break;
		default :
		{
			// create and send error  message
			amt_tclServiceDataError oErrorMessage(*poMessage, AMT_C_U16_ERROR_INVALID_OPCODE);
			m_poGWMain->enPostMessage(&oErrorMessage);
		}
		break;
		}
	}
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureConfigItem::vSendDiagConfigItemEntry ( const ahl_tNotification* pNot, tU32 u32ConfigItem )
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry(const ahl_tNotification*,tU32)");

	if (m_poGWMain != NULL)
	{
		// Reading Data from DiagConfigItem
		tU32 retcode;
		tU32 u32CcaConfigItemType = u32ConfigItem;
		tU8* configItemData = NULL;
		tU16 configItemDatalength;

		dia_IConfigItem* pConfigItem = 0;
		if ((queryConfMgrInterface<dia_IConfigItem>(&pConfigItem) == DIA_SUCCESS) && pConfigItem)
		{
			DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Trying to read ConfigItem entry 0x%x", u32CcaConfigItemType);

			tDiaResult retCode = pConfigItem->getConfigItem(u32CcaConfigItemType,&configItemData,&configItemDatalength);

			if (retCode == DIA_SUCCESS)
			{
				DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Start reading Data.");

				//DIA_TR_INF("CCA msg TX via TTFis: Length: %d Data: %s", configItemDatalength, dia::utils::bin2str(configItemData,configItemDatalength,' ').c_str());
				//DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Data 0x%x ", *configItemData);

				midw_diagnosticsfi_tclMsgDiagConfigItemStatus oMyData;

				for ( tU16 i=0; i<configItemDatalength; i++ )
				{
					oMyData.ConfigItemContent.itemList.push_back(*configItemData++);
				}
				oMyData.ConfigItem = u32CcaConfigItemType;
				oMyData.ConfigItemValid = TRUE;

				//Create some sender message.
				fi_tclVisitorMessage oMyStatusMessage(oMyData);

				//Now add targetting data
				oMyStatusMessage.vInitServiceData(
						CCA_C_U16_APP_DIAGDEBUG,
						pNot->u16AppID,
						AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,  // StreamType
						0,                                  // StreamCounter
						pNot->u16RegisterID ,
						pNot->u16CmdCounter,
						CCA_C_U16_SRV_DIAGDEBUG,
						MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM,
						AMT_C_U8_CCAMSG_OPCODE_STATUS
				);

				// Reply to requester
				if( AIL_EN_N_NO_ERROR != (retcode = m_poGWMain->enPostMessage(&oMyStatusMessage)))
				{
					DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry Reply to Requester : %d",retcode);
					// Error in sending the message
					if (!oMyStatusMessage.bDelete())
					{
						// Error in deleting the message
					}
				}
				else
				{
					DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry Reply to Requester else : %d",retcode);
					//vSendError(pNot->u16AppID,pNot->u16RegisterID,pNot->u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
				}
			}
			else if (retCode == DIA_E_TEMPORARY_NOT_AVAILABLE)
			{
				DIA_TR_INF("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Start reading Data asynchronously.");

				ahl_tNotification* pCookie = OSAL_NEW ahl_tNotification;
				*pCookie = *pNot;
				retCode = pConfigItem->getConfigItem(u32CcaConfigItemType, this, pCookie);
				if (retCode != DIA_SUCCESS)
				{
					DIA_TR_ERR("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Requesting ConfigItem Not asynchronously available.");
				}

			}
			else
			{
				DIA_TR_ERR("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Requesting ConfigItem Not available.");
				vSendError(pNot->u16AppID,pNot->u16RegisterID,pNot->u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
			}
		}
		else
		{
			DIA_TR_ERR("dia_SAFeatureConfigItem::vSendDiagConfigItemEntry - Requesting ConfigManager queryInterface FAILED.");
			vSendError(pNot->u16AppID,pNot->u16RegisterID,pNot->u16CmdCounter,MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
		}

	}
}


void
dia_SAFeatureConfigItem::vOnConfigItemUpdate ( tU32 ConfigItem )
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vOnConfigItemUpdate");

	DIA_TR_INF("INFORM REGISTERED LISTENERS ABOUT UPDATE OF ConfigItem %d", ConfigItem);

	if ( tMapConfigItemEntryNotify.size() )
	{
		std::map<tU32,TNotificationConfigItem>::iterator iter = tMapConfigItemEntryNotify.begin();
		for ( ; iter != tMapConfigItemEntryNotify.end(); iter++)
		{
			if ( ConfigItem == iter->first )
			{
				ahl_tNotification keyNotification = {0,0,0,0};
				keyNotification.u16AppID = iter->second.u16AppID;
				keyNotification.u16RegisterID = iter->second.u16RegisterID;
				keyNotification.u16CmdCounter = iter->second.u16CmdCounter;
				vSendDiagConfigItemEntry(&keyNotification, ConfigItem);
			}
		}
	}
	else
	{
		DIA_TR_INF("NO CONFIGITEM LISTENERS REGISTERED !!!");
	}
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureConfigItem::vOnConfigItemGetComplete( tU32 ConfigItem, tDiaResult retCode, std::vector<tU8>& data, void* cookie)
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vOnConfigItemGetComplete");

	ahl_tNotification* pNot = (ahl_tNotification*) cookie;
	if (pNot)
	{
		midw_diagnosticsfi_tclMsgDiagConfigItemStatus oMyData;
		oMyData.ConfigItem = ConfigItem;
		oMyData.ConfigItemValid = FALSE;

		if (retCode == DIA_SUCCESS)
		{
			oMyData.ConfigItemValid = TRUE;
			oMyData.ConfigItemContent.itemList = data;
		}

		fi_tclVisitorMessage oMyStatusMessage(oMyData);
		oMyStatusMessage.vInitServiceData(
				CCA_C_U16_APP_DIAGDEBUG,
				pNot->u16AppID,
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
				0,
				pNot->u16RegisterID ,
				pNot->u16CmdCounter,
				CCA_C_U16_SRV_DIAGDEBUG,
				MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM,
				AMT_C_U8_CCAMSG_OPCODE_STATUS
		);

		if (m_poGWMain->enPostMessage(&oMyStatusMessage) != AIL_EN_N_NO_ERROR)
		{
			// Error in sending the message
			oMyStatusMessage.bDelete();
		}

		OSAL_DELETE pNot;
	} //if (pNot)
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureConfigItem::vOnConfigItemSetComplete( tU32 ConfigItem, tDiaResult retCode, void* cookie)
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vOnConfigItemSetComplete");

	ahl_tNotification* pNot = (ahl_tNotification*) cookie;
	if (pNot)
	{
		if (retCode == DIA_SUCCESS)
		{
#if 0
			vSendDiagConfigItemEntry(pNot, ConfigItem);
#else
			DIA_ASSERT_ALWAYS();
#endif
		}
		else
		{
		   DIA_TR_ERR("dia_SAFeatureConfigItem::vOnConfigItemSetComplete => retCode = 0x%x!!!", retCode);
			vSendError(pNot->u16AppID, pNot->u16RegisterID, pNot->u16CmdCounter, MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM);
		}

		OSAL_DELETE pNot;
	} //if (pNot)
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureConfigItem::vOnConfigItemSetComplete( tU32 ConfigItem, tDiaResult retCode, std::vector<tU8>& data, void* cookie)
{
   dia_tclFnctTrace trc("dia_SAFeatureConfigItem::vOnConfigItemSetComplete");

   ahl_tNotification* pNot = (ahl_tNotification*) cookie;
   if (pNot)
   {
      midw_diagnosticsfi_tclMsgDiagConfigItemStatus oMyData;
      oMyData.ConfigItem = ConfigItem;
      oMyData.ConfigItemValid = FALSE;

      if (retCode == DIA_SUCCESS)
      {
         oMyData.ConfigItemValid = TRUE;
         oMyData.ConfigItemContent.itemList = data;
      }

      fi_tclVisitorMessage oMyStatusMessage(oMyData);
      oMyStatusMessage.vInitServiceData(
            CCA_C_U16_APP_DIAGDEBUG,
            pNot->u16AppID,
            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
            0,
            pNot->u16RegisterID ,
            pNot->u16CmdCounter,
            CCA_C_U16_SRV_DIAGDEBUG,
            MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM,
            AMT_C_U8_CCAMSG_OPCODE_STATUS
      );

      if (m_poGWMain->enPostMessage(&oMyStatusMessage) != AIL_EN_N_NO_ERROR)
      {
         // Error in sending the message
         oMyStatusMessage.bDelete();
      }

      OSAL_DELETE pNot;
   } //if (pNot)
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureConfigItem::vSendError (
		tU16 u16TargetID,
		tU16 u16RegisterID,
		tU16 u16CmdCounter,
		tU16 u16Fid
)
{
	if ( m_poGWMain )
	{
		gm_tclU8Message oErrorMsg (
				CCA_C_U16_APP_DIAGDEBUG,
				u16TargetID,
				u16RegisterID,
				u16CmdCounter,
				CCA_C_U16_SRV_DIAGDEBUG,
				u16Fid,
				AMT_C_U8_CCAMSG_OPCODE_ERROR
		);
		m_poGWMain->enPostMessage(&oErrorMsg);
	}
}

//-----------------------------------------------------------------------------


tVoid
dia_SAFeatureConfigItem::vNotifyAllClients(fi_tclTypeBase const& oFIData, tU16 u16FuncId)
{
	DIA_TR_INF(("--> dia_SAFeatureConfigItem::vNotifyAllClients"));

	//potclService->vUpdateAllClients(oFIData, u16FuncId);

	if (m_poGWMain && m_poGWMain->m_poNotTable)
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		m_poGWMain->m_poNotTable->vTraceTable(TR_CLASS_DIAGNOSTICS_BASE);

		// Run through the table to find all registered clients
		ahl_tNotification* pNot = m_poGWMain->m_poNotTable->poGetNotificationList(u16FuncId);

		DIA_TR_INF("--> dia_SAFeatureConfigItem::vNotifyAllClients pNot %p",pNot);

		for (; pNot != OSAL_NULL; pNot = pNot->pNext) {
			// construct result message
			fi_tclVisitorMessage oResultMsg(oFIData);
			// initialise result message
			oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
					pNot->u16AppID, // Target
					AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
					0, // StreamCounter
					pNot->u16RegisterID, // RegisterID
					pNot->u16CmdCounter, // nCmdCounter,
					DIA_USED_SRV_ID, // nServiceID,
					u16FuncId, // function ID
					AMT_C_U8_CCAMSG_OPCODE_STATUS, AMT_C_U16_DEFAULT_NULL, pNot->u16SubID);


			// send it
			//vTraceSimple(I_DIA_HMI_UPDATEALLCLIENTS_03);
			if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR) {
				(tVoid) oResultMsg.bDelete();
			}
		}
		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
	}
	else
	{
		DIA_TR_INF(("!!! dia_SAFeatureConfigItem::vNotifyAllClients => ERROR: Null pointer - m_poGWMain or m_poNotTable"));
	}
	DIA_TR_INF(("<-- dia_SAFeatureConfigItem::vNotifyAllClients"));
}

bool
dia_SAFeatureConfigItem::bUpreg(amt_tclServiceData const* poMessage)
{
	dia_tclFnctTrace trc("dia_SAFeatureConfigItem::bUpreg");

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;

	switch(poMessage->u16GetFunctionID())
	{

	case MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM:
	{
		fi_tclVisitorMessage oInVisitorMsg((amt_tclServiceData*) const_cast<amt_tclServiceData*>(poMessage));
		midw_diagnosticsfi_tclMsgDiagConfigItemUpReg oDiagConfigItemUpreg;
		(void)oInVisitorMsg.s32GetData(oDiagConfigItemUpreg);

		tU32 u32CcaConfigItemType = (tU32) oDiagConfigItemUpreg.ConfigItem;

		tMapConfigItemEntryNotify[u32CcaConfigItemType].u16AppID      = poMessage->u16GetSourceAppID();
		tMapConfigItemEntryNotify[u32CcaConfigItemType].u16CmdCounter = poMessage->u16GetCmdCounter();
		tMapConfigItemEntryNotify[u32CcaConfigItemType].u16RegisterID = poMessage->u16GetRegisterID();
		tMapConfigItemEntryNotify[u32CcaConfigItemType].u32CcaSubId   = u32CcaConfigItemType;

		dia_IConfigItem* pConfigItem = 0;
		if (queryConfMgrInterface<dia_IConfigItem>(&pConfigItem) == DIA_SUCCESS)
		{
			pConfigItem->addConfigItemListener(u32CcaConfigItemType,this);
		}

		bRegOpStatus = TRUE;
		break;
	}

	default:
	{
		ahl_bEnterCritical(diagnostics_tclApp::m_hNotTableSem);

		// Add the client to notification table
		bRegOpStatus = m_poGWMain->m_poNotTable->bAddNotification (
				poMessage->u16GetFunctionID(),
				poMessage->u16GetSourceAppID(),
				poMessage->u16GetRegisterID(),
				1,
				poMessage->u16GetCmdCounter(),
				poMessage->u16GetSourceSubID());

		ahl_bReleaseCritical(diagnostics_tclApp::m_hNotTableSem);
		break;
	}
	}

	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//
// FUNCTION:   dia_SAFeatureConfigItem::bRelUpreg
//
// DESCRIPTION:   Removes the sender of the message from the NotifcationTable
//
// PARAMETER:  Relupreg request message
//
// RETURNVALUE:   true  : Client dereqistration successful
//                false : Client deregistration failed
//
///////////////////////////////////////////////////////////////////////////
//
bool
dia_SAFeatureConfigItem::bRelUpreg(amt_tclServiceData const* poMessage)
{
	//   vTraceSimple(I_DIA_HMI_RELUPREG_01);

	if ( (!m_poGWMain) || (!(m_poGWMain->m_poNotTable)) || (!poMessage) ) return false;

	tBool bRegOpStatus = FALSE;

	if(MIDW_DIAGNOSTICSFI_C_U16_DIAGCONFIGITEM == poMessage->u16GetFunctionID())
	{
		fi_tclVisitorMessage oInVisitorMsg((amt_tclServiceData*) const_cast<amt_tclServiceData*>(poMessage));
		midw_diagnosticsfi_tclMsgDiagConfigItemRelUpReg oDiagConfigItemRelUpreg;
		(void)oInVisitorMsg.s32GetData(oDiagConfigItemRelUpreg);

		tU32 u32CcaConfigItemType = (tU32) oDiagConfigItemRelUpreg.ConfigItem;
		tMapConfigItemEntryNotify.erase(u32CcaConfigItemType);

		dia_IConfigItem* pConfigItem = 0;
		if (queryConfMgrInterface<dia_IConfigItem>(&pConfigItem) == DIA_SUCCESS)
		{
			pConfigItem->removeConfigItemListener(u32CcaConfigItemType,this);
		}

		bRegOpStatus = TRUE;
	}

	return (bRegOpStatus == TRUE) ? true : false;
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureConfigItem::vSendStatusMsg
//
//  DESCRIPTION: sends a CCA Status message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//

tVoid
dia_SAFeatureConfigItem::vSendStatusMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData) const
{
	// Check the validity of incoming data
	if (NULL == poMessage)
	{
		return;
	}
	// initialise result message
	vSendMsg(poMessage, oFIData, AMT_C_U8_CCAMSG_OPCODE_STATUS);
}

///////////////////////////////////////////////////////////////////////////
//  FUNCTION:    dia_SAFeatureConfigItem::vSendMsg
//
//  DESCRIPTION: sends a CCA message
//
//  PARAMETER:   poMessage - incoming request
//                oFIData - property data
//                u8OpCode - CCA op code
//
//  RETURNVALUE: NONE
///////////////////////////////////////////////////////////////////////////
//
tVoid
dia_SAFeatureConfigItem::vSendMsg(amt_tclServiceData const* poMessage, fi_tclTypeBase const& oFIData, tU8 u8OpCode) const
{
	// Check the validity of incoming data
	if (NULL == poMessage)
	{
		return;
	}
	// construct result message
	fi_tclVisitorMessage oResultMsg(oFIData);
	// initialise result message
	oResultMsg.vInitServiceData(DIA_USED_APP_ID, // source
			poMessage->u16GetSourceAppID(), // Target
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, // StreamType
			0, // StreamCounter
			poMessage->u16GetRegisterID(), // RegisterID
			poMessage->u16GetCmdCounter(), // nCmdCounter,
			DIA_USED_SRV_ID, // nServiceID,
			poMessage->u16GetFunctionID(), // function ID
			u8OpCode, AMT_C_U16_DEFAULT_NULL, poMessage->u16GetSourceSubID());
	// send it
	if (NULL != m_poGWMain) {
		//      ET_TRACE_ERROR_BIN(DIA_TRACE_CLASS_DIAGNOSTICS_HMI, ET_EN_T16 _ I_DIA_HMI_SENDMSG_03 _ ET_EN_DONE);
		if (m_poGWMain->enPostMessage(&oResultMsg) != AIL_EN_N_NO_ERROR)
		{
			(tVoid) oResultMsg.bDelete();
		}
	}
}

//-----------------------------------------------------------------------------


