/*
 * dia_SAFeatureClock.cpp
 *
 *  Created on: 08.03.2016
 *      Author: gpu2kor
 *--------------------------------------------------------------------------------------------------------------------
 * NCG3D-44304      | 2.0	| NLK1KOR (RBEI  )	| Implemented PIVI-4292 Communication (connection) status
 *--------------------------------------------------------------------------------------------------------------------
 */

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#include "clock_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef DIA_SAFEATURE_CLOCK_H_
#include "dia_SAFeatureClock.h"
#endif

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureClock, dia_SystemAdapterFeature)
   ON_MESSAGE(CLOCK_MAINFI_C_U16_CONNECTION, vHandleSWCConnectionState)
END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureClock::dia_SAFeatureClock (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureClock::dia_SAFeatureClock");
}

//-----------------------------------------------------------------------------

dia_SAFeatureClock::~dia_SAFeatureClock ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureClock::getSWCConnectionInfo ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureClock::getSWCConnectionInfo");

    tDiaResult retCode = DIA_FAILED;

    gm_tclEmptyMessage oMessage (
       mAppID,
       mpSrvPlugin->getClientID(),
       mpSrvPlugin->getRegistrationID(),
       0,
       mpSrvPlugin->getServiceID(),
       CLOCK_MAINFI_C_U16_CONNECTION,
       CCA_C_U8_OPCODE_GET
    );

    if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureClock::getSWCConnectionInfo - transmitMessage success.");
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureClock::getSWCConnectionInfo - transmitMessage failed.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------


tVoid
dia_SAFeatureClock::vHandleSWCConnectionState ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureClock::vHandleSWCConnectionState");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            fi_tclVisitorMessage oStatusMessage(poMessage);
            clock_mainfi_tclMsgConnectionStatus oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - Received Connection State");
            DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - Connected = %d", oStatusMsgData.SWCUnitConnectionStatus.bConnected);
            DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - Absence = 0x%02x", oStatusMsgData.SWCUnitConnectionStatus.u8AbsenceState);
            DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - Mute = 0x%02x", oStatusMsgData.SWCUnitConnectionStatus.u8MuteState);

            dia_ISWControlListener* pSWCListener = OSAL_NULL;
            querySysAdapterListener<dia_ISWControlListener>(&pSWCListener);
            if ( pSWCListener )
            {
               dia_SWCConnectionInfo swcInfo;

               swcInfo.setAbsentState(oStatusMsgData.SWCUnitConnectionStatus.u8AbsenceState);
			   swcInfo.setConnectionState(oStatusMsgData.SWCUnitConnectionStatus.bConnected);
               pSWCListener->vOnSWCConnectionInfo(swcInfo);
               DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - connection info forwarded to SWC listener");
            }
            else
            {
            	DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - No Clock listener registered. Discarded!");
            }
        }
        break;

    case AMT_C_U8_CCAMSG_OPCODE_ERROR:
        {
        	DIA_TR_INF("dia_SAFeatureClock::vHandleSWCConnectionState - Message with opcode error received");
        }
        break;

    default:
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();

}

//-----------------------------------------------------------------------------


tDiaResult
dia_SAFeatureClock::registerToSWCConnectionInfo ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureClock::registerToSWCConnectionInfo");

    tDiaResult retCode = DIA_FAILED;

    gm_tclEmptyMessage oMessage (
       mAppID,
       mpSrvPlugin->getClientID(),
       mpSrvPlugin->getRegistrationID(),
       0,
       mpSrvPlugin->getServiceID(),
       CLOCK_MAINFI_C_U16_CONNECTION,
       CCA_C_U8_OPCODE_UPREG
    );

    if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureClock::registerToSWCConnectionInfo - transmitMessage success.");
    }
    else
    {
       DIA_TR_INF("dia_SAFeatureClock::registerToSWCConnectionInfo - transmitMessage failed.");
    }

    return retCode;
}
