/*
 * dia_SAFeatureClearMCANHistory.h
 *
 *  Created on: 30.11.2015
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include <common/framework/sysadapters/dia_SAFeatureSystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_MCAN_HISTORY__
#include "dia_SAFeatureClearMCANHistory.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

static const dia_SystemSettingsModuleTypeInfo arSystemSettingsModuleTypeInfo[] = {
      { DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CLEAR_MCAN_HISTORIES,  DIA_C_STR_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES,   DIA_C_UID_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES }
};

//-----------------------------------------------------------------------------

dia_SAFeatureClearMCANHistory::dia_SAFeatureClearMCANHistory (
   tCString name,
   tU32 u32SystemSetId,
   tU32 u32SystemSetTypes,
   dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin),
      dia_SystemSettingsModule(name,u32SystemSetTypes),
      mSystemSettingTypeUID(0),
      mu32SystemSetId(u32SystemSetId),
      mu32SystemSetTypes(u32SystemSetTypes)
{
   this->dia_SystemSettingsModule::loadSystemSettingsModuleTypeInfo(arSystemSettingsModuleTypeInfo,(tU16) (sizeof(arSystemSettingsModuleTypeInfo)/sizeof(dia_SystemSettingsModuleTypeInfo)));
}

//-----------------------------------------------------------------------------

dia_SAFeatureClearMCANHistory::~dia_SAFeatureClearMCANHistory ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureClearMCANHistory::prepareSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& extData )
{
   dia_tclFnctTrace trc("dia_SAFeatureClearMCANHistory::prepareSystemSetting()");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("Prepare system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!",getName(),typeUID);
   mSystemSettingTypeUID = typeUID;

   if ( isSystemSettingTypeSupported(typeUID) ) {
      // if Clear MCAN History type is called do nothing in the prepare state and set state machine to execute state
      if(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES) {
         retCode = DIA_SUCCESS;
         getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,retCode);
      } else {
         retCode = this->dia_SystemSettingsModule::prepareSystemSetting(typeUID, extData);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureClearMCANHistory::prepareSystemSetting System setting type is not supported !!!");
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureClearMCANHistory::finalizeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& extData )
{
   dia_tclFnctTrace trc("dia_SAFeatureClearMCANHistory::finalizeSystemSetting()");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("Finalize system setting (module=\"%s\", typeUID=0x%08x) -- THIS MODULE DOES NOT SUPPORT EXTENDED DATA !!", getName(), typeUID);
   mSystemSettingTypeUID = typeUID;

   if (isSystemSettingTypeSupported(typeUID)) {
      // if Clear MCAN History type is called do nothing in the prepare state and set state machine to finish state
      if (typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_CLEAR_MCAN_HISTORIES) {
         retCode = DIA_SUCCESS;
         getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this, mSystemSettingTypeUID, DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE, retCode);
      } else {
         retCode = this->dia_SystemSettingsModule::finalizeSystemSetting(typeUID, extData);
      }
   } else {
      DIA_TR_INF("dia_SAFeatureClearMCANHistory::finalizeSystemSetting System setting type is not supported !!!");
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,mSystemSettingTypeUID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

