/**
 * \file        dia_SAFeatureCCA.h
 * \author      gib2hi, eva2hi
 * \brief       Header File for CCA SystemAdapter and CCA Info structure
 *
 * COPYRIGHT:    (c) 2006 Robert Bosch GmbH, Hildesheim
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_CCA__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_CCA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_CCA__
#include "common/depricated/SystemAdapter/dia_ISystemCCA.h"
#endif

//class dia_SystemAdapterBase;
class dia_SystemAdapter;

struct CCAInfo
{
    CCAInfo ( void );
//    CCAInfo ( tU16 _appID, tU16 _srvID, dia_SystemAdapterBase* pSysAdapter );
    CCAInfo ( tU16 _appID, tU16 _srvID, dia_SystemAdapter* pSysAdapter );

    tU16 appID;
    tU16 srvID;
//    dia_SystemAdapterBase* sysAdapter;
    dia_SystemAdapter* sysAdapter;
};

/**
 * \class       dia_SAFeatureCCA
 * \brief       Implements the System CCA Interface
 *
 * Handles certain CCA specific requests and forwards them
 * to the correct system adapter
 *
 * COPYRIGHT:    (c) 2006 Robert Bosch GmbH, Hildesheim
 */
class dia_SAFeatureCCA
    : public dia_ISystemCCA
{
public:
    //! singleton accessor
    static dia_SAFeatureCCA* getInstance ( void );
    //! class destructor
    virtual ~dia_SAFeatureCCA ( void );

    //
    // implementation for dia_ISystemCCA interface
    //

    //! called from framework to log registration details
    virtual tDiaResult onRegistrationID ( tU16 u16RegID, tU16 u16AppID, tU16 u16SrvID, tU16 u16SrcSubID );

    //! called when the state of a service has changed
    virtual tDiaResult onServiceState ( tU16 u16SrvID, tU16 u16AppID, tU16 u16RegID, tU8 u8SrvState, tU16 u16SubId);

    //! Dispatcher for messages - call this function if there's a new message to dispatch
    virtual tDiaResult onDispatchMessage(amt_tclBaseMessage *pBaseMessage);

    //! set info about the given application
//    virtual tDiaResult setInfo ( tU16 appID, tU16 srvID, dia_SystemAdapterBase* pAdapter );
    virtual tDiaResult setInfo ( tU16 appID, tU16 srvID, dia_SystemAdapter* pAdapter );

    virtual size_t getNumberOfSystemAdapters ( void ) { return mInfoRep.size(); }

protected:
    //! default class constructor
    dia_SAFeatureCCA ( void );

protected:
    //! pointer to the singleton object
    static dia_SAFeatureCCA* mpInstance;
    //! map that stores application info
    std::map<tU32,CCAInfo*> mInfoRep;
};

#endif
