
#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_CCA__
#include "dia_SAFeatureCCA.h"
#endif

using namespace std;

dia_SAFeatureCCA*
dia_SAFeatureCCA::mpInstance = OSAL_NULL;

#undef  DIA_FILE_CURRENT
#define DIA_FILE_CURRENT   DIA_FILE_U16_SA_CCA

//------------------------------------------------------------------------------

CCAInfo::CCAInfo ( tVoid )
    : appID(0),
      srvID(0),
      sysAdapter(0)
{}

//------------------------------------------------------------------------------

//CCAInfo::CCAInfo ( tU16 _appID, tU16 _srvID, dia_SystemAdapterBase* pSysAdapter )
CCAInfo::CCAInfo ( tU16 _appID, tU16 _srvID, dia_SystemAdapter* pSysAdapter )
    : appID(_appID),
      srvID(_srvID),
      sysAdapter(pSysAdapter)
{}

//------------------------------------------------------------------------------

dia_SAFeatureCCA*
dia_SAFeatureCCA::getInstance ( tVoid )
{
    if ( !mpInstance )
    {
        mpInstance = OSAL_NEW dia_SAFeatureCCA;
    }
    return mpInstance;
}

//------------------------------------------------------------------------------

dia_SAFeatureCCA::dia_SAFeatureCCA ( tVoid )
{}

//------------------------------------------------------------------------------

dia_SAFeatureCCA::~dia_SAFeatureCCA ( tVoid )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureCCA::onRegistrationID ( tU16 regID, tU16 appID, tU16 srvID, tU16 subId )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureCCA::onRegistrationID");

    tDiaResult retCode = DIA_FAILED;

    DIA_TR_INF("--- dia_SAFeatureCCA::onRegistrationID: RegID=0x%0x AppID=0x%0x SrvID=0x%0x !!", regID, appID, srvID );

    tU32 key = (((tU32) AMT_C_U16_APPID_INVALID) << 16) | srvID;
    map<tU32,CCAInfo*>::iterator iter = mInfoRep.find(key);
    if ( (iter != mInfoRep.end()) && iter->second && iter->second->sysAdapter)
    {
       DIA_TR_INF("--- dia_SAFeatureCCA::onRegistrationID: Found a previously unknown application to support SrvID=0x%0x !!", srvID );

       CCAInfo* pInfo = iter->second;
       dia_SystemAdapter* sysAdapter = pInfo->sysAdapter;
       delete pInfo;
       mInfoRep.erase(iter);
       setInfo(appID, srvID, sysAdapter);
    }

    key = (((tU32) appID) << 16) | srvID;
    iter = mInfoRep.find(key);
    if ( iter != mInfoRep.end() )
    {
        CCAInfo* pInfo = iter->second;
        if ( pInfo && pInfo->sysAdapter )
        {
            DIA_TR_INF("--- dia_SAFeatureCCA::onRegistrationID: Forwarding registration to associated system adapter!");
            pInfo->sysAdapter->vLogRegistrationID(regID,appID,srvID,subId);
            retCode = DIA_SUCCESS;
        }
    }
    else
    {
        DIA_TR_ERR("!!! dia_SAFeatureCCA::onRegistrationID: No system adapter found !!!");
    }

    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureCCA::onServiceState ( tU16 srvID, tU16 appID, tU16 regID, tU8 srvState, tU16 subId )
{
	dia_tclFnctTrace oTrace("dia_SAFeatureCCA::onServiceState");

    tDiaResult retCode = DIA_FAILED;

    DIA_TR_INF("--- dia_SAFeatureCCA::onServiceState: SrvState=%d AppID=0x%0x SrvID=0x%0x) !!", srvState, appID, srvID);

    tU32 key = (((tU32) appID) << 16) | srvID;
    map<tU32,CCAInfo*>::iterator iter = mInfoRep.find(key);
    if ( iter != mInfoRep.end() )
    {
        CCAInfo* pInfo = iter->second;
        if ( pInfo && pInfo->sysAdapter )
        {
            DIA_TR_INF("--- dia_SAFeatureCCA::onServiceState: Forwarding service state change to associated system adapter!");
            pInfo->sysAdapter->vOnServiceState(srvID,appID,regID,srvState,subId);
            retCode = DIA_SUCCESS;
        }
    }
    else
    {
        DIA_TR_INF("--- dia_SAFeatureCCA::onServiceState: No system adapter found !!");
    }

    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureCCA::onDispatchMessage ( amt_tclBaseMessage *pMessage )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureCCA::onDispatchMessage");

    tDiaResult retCode = DIA_FAILED;

    // check if the received message is a AMT Service data message
    if ( pMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA )
    {
       // Received message is a AMT Service data message

       // cast the received message to a AMT Service data message so we can
       // access the standard members
       amt_tclServiceData oServiceData(pMessage);

       tU16 srvID = oServiceData.u16GetServiceID();
       tU16 appID = oServiceData.u16GetSourceAppID();
       tU16 fctID = oServiceData.u16GetFunctionID();

       DIA_TR_INF("--- dia_SAFeatureCCA::onDispatchMessage: AppID=0x%04x SrvID=0x%04x FuncID=0x%04x !!", appID, srvID, fctID);

       if (srvID == CCA_C_U16_SRV_DIAGDEBUG)
             {
    	   DIA_TR_INF("dia_SAFeatureCCA::onDispatchMessage CCA_C_U16_SRV_DIAGDEBUG ");
                //Special handling for our own service - allow any application to access it by mapping to CCA_C_U16_APP_FC_DIAGNOSIS
                appID = CCA_C_U16_APP_DIAGDEBUG; //CCA_C_U16_APP_FC_DIAGNOSIS;
             }
       tU32 key = (((tU32) appID) << 16) | srvID;
       map<tU32,CCAInfo*>::iterator iter = mInfoRep.find(key);
       if ( iter != mInfoRep.end() )
       {
           CCAInfo* pInfo = iter->second;
           if ( pInfo && pInfo->sysAdapter )
           {
               DIA_TR_INF("--- dia_SAFeatureCCA::onDispatchMessage: Forwarding CCA message to associated system adapter!");
               pInfo->sysAdapter->vDispatchMessage(&oServiceData);
               retCode = DIA_SUCCESS;
           }
       }
    }

    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureCCA::setInfo ( tU16 appID, tU16 srvID, dia_SystemAdapter* pAdapter )
//dia_SAFeatureCCA::setInfo ( tU16 appID, tU16 srvID, dia_SystemAdapterBase* pAdapter )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureCCA::setInfo");

    tDiaResult retCode = DIA_FAILED;

    DIA_TR_INF("--- dia_SAFeatureCCA: Setting SystemAdapter Information (appID=%d,srvID=%d,ptr=%p) !!", appID, srvID, pAdapter );

    if ( pAdapter == OSAL_NULL)
    {
        retCode = DIA_E_INVALID_POINTER;
    }
    else
    {
        tU32 key = (((tU32) appID) << 16) | srvID;

        std::map<tU32,CCAInfo*>::iterator iter = mInfoRep.find(key);
        if ( iter == mInfoRep.end() )
        {
            CCAInfo* pInfo = new CCAInfo(appID, srvID, pAdapter);
            if( OSAL_NULL != pInfo )
            {
               pInfo->appID  = appID;
               pInfo->srvID  = srvID;
               mInfoRep[key] = pInfo;
               retCode = DIA_SUCCESS;
            }
        }
        else
        {
           DIA_TR_ERR("Can not create CCAInfo. Key Already exists." );
        }
    }

    return retCode;
}
