/*
 * dia_SAFeatureBluetooth.cpp
 *
 *  Created on: 09.02.2012
 *      Author: gib2hi
 * * * * * * * * * * * * * * * * * * * * *
 *  Last Changed on: 20.05.2014
 *  Changed by: GPU2KOR
 *  Change Desc: Implementation changed to Type-I routine control from Type-II routine control.
             BT MAC address removed from vStartConnectBluetoothDeviceAddress function argument list.
 *--------------------------------------------------------
 * Date           | Author             | Modification
 * 28.05.14        | GPU2KOR          | vStartConnectBluetoothDeviceAddress changed to extract 6 byte BT address.
 *                                             AntennaField strength functon modified.
 * 13.06.14       | GPU2KOR          | Updated BT mode set.
 * 28-12-2015     | nce5kor			  | Commented the code for customer bt signal quality.
										New CCA implementation will be provided with next release.
 * 15-01-2016     | nce5kor			  |	added new listener calls for Customer specific read Wifi and BT address service handlers.
 *************************************************************************/

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureBluetooth.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include <project/framework/sysadapters/dia_SAFeatureDiaglib.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureBluetooth.cpp.trc.h"
#endif

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_ERRORCODES
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define DIA_C_U16_MAX_BT_ADDR_SIZE     ((tU16) 512)
#define EN_BT_CONNECTED          0x01
#define EN_BT_DISCONNECTED         0x00

// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

BEGIN_MSG_MAP(dia_SAFeatureBluetooth, dia_SystemAdapterFeatureDiaglib)
    ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl)
    ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT, vHandleRoutineControl)
    ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA, vHandleDiagnosisData)
END_MSG_MAP()

#if 0 //STC2HI: TODO
BEGIN_MSG_MAP(dia_SAFeatureBluetooth, dia_SystemAdapterFeature)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DIAGNOSIS_MUTE_INDICATION,                 vHandleTelephoneMuteIndication)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_BT_TEST_MODE,                              vHandleBlueToothModeStatus)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_SET_BT_TEST_MODE,                          vHandleBlueToothModeResult)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_EX_START_CONNECTION,                       vHandleBlueToothConnectResult)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_EX_STOP_CONNECTION,                        vHandleBlueToothDisconnectResult)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY,        vHandleBTLinkQualityResult)
//    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DEV_BT_LINK_INFO,                          vHandleBTLinkInfo)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_BTM_TEST_LOCAL_LOOPBACK_HCI_MODE,          vHandleBTLocalLoopbackResult)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_BTM_TEST_ACTION,                           vHandleBTTestActionResult)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_BTM_TEST_ACTION,                           vHandleBTTestActionStatus)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DEV_LOCAL_BT_DEVICE_VERSION_INFO,          vHandleBlueToothDeviceVersion)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_CONNECTED_BT_DEVICES,                      vHandleBlueToothConnectedDevices)
    ON_MESSAGE(MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_DEV_SET_BT_RESET_PIN_STATUS,               vHandleBlueToothModuleResetResult)
END_MSG_MAP()
#endif //STC2HI: TODO

#if 0 //STC2HI: TODO
static tU16 arBTFIDMapping[DIA_EN_BT_NOTIFICATION_COUNT] = {
        0xFFFF,
        MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_BT_TEST_MODE,
        MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_BTM_TEST_ACTION,
        0xFFFF /* TODO: removed MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_EX_START_CONNECTION_RESULT*/,
        0xFFFF /* TODO: removed MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY_RESULT*/,
        0xFFFF /* TODO: removed MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_EX_STOP_CONNECTION_RESULT*/
};
#endif //STC2HI: TODO

//------------------------------------------------------------------------------

dia_SAFeatureBluetooth::dia_SAFeatureBluetooth (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::dia_SAFeatureBluetooth");
   for (int i=0; i<6; i++)
   {
     u8BDAddress[i] = 0x00;
   }
}

//-----------------------------------------------------------------------------

dia_SAFeatureBluetooth::~dia_SAFeatureBluetooth ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(DATAID_BD_ADDRESS_MAC);
   results.push_back(DATAID_BD_ADDRESS_BLUETOOTH_DEVICE);
   results.push_back(DATAID_BD_GET_LINKQUALITY_1);
   results.push_back(DATAID_BD_GET_LINKQUALITY_2);
   results.push_back(DATAID_BD_CONNECTED_DEVICE_STATUS_1);
   results.push_back(DATAID_BD_CONNECTED_DEVICE_STATUS_2);
   results.push_back(DATAID_BD_GET_AUTHENTICATED_DEVICES);
   results.push_back(ROUTINEID_BD_ANTENNA_FIELDSTRENGTH);
  //results.push_back(ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH);
   results.push_back(ROUTINEID_BD_WIFI_ANTENNA_SNR);
   results.push_back(ROUTINEID_BD_CONNECTION);
   //results.push_back(DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH);
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------
tDiaResult
dia_SAFeatureBluetooth::vGetBluetoothMacAddress ()
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetBluetoothMacAddress");

   //tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_ADDRESS_MAC, mpSrvPlugin);
   //Correcting the DATAID to be sent to BT component to get BT address
   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_ADDRESS_BLUETOOTH_DEVICE, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetBluetoothMacAddress => post the message to Diaglib %d",retCode);

   return retCode;
}

//------------------------------------------------------------------------------
tDiaResult
dia_SAFeatureBluetooth::vGetWifiMacAddress ()
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetWifiMacAddress");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_ADDRESS_MAC, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetWifiMacAddress => post the message to Diaglib %d",retCode);

   return retCode;
}

//------------------------------------------------------------------------------
tDiaResult
dia_SAFeatureBluetooth::getWifiSNR ( const tU8* pabBDAddress)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getWifiSNR");

   tDiaglibParamVector vecRequest(ROUTINEID_BD_WIFI_ANTENNA_SNR_START_LEN);

   tU8 iVecIndex = ROUTINEID_BD_WIFI_ANTENNA_SNR_START_au8BDAddress;
   for(tU8 iArrayIndex=0; iArrayIndex < ROUTINEID_BD_WIFI_ANTENNA_SNR_START_PARAM1_LEN; ++iArrayIndex)
   {
       vecRequest[iVecIndex].enType  = (tenParameterType)(EN_PARAMETER_TYPE_U8);//EN_PARAMETER_TYPE_ARRAY_U8; EN_PARAMETER_TYPE_U8;
       vecRequest[iVecIndex].u8Value = static_cast<tU8>(pabBDAddress[iArrayIndex]);
       ++iVecIndex;
   }

   tBool bRetVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_BD_WIFI_ANTENNA_SNR, 0, vecRequest, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   ETG_TRACE_USR4_THR(("--- dia_SAFeatureBluetooth::getWifiSNR => post the message to Diaglib %d",retCode));

   ETG_TRACE_USR3_THR(("<-- dia_SAFeatureBluetooth::getWifiSNR (%x)",retCode));
   return retCode;
}


//----------------------------------------------------------------------------------------
#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetBluetoothDeviceAddress ()
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetBluetoothDeviceAddress");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_ADDRESS_BLUETOOTH_DEVICE, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetBluetoothDeviceAddress => post the message to Diaglib %d",retCode);

   return retCode;
}
#endif
//------------------------------------------------------------------------------
#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetConnectedDeviceStatus (const tU8 u8Device)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetConnectedDeviceStatus");
   tBool bRetVal = FALSE;

   switch(u8Device)
   {
      case 1:
      {
         bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_CONNECTED_DEVICE_STATUS_1, mpSrvPlugin);
         break;
      }
      case 2:
      {
         bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_CONNECTED_DEVICE_STATUS_2, mpSrvPlugin);
         break;
      }
      default:
      {
         DIA_TR_ERR("dia_SAFeatureBluetooth::vGetConnectedDeviceStatus => ERROR: Invalid device %d",u8Device);
         break;
      }
   }

   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetConnectedDeviceStatus => post the message to Diaglib %d",retCode);

   return retCode;
}
#endif
//------------------------------------------------------------------------------

#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetDeviceLinkQuality (const tU8 u8Device)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetDeviceLinkQuality");
   tBool bRetVal = FALSE;

   switch(u8Device)
   {
      case 1:
      {
         bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_GET_LINKQUALITY_1, mpSrvPlugin);
         break;
      }
      case 2:
      {
         bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_GET_LINKQUALITY_2, mpSrvPlugin);
         break;
      }
      default:
      {
         DIA_TR_ERR("dia_SAFeatureBluetooth::vGetDeviceLinkQuality => ERROR: Invalid device %d",u8Device);
         break;
      }
   }

   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetDeviceLinkQuality => post the message to Diaglib %d",retCode);

   return retCode;
}
#endif
//------------------------------------------------------------------------------

#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetAuthenticatedDevicesPresent (void)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetAuthenticatedDevicesPresent");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_BD_GET_AUTHENTICATED_DEVICES, mpSrvPlugin);

   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetAuthenticatedDevicesPresent => post the message to Diaglib %d",retCode);


   return retCode;
}
#endif
//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::vGetBluetoothFieldstrength ( const tU8* const pabBDAddress)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetBluetoothFieldstrength");

   tDiaglibParamVector vecRequest(ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_START_LEN);
   char outputstring[150];
   sprintf((char*) outputstring,"--- dia_SAFeatureBluetooth:vGetBluetoothFieldstrength => BD=%02x:%02x:%02x:%02x:%02x:%02x",
      pabBDAddress[0],pabBDAddress[1],pabBDAddress[2],pabBDAddress[3],pabBDAddress[4],pabBDAddress[5]);
   DIA_TR_INF("%s",outputstring);
   DIA_TR_INF("--> dia_SAFeatureBluetooth::vGetBluetoothFieldstrength BD=%02d:%02d:%02d:%02d:%02d:%02d",pabBDAddress[0],
     pabBDAddress[1],pabBDAddress[2],pabBDAddress[3],pabBDAddress[4],pabBDAddress[5]);

   tU8 iVecIndex = (tU8) ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_START_au8BDAddress;
   for(int iArrayIndex=0; iArrayIndex < ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_START_PARAM1_LEN; ++iArrayIndex)
   {
       vecRequest[iVecIndex].enType  = EN_PARAMETER_TYPE_U8;
       vecRequest[iVecIndex].u8Value = pabBDAddress[iArrayIndex];
       ++iVecIndex;
   }

   tBool bRetVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_BD_ANTENNA_FIELDSTRENGTH, 0, vecRequest, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetBluetoothFieldstrength => post the message to Diaglib %d",retCode);

   return retCode;
}
//------------------------------------------------------------------------------

#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetBTLinkQuality ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetBTLinkQuality");

   tBool bRetVal = dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH,mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetBTLinkQuality => post the message to Diaglib %d",retCode);

   return retCode;
}
#endif


//------------------------------------------------------------------------------
#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureBluetooth::vGetBluetoothWifiFieldstrength ( const tU8* const pabBDAddress)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetBluetoothWifiFieldstrength");

   tDiaglibParamVector vecRequest(ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_START_LEN);

   tU8 iVecIndex = (tU8) ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_START_au8BDAddress;
   for(int iArrayIndex=0; iArrayIndex < ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_START_PARAM1_LEN; ++iArrayIndex)
   {
       vecRequest[iVecIndex].enType  = EN_PARAMETER_TYPE_U8;//EN_PARAMETER_TYPE_ARRAY_U8;
       vecRequest[iVecIndex].u8Value = pabBDAddress[iArrayIndex];
       ++iVecIndex;
   }

   tBool bRetVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH, 0, vecRequest, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetBluetoothWifiFieldstrength => post the message to Diaglib %d",retCode);

   return retCode;
}
#endif
//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::vStartConnectBluetoothDeviceAddress ( const tU8 eType, const tU8* const pabBDAddress)
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vStartConnectBluetoothDeviceAddress");

   tDiaglibParamVector vecRequest(ROUTINEID_BD_CONNECTION_START_LEN);

   vecRequest[ROUTINEID_BD_CONNECTION_START_u8Type].enType  = static_cast<tenParameterType>(ROUTINEID_BD_CONNECTION_START_PARAM1);
   vecRequest[ROUTINEID_BD_CONNECTION_START_u8Type].u8Value = eType;

   tU8 iVecIndex = ROUTINEID_BD_CONNECTION_START_au8BDAddress;
   tU8 tempBDAddress[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
   tU8 au8BDAddress[6]={0,0,0,0,0,0};
   int j =0;
   for (int i=0; i<17;i++)
   {
     if ((pabBDAddress[i]>= 0x30) && (pabBDAddress[i]<= 0x39))
     {
       tempBDAddress[j] = pabBDAddress[i] & 0x0F;
       j++;
    }
    else if(((pabBDAddress[i]>= 0x41) && (pabBDAddress[i]<= 0x46)) || ((pabBDAddress[i]>= 0x61) && (pabBDAddress[i]<= 0x66)))
    {
       tempBDAddress[j] = static_cast<tU8>((pabBDAddress[i] & 0x0F) + 0x09);
      j++;
    }
    else
    {
      // do nothing
    }

     }
    for ( int k=0; k<12; k+=2)
    {
      au8BDAddress[k/2] = (tU8)((tempBDAddress[k]<<4) | tempBDAddress[k+1]);
    }
    for (int p =0; p<6;p++)
    {
          u8BDAddress[p] = au8BDAddress[p];
    }
     char outputstring[150];
    sprintf((char*) outputstring,"--- dia_SAFeatureBluetooth: connection-to-device => BD=%02x:%02x:%02x:%02x:%02x:%02x",
      au8BDAddress[0],au8BDAddress[1],au8BDAddress[2],au8BDAddress[3],au8BDAddress[4],au8BDAddress[5]);
        DIA_TR_INF(" %s",outputstring);
   DIA_TR_INF("--> dia_SAFeatureBluetooth::vStartConnectBluetoothDeviceAddress BD=%02d:%02d:%02d:%02d:%02d:%02d",au8BDAddress[0],
     au8BDAddress[1],au8BDAddress[2],au8BDAddress[3],au8BDAddress[4],au8BDAddress[5]);

   for(int iArrayIndex=0; iArrayIndex < ROUTINEID_BD_CONNECTION_START_PARAM2_LEN; ++iArrayIndex)
   {
       vecRequest[iVecIndex].enType  = EN_PARAMETER_TYPE_U8;//EN_PARAMETER_TYPE_ARRAY_U8;
       vecRequest[iVecIndex].u8Value = au8BDAddress[iArrayIndex];
       ++iVecIndex;
   }

   tBool bRetVal = dia_SAFeatureDiaglib::bRoutineControlStart(ROUTINEID_BD_CONNECTION, 0, vecRequest, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vStartConnectBluetoothDeviceAddress => post the message to Diaglib %d",retCode);

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::vGetStatusConnectBluetoothDeviceAddress ()
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vGetStatusConnectBluetoothDeviceAddress");

   tBool bRetVal = dia_SAFeatureDiaglib::bGetRoutineResult(ROUTINEID_BD_CONNECTION, mpSrvPlugin);
   tDiaResult retCode = (bRetVal ? DIA_SUCCESS : DIA_FAILED);

   DIA_TR_INF("dia_SAFeatureBluetooth::vGetStatusConnectBluetoothDeviceAddress => post the message to Diaglib %d",retCode);

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleRoutineControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleRoutineControl");

   dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage( poMessage, this );
}

//------------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vOnRoutineCtrlResult (
                                                    tU32 u32RoutineId,
                                                    tenRoutineCtrlResult enRoutineStatus,
                                                    const tDiaglibParamVector& oStartResult
                                                 )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vOnRoutineCtrlResult");

   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32RoutineId);

   dia_IBluetoothListener* pListener = OSAL_NULL;
   if ((querySysAdapterListener<dia_IBluetoothListener>(&pListener) == DIA_SUCCESS) &&
         (pListener != OSAL_NULL))
   {
      switch (u32RoutineId)
      {
         case ROUTINEID_BD_CONNECTION:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => case ROUTINEID_BD_CONNECTION");
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               if( oStartResult.size() >= ROUTINEID_BD_CONNECTION_RESULT_LEN)
               {
                  tU32 u32Status = oStartResult[ROUTINEID_BD_CONNECTION_RESULT_u32TestResult].u32Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Status %d",u32Status);
              tU8 u8Result = (u32Status >> 8) & 0xFF;
              tU8 u8BTConnectionStatus = EN_BT_DISCONNECTED;
              //tU8 u8BDAddress[6] = {0x00,0x00,0x00,0x00,0x00,0x00};
              if ((u32Status & 0xFF) == 0x01)
               {
                DIA_TR_INF("--> dia_SAFeatureBluetooth::vOnRoutineCtrlResult : Disconnected");
                for (int i =0; i< 6; i++)
                {
                   reqBDAddress[i] = 0x00;
                }

                u8BTConnectionStatus = EN_BT_DISCONNECTED;
              }
              else if ((u32Status & 0xFF) == 0x00)
              {
                DIA_TR_INF("--> dia_SAFeatureBluetooth::vOnRoutineCtrlResult : Connected");
                /*set Address value in RAM as 0xFFFFFFFFFFFF (invalid)*/
                //u8BDAddress[6] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
                for (int i =0; i< 6; i++)
                {
                   reqBDAddress[i] = u8BDAddress[i];
                }
                u8BTConnectionStatus = EN_BT_CONNECTED;
                 }
              // tU8 retCode = dia_setProperty (DIA_PROP_SUZUKI_BT_ADDRESS, u8BDAddress, ROUTINEID_BD_CONNECTION_START_PARAM2_LEN );
/*               if ( retCode != DIA_SUCCESS )
              {
                    DIA_TR_INF("dia_SAFeatureBluetooth: BT Address write FAILED !!");
              } */
              pListener->vOnConnectionControlResult(u8Result,u8BTConnectionStatus);

               } // if( oRoutineResult.size() >= ...)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Datamessage");
                  pListener->vOnConnectionControlError(EN_ERROR_NO_DATA);
               } // else // // if( oRoutineResult.size() >= ...)
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            else
            {
            for (int i =0; i< 6; i++)
            {
               reqBDAddress[i] = 0x00;
            }

            if(oStartResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  if( oStartResult.size() >= 1)
                  {
                     tenInternalError enErrorCode = oStartResult[0].u8ErrorValue;
                     DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Error received :%x",enErrorCode);
                     pListener->vOnConnectionControlError(enErrorCode);
                  }// if( oRoutineResult.size() >= ...)
                  else
                  {
                     DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Errormessage");
                     pListener->vOnConnectionControlError(EN_ERROR_NO_DATA);
                  } // else // if( oRoutineResult.size() >= ...)
               }// if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case ROUTINEID_BD_CONNECTION:

         case ROUTINEID_BD_ANTENNA_FIELDSTRENGTH:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => case ROUTINEID_BD_ANTENNA_FIELDSTRENGTH");
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               if( oStartResult.size() >= ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_RESULT_LEN)
               {
                  tU8 u8Fieldstrength = oStartResult[ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_RESULT_u8Fieldstrength].u8Value;
                  tU8 u8LinkQuality = oStartResult[ROUTINEID_BD_ANTENNA_FIELDSTRENGTH_RESULT_u8ErrorBitRate].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => LQ:%d  Fieldstrength/RSSI %d",u8LinkQuality, u8Fieldstrength);

             //     pListener->vOnBDFieldstrengthResult(u8LinkQuality,u8Fieldstrength);
                   pListener->vOnDeviceLinkQualityResult(u8LinkQuality,u8Fieldstrength);
                  pListener->vOnBT_SigQ_RSSI(u8LinkQuality,u8Fieldstrength);


               } // if( oRoutineResult.size() >= ...)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Datamessage");
         //         pListener->vOnBDFieldstrengthError(EN_ERROR_NO_DATA);
                   pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
                  pListener->vOnBT_SigQ_RSSIError(EN_ERROR_NO_DATA);

               } // else // // if( oRoutineResult.size() >= ...)
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_OK)
            else
            {
               if(oStartResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  if( oStartResult.size() >= 1)
                  {
                     tenInternalError enErrorCode = oStartResult[0].u8ErrorValue;
                     DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Error received :%x",enErrorCode);
                    // pListener->vOnBDFieldstrengthError(enErrorCode);
                     pListener->vOnDeviceLinkQualityError(enErrorCode);
                     pListener->vOnBT_SigQ_RSSIError(enErrorCode);
                  }// if( oRoutineResult.size() >= ...)
                  else
                  {
                     DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Errormessage");
                    // pListener->vOnBDFieldstrengthError(EN_ERROR_NO_DATA);
                     pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
                     pListener->vOnBT_SigQ_RSSIError(EN_ERROR_NO_DATA);
                  } // else // if( oRoutineResult.size() >= ...)
               }// if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case ROUTINEID_BD_ANTENNA_FIELDSTRENGTH:
#if 0
         case ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => case ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH");

           dia_IWifiListener* pWifiListener = 0;
           if ((querySysAdapterListener<dia_IWifiListener>(&pWifiListener) == DIA_SUCCESS) && pWifiListener)
           {
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               if( oStartResult.size() >= ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_RESULT_LEN)
               {
                  tU8 u8Fieldstrength = oStartResult[ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_RESULT_u8Fieldstrength].u8Value;
                  tU8 u8LinkQuality = oStartResult[ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH_RESULT_u8ErrorBitRate].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => LQ:%d  Fieldstrength %d",u8LinkQuality, u8Fieldstrength);

                  // Bugfix: Calculate the SNR value and return as first parameter in the listener call
                  tU8 u8SNR = u8Fieldstrength - u8LinkQuality;
                  DIA_TR_INF("--- dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Noise:%d Signal:%d SNR:%d", u8LinkQuality, u8Fieldstrength, u8SNR);
                  pWifiListener->vOnWifiSNR(u8SNR);

                  pListener->vOnWifiFieldstrengthResult(u8LinkQuality,u8Fieldstrength);
               } // if( oRoutineResult.size() >= ...)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Datamessage");
                  pListener->vOnWifiFieldstrengthError(EN_ERROR_NO_DATA);

                  dia_ErrorInfoInterface err(dia_IWifi::getUID());
                  pWifiListener->vOnError(err);
               } // else // // if( oRoutineResult.size() >= ...)
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_OK)
            else
            {
               if(oStartResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  if( oStartResult.size() >= 1)
                  {
                     tenInternalError enErrorCode = oStartResult[0].u8ErrorValue;
                     DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Error received :%x",enErrorCode);
                     pListener->vOnWifiFieldstrengthError(enErrorCode);

                     dia_ErrorInfoInterface err(dia_IWifi::getUID());
                     pWifiListener->vOnError(err);
                  }// if( oRoutineResult.size() >= ...)
                  else
                  {
                     DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Errormessage");
                     pListener->vOnWifiFieldstrengthError(EN_ERROR_NO_DATA);

                     dia_ErrorInfoInterface err(dia_IWifi::getUID());
                     pWifiListener->vOnError(err);
                  } // else // if( oRoutineResult.size() >= ...)

               }// if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
           }
            break;
         }// case ROUTINEID_BD_WIFI_ANTENNA_FIELDSTRENGTH:
#endif

         case ROUTINEID_BD_WIFI_ANTENNA_SNR:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => case ROUTINEID_BD_WIFI_ANTENNA_SNR");
            dia_IWifiListener* pWifiListener = 0;
           if ((querySysAdapterListener<dia_IWifiListener>(&pWifiListener) == DIA_SUCCESS) && pWifiListener)
           {
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               if( oStartResult.size() >= ROUTINEID_BD_WIFI_ANTENNA_SNR_RESULT_LEN)
               {
                  tS8 signalLevel = oStartResult[ROUTINEID_BD_WIFI_ANTENNA_SNR_RESULT_s8SignalLevel].s8Value;
                  tS8 noiseLevel  = oStartResult[ROUTINEID_BD_WIFI_ANTENNA_SNR_RESULT_s8NoiseLevel].s8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => NoiseLevel:%d  SignalLevel %d",signalLevel, noiseLevel);

                  // Bugfix: Calculate the SNR value and return as first parameter in the listener call
                  tU8 SNR = (tU8)((signalLevel > noiseLevel) ? (signalLevel - noiseLevel) : 0);
                  DIA_TR_INF("--- dia_SAFeatureBluetooth::vOnRoutineCtrlResult => SNR:%d", SNR);
                  pWifiListener->vOnWifiSNR(SNR);

               } // if( oRoutineResult.size() >= ...)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Datamessage");

                  dia_ErrorInfoInterface err(dia_IWifi::getUID());
                  pWifiListener->vOnError(err);

               } // else // // if( oRoutineResult.size() >= ...)
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_OK)
            else
            {
               if(oStartResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  if( oStartResult.size() >= 1)
                  {
                     tenInternalError enErrorCode = oStartResult[0].u8ErrorValue;
                     DIA_TR_INF("dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Error received :%x",enErrorCode);

                     dia_ErrorInfoInterface err(dia_IWifi::getUID());
                     pWifiListener->vOnError(err);
                  }// if( oRoutineResult.size() >= ...)
                  else
                  {
                     DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: No Data Available in Errormessage");
                     dia_ErrorInfoInterface err(dia_IWifi::getUID());
                     pWifiListener->vOnError(err);

                  } // else // if( oRoutineResult.size() >= ...)

               }// if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
           }
           break;
         }// case ROUTINEID_BD_WIFI_ANTENNA_SNR:

         default:
         {
            DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => Invalid RoutineId %d",u32RoutineId);
            DIA_ASSERT_ALWAYS();
            break;
         }
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnRoutineCtrlResult => ERROR: OSAL_NULL == pListener");
      DIA_ASSERT_ALWAYS();
   }
}

//------------------------------------------------------------------------------

void dia_SAFeatureBluetooth::vOnGetRoutineResult  (
                                                   tU32 u32RoutineId,
                                                   tenRoutineCtrlResult enRoutineStatus,
                                                   const tDiaglibParamVector& oRoutineResult
                                                )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vOnGetRoutineResult ");
   dia_IBluetoothListener* pListener = OSAL_NULL;
   if ((querySysAdapterListener<dia_IBluetoothListener>(&pListener) == DIA_SUCCESS) &&
         (pListener != OSAL_NULL))
   {
      switch (u32RoutineId)
      {
         case ROUTINEID_BD_CONNECTION:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnGetRoutineResult  => case ROUTINEID_BD_CONNECTION");
            if ( enRoutineStatus == EN_ROUTINE_CONTROL_OK )
            {
               if( oRoutineResult.size() >= ROUTINEID_BD_CONNECTION_RESULT_LEN)
               {
                  tU32 u32Status = oRoutineResult[ROUTINEID_BD_CONNECTION_RESULT_u32TestResult].u32Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnGetRoutineResult  => Status %d",u32Status);
              tU8 u8Result = (u32Status >> 8) & 0xFF;
              tU8 u8BTConnectionStatus = u32Status & 0xFF;
                  pListener->vOnConnectionControlResult(u8Result,u8BTConnectionStatus);
               } // if( oRoutineResult.size() >= ...)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnGetRoutineResult  => ERROR: No Data Available in Datamessage");
                  pListener->vOnConnectionControlError(EN_ERROR_NO_DATA);
               } // else // // if( oRoutineResult.size() >= ...)
            }//if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            else
            {
               if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  if( oRoutineResult.size() >= 1)
                  {
                     tenInternalError enErrorCode = oRoutineResult[0].u8ErrorValue;
                     DIA_TR_INF("dia_SAFeatureBluetooth::vOnGetRoutineResult => Error received :%x",enErrorCode);
                     pListener->vOnConnectionControlError(enErrorCode);
                  }// if( oRoutineResult.size() >= ...)
                  else
                  {
                     DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnGetRoutineResult  => ERROR: No Data Available in Errormessage");
                     pListener->vOnConnectionControlError(EN_ERROR_NO_DATA);
                  } // else // if( oRoutineResult.size() >= ...)

               }// if(oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case ROUTINEID_BD_CONNECTION:

         default:
         {
            DIA_ASSERT_ALWAYS();
         }
      }// switch (u32RoutineId)
   }// if(OSAL_NULL != pListener
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnGetRoutineResult => ERROR: OSAL_NULL == pListener");
      DIA_ASSERT_ALWAYS();
   }
}

//----------------------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleDiagnosisData ( amt_tclServiceData* poMessage )
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleDiagnosisData");

    if ( !poMessage )
    {
        DIA_TR_ERR("dia_SAFeatureBluetooth::vHandleDiagnosisData => ERROR: Invalid Message Pointer !!!");
    }
    else
    {
       (void)dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage(poMessage, this);
    }

    // delete now if not delted
    if(poMessage != NULL)
    {
      (void)poMessage->bDelete();
      poMessage = NULL;
    }
} //lint !e438 cascodial pointer

//----------------------------------------------------------------------------------------

void dia_SAFeatureBluetooth::vOnDiagnosisDataResult (
                                                        tU32 u32DiagnosisDataId,
                                                        tenDiagDataResult enResult,
                                                        const tDiaglibParamVector& oResult
                                                      )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vOnDiagnosisDataResult");
   dia_IBluetoothListener* pListener = OSAL_NULL;
   (void) querySysAdapterListener<dia_IBluetoothListener>(&pListener);
   if(OSAL_NULL != pListener)
   {
      switch (u32DiagnosisDataId)
      {
         case DATAID_BD_ADDRESS_MAC:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_ADDRESS_MAC");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_ADDRESS_MAC_READ_RESULT_LEN)
               {
                  tU8 au8MacAddress[6];
                  tU8 iVecIndex = DATAID_BD_ADDRESS_MAC_READ_RESULT_au8MacAddress;
                  for(int iArrayIndex=0; iArrayIndex < DATAID_BD_ADDRESS_MAC_READ_RESULT_PARAM1_LEN; ++iArrayIndex)
                  {
                      au8MacAddress[iArrayIndex] = oResult[iVecIndex].u8Value ;
                      ++iVecIndex;
                  }
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnReadMacAddressResult(&au8MacAddress[0]);
				  pListener->vOnReadWifiMacAddressResult(&au8MacAddress[0]);				  

				  //for Customer WIFI Address
				  pListener->vOnReadCustWifiMacAddressResult(&au8MacAddress[0]);	 
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnReadMacAddressError(EN_ERROR_NO_DATA);
				  pListener->vOnReadWifiMacAddressError(EN_ERROR_NO_DATA);
				  //for Customer WIFI Address
				  pListener->vOnReadCustWifiMacAddressError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error code received: 0x%02x", enErrorCode);
                  pListener->vOnReadMacAddressError(enErrorCode);
				  pListener->vOnReadWifiMacAddressError(enErrorCode);

				  //for Customer WIFI Address
				  pListener->vOnReadCustWifiMacAddressError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnReadMacAddressError(EN_ERROR_NO_DATA);
				  pListener->vOnReadWifiMacAddressError(EN_ERROR_NO_DATA);

				  //for Customer WIFI Address
				  pListener->vOnReadCustWifiMacAddressError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)

            break;
         }// case DATAID_BD_ADDRESS_MAC:


         case DATAID_BD_ADDRESS_BLUETOOTH_DEVICE:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_ADDRESS_BLUETOOTH_DEVICE");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_ADDRESS_BLUETOOTH_DEVICE_READ_RESULT_LEN)
               {

                  tU8 au8BDAddress[6];
                  tU8 iVecIndex = DATAID_BD_ADDRESS_BLUETOOTH_DEVICE_READ_RESULT_au8BDAddress;
                  for(tU8 iArrayIndex=0; iArrayIndex < DATAID_BD_ADDRESS_BLUETOOTH_DEVICE_READ_RESULT_PARAM1_LEN; ++iArrayIndex)
                  {
                      au8BDAddress[iArrayIndex] = oResult[iVecIndex].u8Value ;
                      ++iVecIndex;
                  }
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnReadBDAddressResult(&au8BDAddress[0]);
				  pListener->vOnReadMacAddressResult(&au8BDAddress[0]);

				  //for Customer BT Address
				  pListener->vOnReadCustBTMacAddressResult(&au8BDAddress[0]);

               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnReadBDAddressError(EN_ERROR_NO_DATA);
				  pListener->vOnReadMacAddressError(EN_ERROR_NO_DATA);
				  
				  //for Customer BT Address
				  pListener->vOnReadCustBTMacAddressError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnReadBDAddressError(enErrorCode);
				  pListener->vOnReadMacAddressError(enErrorCode);
				  
				  //for Customer BT Address
				  pListener->vOnReadCustBTMacAddressError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnReadBDAddressError(EN_ERROR_NO_DATA);
				  pListener->vOnReadMacAddressError(EN_ERROR_NO_DATA);
				  
				  //for Customer BT Address
				  pListener->vOnReadCustBTMacAddressError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)

            break;
         }// case DATAID_BD_ADDRESS_BLUETOOTH_DEVICE:

         case DATAID_BD_CONNECTED_DEVICE_STATUS_1:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_CONNECTED_DEVICE_STATUS_1");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_LEN)
               {
                  tU8 u8Bitfield[5];

                  u8Bitfield[0] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_u8DataBitfield1].u8Value;
                  u8Bitfield[1] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_u8DataBitfield2].u8Value;
                  u8Bitfield[2] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_u8DataBitfield3].u8Value;
                  u8Bitfield[3] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_u8DataBitfield4].u8Value;
                  u8Bitfield[4] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_1_READ_RESULT_u8DataBitfield5].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnConnectedDeviceStatusResult(1, u8Bitfield);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnConnectedDeviceStatusError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnConnectedDeviceStatusError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnConnectedDeviceStatusError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_BD_CONNECTED_DEVICE_STATUS_1:

         case DATAID_BD_CONNECTED_DEVICE_STATUS_2:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_CONNECTED_DEVICE_STATUS_2");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_LEN)
               {
                  tU8 u8Bitfield[5];

                  u8Bitfield[0] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_u8DataBitfield1].u8Value;
                  u8Bitfield[1] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_u8DataBitfield2].u8Value;
                  u8Bitfield[2] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_u8DataBitfield3].u8Value;
                  u8Bitfield[3] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_u8DataBitfield4].u8Value;
                  u8Bitfield[4] = oResult[DATAID_BD_CONNECTED_DEVICE_STATUS_2_READ_RESULT_u8DataBitfield5].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnConnectedDeviceStatusResult(2, u8Bitfield);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnConnectedDeviceStatusError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnConnectedDeviceStatusError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnConnectedDeviceStatusError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_BD_CONNECTED_DEVICE_STATUS_2:

         case DATAID_BD_GET_LINKQUALITY_1:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_GET_LINKQUALITY_1");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_GET_LINKQUALITY_1_READ_RESULT_LEN)
               {
                  tU8 u8LinkQuality;

                  u8LinkQuality = oResult[DATAID_BD_GET_LINKQUALITY_1_READ_RESULT_u8LinkQuality].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnDeviceLinkQualityResult(1, u8LinkQuality);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnDeviceLinkQualityError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_BD_GET_LINKQUALITY_1:

         case DATAID_BD_GET_LINKQUALITY_2:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_GET_LINKQUALITY_2");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_GET_LINKQUALITY_2_READ_RESULT_LEN)
               {
                  tU8 u8LinkQuality;

                  u8LinkQuality = oResult[DATAID_BD_GET_LINKQUALITY_2_READ_RESULT_u8LinkQuality].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnDeviceLinkQualityResult(2, u8LinkQuality);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnDeviceLinkQualityError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnDeviceLinkQualityError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_BD_GET_LINKQUALITY_2:

         case DATAID_BD_GET_AUTHENTICATED_DEVICES:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_BD_GET_AUTHENTICATED_DEVICES");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_BD_GET_AUTHENTICATED_DEVICES_READ_RESULT_LEN)
               {
                  tU8 u8Devices;

                  u8Devices = oResult[DATAID_BD_GET_AUTHENTICATED_DEVICES_READ_RESULT_u8AuthenticatedDevices].u8Value;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnAuthenticatedDevicesPresentResult(u8Devices);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnAuthenticatedDevicesPresentError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnAuthenticatedDevicesPresentError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnAuthenticatedDevicesPresentError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_BD_GET_AUTHENTICATED_DEVICES:
#if 0
         case DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH:
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => case: DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH");
            if ( enResult == EN_DIAGDATA_OK )
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
               if( oResult.size() >= DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH_READ_RESULT_LEN)
               {
                  tU8 u8ErrorRate;
				  tU8 u8LinkQuality;

                  u8ErrorRate = oResult[DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH_READ_RESULT_u8ErrorBitRate].u8Value;
				  u8LinkQuality = oResult[DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH_READ_RESULT_u8Fieldstrength].u8Value;
				  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ErrorRate :%d, LinkQuality: %d",u8ErrorRate,u8LinkQuality);
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Call Service Listener");
                  pListener->vOnCustBTLinkQualityResult(u8ErrorRate,u8LinkQuality);
               }
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnCustBTLinkQualityError(EN_ERROR_NO_DATA);
               }
            }//if(enResult == EN_DIAGDATA_OK)
            else
            {
               DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");

               if( oResult.size() >= 1 && oResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               {
                  tenInternalError enErrorCode = oResult[0].u8ErrorValue;
                  DIA_TR_INF("dia_SAFeatureBluetooth::vOnDiagnosisDataResult => Error received :%x",enErrorCode);
                  pListener->vOnCustBTLinkQualityError(enErrorCode);
               }// if( oRoutineResult.size() >= 1 && oRoutineResult[0].enType == EN_PARAMETER_TYPE_U8ERROR)
               else
               {
                  DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: No Data Available");
                  pListener->vOnCustBTLinkQualityError(EN_ERROR_NO_DATA);
               }
            }// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)
            break;
         }// case DATAID_CUST_BD_ANTENNA_FIELDSTRENGTH:
#endif
         default:
         {
            DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: Unknown u32DiagnosisDataId=0x%x",
                  u32DiagnosisDataId);
            DIA_ASSERT_ALWAYS();
            break;
         }
      }// switch (u32DiagnosisDataId)
   }// if(OSAL_NULL != pListener
   else
   {
      DIA_TR_ERR("!!! dia_SAFeatureBluetooth::vOnDiagnosisDataResult => ERROR: OSAL_NULL == pListener");
      DIA_ASSERT_ALWAYS();
   }
}

//------------------------------------------------------------------------------

#if 1 //STC2HI: TODO // gib2hi: reactivated, but only signatures

tDiaResult
dia_SAFeatureBluetooth::attachNotification ( dia_eBTNotification /*id*/ )
{
    tDiaResult retCode = DIA_FAILED;
/*
    tU16 fid = arBTFIDMapping[id];
    if ( fid != 0xFFFF )
    {
        if ( mpSrvPlugin->bRegisterForFID(fid) ) retCode = DIA_SUCCESS;
    }
*/
    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::detachNotification ( dia_eBTNotification /*id*/ )
{
    tDiaResult retCode = DIA_FAILED;
/*
    tU16 fid = arBTFIDMapping[id];
    if ( fid != 0xFFFF )
    {
        if ( mpSrvPlugin->bUnregisterForFID(fid) ) retCode = DIA_SUCCESS;
    }
*/
    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::setMode ( dia_eBTMode mode )
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::setMode");

    tDiaResult retCode = DIA_SUCCESS;
   if (((mode == DIA_EN_BT_MODE_NORMAL) || (mode == DIA_EN_BT_MODE_PRODUCTION)) == FALSE)
   {
      retCode = DIA_FAILED;
   }
   dia_IBluetoothListener* pListener = OSAL_NULL;
    querySysAdapterListener<dia_IBluetoothListener>(&pListener);
    if ( pListener )
    {
       pListener->vOnBTModeRequestACK(TRUE);
   }
/*
    if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
    {
        DIA_TR_ERR("dia_tclPhoneClientHandler::setMode --> INVALID REGISTRATION ID !!");
        return DIA_FAILED;
    }

    midw_ext_phonefi_tclMsgFID_TEL_S_SET_BT_TEST_MODEMethodStart oMethodStartData;

    switch ( mode )
    {
    case DIA_EN_BT_MODE_NORMAL:
        oMethodStartData.eTestMode.enType = midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_NORMAL_MODE;
        break;

    case DIA_EN_BT_MODE_PRODUCTION:
        oMethodStartData.eTestMode.enType = midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_PRODUCTION_MODE;
        break;

//    case DIA_EN_BT_MODE_DUT:
//        oMethodStartData.eTestMode.enType = midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_DUT_MODE;
//        break;

    default:
        retCode = DIA_FAILED;
        break;
    } //lint !e788: not all items intentionally used within defaulted switch

    if ( retCode != DIA_FAILED )
    {
       //put the data in message
       fi_tclVisitorMessage oMsg(oMethodStartData);
       mpSrvPlugin->vInitServiceData(oMsg, MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_SET_BT_TEST_MODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
    }
*/
    return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SAFeatureBluetooth::executeAction ( dia_eBTAction /*actionID*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::executeAction()");

   tDiaResult retCode = DIA_FAILED;
/*
   if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_ERR("dia_SAFeatureBluetooth::executeAction --> INVALID REGISTRATION ID !!");
      return retCode;
   }

   if ( (actionID == DIA_EN_BT_ACTION_TESTTONESTART) || (actionID == DIA_EN_BT_ACTION_TESTTONESTOP) )
   {
      midw_ext_phonefi_tclMsgFID_TEL_S_BTM_TEST_ACTIONMethodStart oMethodStartData;
      oMethodStartData.eBTMTestAction.enType = ( actionID == DIA_EN_BT_ACTION_TESTTONESTART)
         ? midw_ext_fi_tcl_e8_PHN_BTTestAction::FI_EN_PHN_BTTESTACTION_START_I2S_TESTTONE
         : midw_ext_fi_tcl_e8_PHN_BTTestAction::FI_EN_PHN_BTTESTACTION_STOP_I2S_TESTTONE;

      //put the data in message
      fi_tclVisitorMessage oMsg(oMethodStartData);
      mpSrvPlugin->vInitServiceData(oMsg, MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_BTM_TEST_ACTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
   }

   if ( (actionID == DIA_EN_BT_ACTION_LOCALLOOPBACKSTART) || (actionID == DIA_EN_BT_ACTION_TESTTONESTOP) )
   {
      midw_ext_phonefi_tclMsgFID_TEL_S_BTM_TEST_LOCAL_LOOPBACK_HCI_MODEMethodStart oMethodStartData;
      oMethodStartData.bStartTest = ( actionID == DIA_EN_BT_ACTION_LOCALLOOPBACKSTART) ? TRUE : FALSE;

      //put the data in message
      fi_tclVisitorMessage oMsg(oMethodStartData);
      mpSrvPlugin->vInitServiceData(oMsg, MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_BTM_TEST_LOCAL_LOOPBACK_HCI_MODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
   }
*/
   return retCode;
}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::connectBTDevice ( tCString BTDeviceAddress )
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::connectBTDevice()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if ( BTDeviceAddress == OSAL_NULL )
//   {
//       DIA_TR_INF("---bluetooth device address INVALID");
//       return retCode;
//   }
//
//   DIA_TR_INF("LENGTH OF BTADDRESS: %d", ::strlen(BTDeviceAddress));
//
//   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//   {
//      midw_ext_phonefi_tclMsgFID_TEL_S_EX_START_CONNECTIONMethodStart oMethodStartData;
//
//      tString btAddr = OSAL_NEW tChar[strlen(BTDeviceAddress)];
//      if ( !btAddr )
//      {
//          DIA_TR_INF("---Unable to allocate memory for the bluetooth device address");
//          return FALSE;
//      }
//
//      strcpy(btAddr,BTDeviceAddress);
//
//      //fill the address for the given device
//      oMethodStartData.sBTAddress.sBTDeviceAddress.szValue = btAddr;
//
//      //put the data in message
//      fi_tclVisitorMessage oMsg(oMethodStartData);
//      mpSrvPlugin->vInitServiceData(oMsg, MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_EX_START_CONNECTION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
//
//      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
//   }
//*/
//   return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::disconnectBTDevice ( void )
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::disconnectBTDevice()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//   {
//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_EX_STOP_CONNECTION,
//         AMT_C_U8_CCAMSG_OPCODE_METHODSTART
//      );
//
//      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
//   }
//*/
//   return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::measureLinkQuality( )
//{
//    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::measureLinkQuality");
//
//    tDiaResult retCode = DIA_FAILED;
///*
//    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//    {
//       gm_tclEmptyMessage oMessage (
//          mAppID,
//          mpSrvPlugin->getClientID(),
//          mpSrvPlugin->getRegistrationID(),
//          0,
//          mpSrvPlugin->getServiceID(),
//          MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY,
//          AMT_C_U8_CCAMSG_OPCODE_METHODSTART
//       );
//
//       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
//    }
//*/
//    return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::getConnectBTDevices ( void )
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getConnectBTDevices()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//   {
//      gm_tclEmptyMessage oMessage (
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_CONNECTED_BT_DEVICES,
//         AMT_C_U8_CCAMSG_OPCODE_GET
//      );
//
//      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
//   }
//*/
//   return retCode;
//}
//

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::getLinkInfo ( void )
//{
//    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getLinkInfo");
//
//    tDiaResult retCode = DIA_FAILED;
////
////    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
////    {
////       gm_tclEmptyMessage oMessage (
////          mAppID,
////          mpSrvPlugin->getClientID(),
////          mpSrvPlugin->getRegistrationID(),
////          0,
////          mpSrvPlugin->getServiceID(),
////          MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DEV_BT_LINK_INFO,
////          AMT_C_U8_CCAMSG_OPCODE_GET
////       );
////
////       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
////    }
//
//    return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::getMuteIndicationStatus ( void )
//{
//    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getMuteIndicationStatus()");
//
//    tDiaResult retCode = DIA_FAILED;
///*
//    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//    {
//       gm_tclEmptyMessage oMessage (
//          mAppID,
//          mpSrvPlugin->getClientID(),
//          mpSrvPlugin->getRegistrationID(),
//          0,
//          mpSrvPlugin->getServiceID(),
//          MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DIAGNOSIS_MUTE_INDICATION,
//          AMT_C_U8_CCAMSG_OPCODE_GET
//       );
//
//       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
//    }
//*/
//    return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::getFaciaID ( void ){
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getFaciaID()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
//      gm_tclEmptyMessage oMessage(
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DEV_LOCAL_BT_DEVICE_VERSION_INFO,
//         AMT_C_U8_CCAMSG_OPCODE_GET
//      );
//
//      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
//         retCode = DIA_SUCCESS;
//         DIA_TR_INF("dia_SAFeatureBluetooth::getFaciaID() - SUCCESS.");
//      } else {
//         DIA_TR_INF("dia_SAFeatureBluetooth::getFaciaID() - FAILED.");
//      }
//   }
//*/
//   return retCode;
//}

//-----------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::getBTMACAddress ( void ){
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::getBTMACAddress()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
//      gm_tclEmptyMessage oMessage(
//         mAppID,
//         mpSrvPlugin->getClientID(),
//         mpSrvPlugin->getRegistrationID(),
//         0,
//         mpSrvPlugin->getServiceID(),
//         MIDW_EXT_PHONEFI_C_U16_FID_TEL_G_DEV_LOCAL_BT_DEVICE_VERSION_INFO,
//         AMT_C_U8_CCAMSG_OPCODE_GET
//      );
//
//      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
//         retCode = DIA_SUCCESS;
//         DIA_TR_INF("dia_SAFeatureBluetooth::getBTMACAddress() - SUCCESS.");
//      } else {
//         DIA_TR_INF("dia_SAFeatureBluetooth::getBTMACAddress() - FAILED.");
//      }
//   }
//*/
//   return retCode;
//}

//------------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothModeResult ( amt_tclServiceData* /*poMessage*/ ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothModeResult()");
/*
    if ( !poMessage || (poMessage->bIsServerMessage() != TRUE) ) return;

    if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
    {
       dia_IBluetoothListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_IBluetoothListener>(&pListener);
       if ( pListener )
       {
          fi_tclVisitorMessage oResultMsg(poMessage);
          midw_ext_phonefi_tclMsgFID_TEL_S_SET_BT_TEST_MODEMethodResult oCompResp;
          (void) oResultMsg.s32GetData(oCompResp);

          DIA_TR_INF("Notify Result of BTModeRequest");
          pListener->vOnBTModeRequestACK(oCompResp.bSuccess);
       }
    }
    else
    {
        DIA_TR_INF( "OpCode = %d received",poMessage->u8GetOpCode());
    }

    (void) poMessage->bDelete();
*/
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothModeStatus ( amt_tclServiceData* /*poMessage*/ ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothModeStatus");
/*
    if ( !poMessage || (poMessage->bIsServerMessage() != TRUE) ) return;

    if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
    {
       dia_IBluetoothListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_IBluetoothListener>(&pListener);
       if ( pListener )
       {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_G_BT_TEST_MODEStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            dia_eBTMode mode = DIA_EN_BT_MODE_UNKNOWN;

            switch ( oCompResp.eTestMode.enType )
            {
            case midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_PRODUCTION_MODE:
                mode = DIA_EN_BT_MODE_PRODUCTION;
                break;

            case midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_NORMAL_MODE:
                mode = DIA_EN_BT_MODE_NORMAL;
                break;

            case midw_ext_fi_tcl_e8_PHN_BTM_TEST_MODE::FI_EN_PHN_BTTESTMODE_DUT_MODE:
                mode = DIA_EN_BT_MODE_DUT;
                break;

            default:
                break;
            }  //lint !e788: not all items intentionally used within defaulted switch

            DIA_TR_INF( "BTModeStatus Received - Mode = 0x%02x",mode);

            DIA_TR_INF("Notify BTMode Status");
            pListener->vOnBTModeStatus(mode);
       }
    }
    else
    {
        DIA_TR_INF( "OpCode = %d received",poMessage->u8GetOpCode());
    }

    (void) poMessage->bDelete();
*/
}

//-----------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleTelephoneMuteIndication ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleTelephoneMuteIndication");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            dia_eDiaBTMuteIndication mutePinStatus = DIA_EN_BT_MUTE_PIN_STATE_UNKNOWN;

            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_G_DIAGNOSIS_MUTE_INDICATIONStatus oCompRespData;
            (void) oResultMsg.s32GetData(oCompRespData);

            if ( oCompRespData.AudioMuteIndication.e8MutePinMuteState.enType == midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::FI_EN_PHN_VAG_DIAG_MUTE_STATE_INACTIVE )
            {
               DIA_TR_INF("MUTE STATE INACTIVE");
               mutePinStatus = DIA_EN_BT_MUTE_PIN_STATE_OPEN;
            }
            else if ( oCompRespData.AudioMuteIndication.e8MutePinMuteState.enType == midw_ext_fi_tcl_e8_PHN_VAG_DIAG_Mute_State::FI_EN_PHN_VAG_DIAG_MUTE_STATE_ACTIVE )
            {
               DIA_TR_INF("MUTE STATE ACTIVE");
               mutePinStatus = DIA_EN_BT_MUTE_PIN_STATE_GROUND;
            }
            else
            {
               DIA_TR_INF("INVALID STATE!!!!!");
            }

            pListener->vOnMuteIndicationStatus(mutePinStatus);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "---opcode error recievd with error code:>",u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
   */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothConnectResult (amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothConnectResult");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_S_EX_START_CONNECTIONMethodResult oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

//            // TODO: update to new method result
//            tDiaResult result = DIA_SUCCESS;
//            #if 0
//            tDiaResult result = ( oCompResp.e8MethodResult.enType == midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::FI_EN_PHN_VAG_NO_ERROR )
//                  ? DIA_SUCCESS : DIA_FAILED;
//            #endif

            pListener->vOnConnectionStatus(oCompResp.bSuccess);
         }
      }

      (void) poMessage->bDelete();
   }
   */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothConnectionStatus ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothConnectionStatus");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            // TODO: update to new method result
            tBool isConnected = FALSE;
            #if 0
            midw_ext_phonefi_tclMsgFID_TEL_G_EX_START_CONNECTION_RESULTStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            tBool isConnected = FALSE;
            if ( oCompResp.eExStartConnectionResult.enType == midw_ext_fi_tcl_e8_PHN_VAG_BTM_TEST_EX_START_CONNECTION_RESULT::FI_EN_PHN_VAG_BTM_EX_START_CONNECTION_RESULT_OK )
            {
               isConnected = TRUE;
            }
            #endif

            ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "IsConnected = %d",((isConnected) ? 1 : 0));

            pListener->vOnConnectionStatus(isConnected);
         }
      }

      (void) poMessage->bDelete();
   }
   */
}

//------------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothDisconnectResult (amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothDisconnectResult");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_S_EX_STOP_CONNECTIONMethodResult oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

//            // TODO: update to new method result
//            tDiaResult result = DIA_SUCCESS;
//            #if 0
//
//            tDiaResult result = ( oCompResp.e8MethodResult.enType == midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::FI_EN_PHN_VAG_NO_ERROR )
//                  ? DIA_SUCCESS : DIA_FAILED;
//            #endif
//
//            pListener->vOnDisconnectACK(result);
            pListener->vOnDisconnectionStatus(oCompResp.bSuccess);
         }
      }

      (void) poMessage->bDelete();
   }
   */
}
//-------------------------------------------------------------------------


void
dia_SAFeatureBluetooth::vHandleBlueToothDisconnectionStatus   (amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothDisconnectionStatus");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            // TODO: update to new method result
            tBool isDisconnected = FALSE;
            #if 0
            midw_ext_phonefi_tclMsgFID_TEL_G_EX_STOP_CONNECTION_RESULTStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            tBool isDisconnected = FALSE;
            if ( oCompResp.eExStopConnectionResult.enType == midw_ext_fi_tcl_e8_PHN_VAG_BTM_TEST_EX_STOP_CONNECTION_RESULT::FI_EN_PHN_VAG_BTM_EX_STOP_CONNECTION_RESULT_OK )
            {
               isDisconnected = TRUE;
            }
            #endif

            ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "isDisconnected = %d",((isDisconnected) ? 1 : 0));

            pListener->vOnDisconnectionStatus(isDisconnected);
         }
      }

      (void) poMessage->bDelete();
   }
   */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothConnectedDevices (amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothConnectedDevices");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_G_CONNECTED_BT_DEVICESStatus oCompResp;
            (void) oMsg.s32GetData(oCompResp);

            dia_BTDeviceInfo btDevInfo;
            std::vector<dia_BTDeviceInfo*> vecDevInfo;

            btDevInfo.btAddr    = oCompResp.BTConnectedDevice.BTDeviceAddess.sBTDeviceAddress.szValue;
            btDevInfo.btAddrLen = (tU16) oCompResp.BTConnectedDevice.BTDeviceAddess.sBTDeviceAddress.u32GetSize();
            DIA_TR_INF("Received Bluetooth Address of Connected Device: %s", btDevInfo.btAddr);
            vecDevInfo.push_back(&btDevInfo);

            pListener->vOnBTConnectedDevicesInfo(vecDevInfo);
         }
      }

      (void) poMessage->bDelete();
   }
   */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBTLinkQualityResult (amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTLinkQualityResult");
/*
   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_IBluetoothListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oMsg(poMessage);
            midw_ext_phonefi_tclMsgFID_TEL_S_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITYMethodResult oCompResp;
            (void) oMsg.s32GetData(oCompResp);

            pListener->vOnBTLinkQuality (
                  oCompResp.u8BtLinkQuality,
                  oCompResp.s8BtRSSI,
                  oCompResp.bSuccess
                  );
         }
      }

      (void) poMessage->bDelete();
   }
   */
}

//-------------------------------------------------------------------------

//void
//dia_SAFeatureBluetooth::vHandleBTLinkQualityStatus   (amt_tclServiceData* poMessage) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTLinkQualityStatus");
//
//   if ( poMessage )
//   {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
//      {
//         dia_IBluetoothListener* pListener = OSAL_NULL;
//         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
//         if ( pListener )
//         {
//            fi_tclVisitorMessage oMsg(poMessage);
//            // TODO: update to new method result
//            tBool bStatus = TRUE;
//            #if 0
//            midw_ext_phonefi_tclMsgFID_TEL_G_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY_RESULTStatus oCompResp;
//            oMsg.s32GetData(oCompResp);
//
//            ET_TRACE_INFO( DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "BAPResult: %d",oCompResp.BAPResult.enType);
//            tBool bStatus = ( midw_ext_fi_tcl_e8_PHN_VAG_BAP_Result::FI_EN_PHN_VAG_BAP_METHOD_OK == oCompResp.BAPResult.enType );
//            #endif
//
//            pListener->vOnBTLinkQualityStatus(poMessage, bStatus);
//         }
//      }
//
//      poMessage->bDelete();
//   }
//}

//-------------------------------------------------------------------------

//void
//dia_SAFeatureBluetooth::vHandleBTLinkInfo (amt_tclServiceData* poMessage) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTLinkInfo");
//
//   if ( poMessage )
//   {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
//      {
//         dia_IBluetoothListener* pListener = OSAL_NULL;
//         querySysAdapterListener<dia_IBluetoothListener>(&pListener);
//         if ( pListener )
//         {
//            fi_tclVisitorMessage oResultMsg(poMessage);
//            midw_ext_phonefi_tclMsgFID_TEL_G_DEV_BT_LINK_INFOStatus oCompResp;
//            oResultMsg.s32GetData(oCompResp);
//
//            pListener->vOnBTLinkInfoStatus(oCompResp.u8BtLinkQuality, oCompResp.s8BtRSSI);
//         }
//      }
//
//      poMessage->bDelete();
//   }
//}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBTTestActionStatus   (amt_tclServiceData* /*poMessage*/) const
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTTestActionStatus()");
/*
    if ( !poMessage || (poMessage->bIsServerMessage() != TRUE) ) return;

    if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
    {
       dia_IBluetoothListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_IBluetoothListener>(&pListener);
       if ( pListener )
       {
          fi_tclVisitorMessage oResultMsg(poMessage);
          midw_ext_phonefi_tclMsgFID_TEL_G_BTM_TEST_ACTIONStatus oCompResp;
          (void) oResultMsg.s32GetData(oCompResp);

          dia_eBTAction receivedAction = DIA_EN_BT_ACTION_UNKNOWN;

          switch ( oCompResp.eTestAction.enType )
          {
          case midw_ext_fi_tcl_e8_PHN_BTTestAction::FI_EN_PHN_BTTESTACTION_START_I2S_TESTTONE:
             receivedAction = DIA_EN_BT_ACTION_TESTTONESTART;
             break;

          case midw_ext_fi_tcl_e8_PHN_BTTestAction::FI_EN_PHN_BTTESTACTION_STOP_I2S_TESTTONE:
             receivedAction = DIA_EN_BT_ACTION_TESTTONESTOP;
             break;

          default:
             break;
          }

          DIA_TR_INF( "Received Action Status =  %d",receivedAction);

          if ( receivedAction != DIA_EN_BT_ACTION_UNKNOWN )
          {
             DIA_TR_INF("Notify Action Status");
             pListener->vOnBTTestActionStatus(receivedAction);
          }
       }
    }
    else
    {
        DIA_TR_INF( "OpCode = %d received",poMessage->u8GetOpCode());
    }

    (void) poMessage->bDelete();
    */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBTTestActionResult ( amt_tclServiceData* /*poMessage*/ ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTTestActionResult()");
/*
    if ( !poMessage || (poMessage->bIsServerMessage() != TRUE) ) return;

    if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
    {
       dia_IBluetoothListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_IBluetoothListener>(&pListener);
       if ( pListener )
       {
          DIA_TR_INF("Received Result of BTTestActionRequest");

          tBool bResult = FALSE;

          fi_tclVisitorMessage oResultMsg(poMessage);
          // TODO: update to new method result
          #if 0
          midw_ext_phonefi_tclMsgFID_TEL_S_BTM_TEST_ACTIONMethodResult oCompResp;
          (void) oResultMsg.s32GetData(oCompResp);

          if ( oCompResp.e8MethodResult.enType == midw_ext_fi_tcl_e8_PHN_VAG_PhoneError::FI_EN_PHN_VAG_NO_ERROR )
          {
             bResult = TRUE;
          }
          #endif

          DIA_TR_INF("Notify Result of BTTestActionRequest");
          pListener->vOnBTTestActionRequestACK(bResult);
       }
    }
    else
    {
        DIA_TR_INF( "OpCode = %d received",poMessage->u8GetOpCode());
    }

    (void) poMessage->bDelete();
    */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBTLocalLoopbackResult ( amt_tclServiceData* /*poMessage*/ ) const
{
    dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBTLocalLoopbackResult()");
/*
    if ( !poMessage || (poMessage->bIsServerMessage() != TRUE) ) return;

    if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
    {
       dia_IBluetoothListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_IBluetoothListener>(&pListener);
       if ( pListener )
       {
          DIA_TR_INF("Received Result of BTLocalLoopbackTestRequest");

          fi_tclVisitorMessage oResultMsg(poMessage);
          midw_ext_phonefi_tclMsgFID_TEL_S_BTM_TEST_LOCAL_LOOPBACK_HCI_MODEMethodResult oCompResp;
          (void) oResultMsg.s32GetData(oCompResp);

          DIA_TR_INF("Notify Result of BTLocalLoopbackTestRequest");
          pListener->vOnBTTestActionRequestACK(oCompResp.bSuccess);
       }
    }
    else
    {
       DIA_TR_INF( "OpCode = %d received",poMessage->u8GetOpCode());
    }

    (void) poMessage->bDelete();
    */
}

//-------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothDeviceVersion ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothDeviceVersion()");
/*
   if ( !poMessage ) return;

   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
   {
      dia_IBluetoothListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IBluetoothListener>(&pListener);
      if (pListener)
      {
         fi_tclVisitorMessage oResultMsg(poMessage);
         midw_ext_phonefi_tclMsgFID_TEL_G_DEV_LOCAL_BT_DEVICE_VERSION_INFOStatus oCompResp;
         (void) oResultMsg.s32GetData(oCompResp);

         midw_ext_fi_tclString btDeviceAddr = oCompResp.sLocalBtAddress.sBTDeviceAddress;

         // size of bluetooth address string
         tU32 btAddr_Size = btDeviceAddr.u32GetSize();
         DIA_TR_INF("dia_SAFeatureBluetooth::vHandleBlueToothDeviceVersion size BTDevice Addr.: %d",btAddr_Size );

         // copy bluetooth address
         char btAddr_Name[DIA_C_U16_MAX_BT_ADDR_SIZE] = { 0 };
         if ( btAddr_Size )
         {
            (void) OSAL_szStringCopy(btAddr_Name,btDeviceAddr);
         }
         btAddr_Name[btAddr_Size] = '\0';

         // inform registered listeners
         pListener->vOnFaciaIDResponse(btAddr_Name, btAddr_Size);
         pListener->vOnBTMACAddressResponse(btAddr_Name, btAddr_Size);
      }
   }
   else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
   {
      amt_tclServiceDataError oErrorMsg(poMessage);
      tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
      DIA_TR_INF("---opcode error recievd with error code:>",u16ErrorCode);
   }
   else
   {
      DIA_TR_INF("OpCode = %d received",poMessage->u8GetOpCode());
   }

   (void) poMessage->bDelete();
   */
}

//-----------------------------------------------------------------------------

//tDiaResult
//dia_SAFeatureBluetooth::resetBTDevice ( void )
//{
//   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::resetBTDevice()");
//
//   tDiaResult retCode = DIA_FAILED;
///*
//   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//   {
//      midw_ext_phonefi_tclMsgFID_TEL_S_DEV_SET_BT_RESET_PIN_STATUSMethodStart oMethodStartData;
//      oMethodStartData.bSwitchBluetoothModuleOn = FALSE;
//
//      //put the data in message
//      fi_tclVisitorMessage oMsg(oMethodStartData);
//      mpSrvPlugin->vInitServiceData(oMsg, MIDW_EXT_PHONEFI_C_U16_FID_TEL_S_DEV_SET_BT_RESET_PIN_STATUS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
//
//      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
//   }
//*/
//   return retCode;
//}

//-----------------------------------------------------------------------------

void
dia_SAFeatureBluetooth::vHandleBlueToothModuleResetResult (amt_tclServiceData* /*poMessage*/) const
{
   dia_tclFnctTrace trc("dia_SAFeatureBluetooth::vHandleBlueToothModuleResetResult()");
/*
   if ( !poMessage ) return;

   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
   {
//      dia_IBluetoothListener* pListener = OSAL_NULL;
//      querySysAdapterListener<dia_IBluetoothListener>(&pListener);
//      if (pListener)
//      {
         fi_tclVisitorMessage oResultMsg(poMessage);
         midw_ext_phonefi_tclMsgFID_TEL_S_DEV_SET_BT_RESET_PIN_STATUSMethodResult oCompResp;
         (void) oResultMsg.s32GetData(oCompResp);

         if ( oCompResp.bSuccess == TRUE )
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vHandleBlueToothModuleResetResult: SUCCEEDED");
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureBluetooth::vHandleBlueToothModuleResetResult: FAILED");
         }

//         // inform registered listeners
//         pListener->vOnFaciaIDResponse(btAddr_Name, btAddr_Size);
//         pListener->vOnBTMACAddressResponse(btAddr_Name, btAddr_Size);
//      }
   }
   else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
   {
      amt_tclServiceDataError oErrorMsg(poMessage);
      tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
      DIA_TR_INF("---opcode error recievd with error code:>",u16ErrorCode);
   }
   else
   {
      DIA_TR_INF("OpCode = %d received",poMessage->u8GetOpCode());
   }

   (void) poMessage->bDelete();
   */
}

#endif //STC2HI: TODO
