/*
 * dia_SAFeatureAux.cpp
 *
 *  Created on: 24.09.2015
 *      Author: shw2abt
 */
// Audio FI: di_middleware_server\components\midw_fi\midw_mascd_fi\midw_mascd_fi.pdf

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SAFeatureAux.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_TYPES
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_FUNCTIONIDS
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_SERVICEINFO
#include "aux_fi_if.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureAux,dia_SystemAdapterFeature)
   ON_MESSAGE(AUX_MAINFI_C_U16_AVAILIBILITY,       vHandleConnectionStatus)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureAux::dia_SAFeatureAux (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureAux::dia_SAFeatureAux");
}

//-----------------------------------------------------------------------------

dia_SAFeatureAux::~dia_SAFeatureAux ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAux::auxConnectionStatus_Get()
{
   dia_tclFnctTrace trc("dia_SAFeatureAux::auxConnectionStatus_Get");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         AUX_MAINFI_C_U16_AVAILIBILITY,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
         retCode = DIA_SUCCESS;
      } else {
         DIA_TR_ERR("dia_SAFeatureAux::auxConnectionStatus_Get Reading of AUX CONNECTIONSTATE FAILED!");
      }
   }
   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

void
dia_SAFeatureAux::vHandleConnectionStatus(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAux::vHandleConnectionStatus");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_IAuxListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IAuxListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            aux_mainfi_tclMsgConnectionStateStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureAux::vHandleConnectionStatus No_of_AUX ports connected = %d .", oReceivedData.oStates.oItems.size());

            dia_eAuxConnectionState connState = DIA_EN_AUX_CONNECTION_UNKNOWN;
            if (oReceivedData.oStates.oItems.size() > 0) {
            	if(oReceivedData.oStates.oItems[0].eAuxSwitchState.enType == aux_fi_tcl_e8_AUXSwitchState::FI_EN_AUX_PLUGGED)
            	{
               connState = DIA_EN_AUX_CONNECTION_ON;
            	}
            	else
            	{
               connState = DIA_EN_AUX_CONNECTION_OFF;
            }
            }
            pListener->vOnConnectionState(connState);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureAux::vHandleConnectionStatus - opcode error received with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
