/*
 * dia_SAFeatureAudioTest.cpp
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 */
// Audio FI: di_middleware_server\components\midw_fi\midw_mascd_fi\midw_mascd_fi.pdf

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SAFeatureAudioTest.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureAudioTest,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART,       vHandleSpeakerTest)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureAudioTest::dia_SAFeatureAudioTest (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioTest::dia_SAFeatureAudioTest");
}

//-----------------------------------------------------------------------------

dia_SAFeatureAudioTest::~dia_SAFeatureAudioTest ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudioTest::startTweeterTest(dia_eAudioTestMode testMode)
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioTest::startTweeterTest()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart oData;

      oData.DC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;
      if (testMode == DIA_EN_AUDIO_TEST_MODE_ON) {
         DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - Set AC DiagMode to qualified (on).");
         oData.AC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED;
      } else {
         DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - Set AC DiagMode to off.");
         oData.AC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;
      }

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudioTest::startTweeterTest - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudioTest::startLoudspeakerTest(dia_eAudioTestMode testMode)
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioTest::startLoudspeakerTest()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart oData;

      oData.AC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;
      if (testMode == DIA_EN_AUDIO_TEST_MODE_ON) {
         DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - Set DC DiagMode to qualified (on).");
         oData.DC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED;
      } else {
         DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - Set DC DiagMode to off.");
         oData.DC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;
      }

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudioTest::startLoudspeakerTest - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

//! covers response from MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART
void
dia_SAFeatureAudioTest::vHandleSpeakerTest(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioTest::vHandleSpeakerTest");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      dia_IAudioTestListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IAudioTestListener>(&pListener);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT) {
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

//            DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone ChannelSelect.u8Value=0x%02x .", oCompResp.ChannelSelect.u8Value);
//            DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone Status Compare is %s .", oCompResp.Status.enType!=midw_fi_tcl_e8_Aud_TestToneControl::FI_EN_FC_AUDIO_TEST_TONE_UNDEF?"OK":"Not OK");

            // currently only TweeterTest (AC) is expected; DC cause an Error

            DIA_TR_INF("dia_SAFeatureAudioTest::vHandleSpeakerTest oCompResp.Status %s e8_DiagState::FI_EN_OFF.", oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_OFF ? "==" : "!=");
            DIA_TR_INF("dia_SAFeatureAudioTest::vHandleSpeakerTest oCompResp.Status %s e8_DiagState::FI_EN_DC_STARTED.", oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_DC_STARTED ? "==" : "!=");
            DIA_TR_INF("dia_SAFeatureAudioTest::vHandleSpeakerTest oCompResp.Status %s e8_DiagState::FI_EN_AC_STARTED.", oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_AC_STARTED ? "==" : "!=");

            if (oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_DC_STARTED || oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_AC_STARTED || oCompResp.Status.enType == midw_fi_tcl_e8_DiagState::FI_EN_OFF) {
               DIA_TR_INF("dia_SAFeatureAudioTest::vHandleSpeakerTest case covered.");
               pListener->vOnTweeterTest(DIA_SUCCESS);
               pListener->vOnLoudspeakerTest(DIA_SUCCESS);
            } else {
               DIA_TR_ERR("dia_SAFeatureAudioTest::vHandleSpeakerTest Not covered component response received: Status=0x%02x.", oCompResp.Status.enType);
               pListener->vOnTweeterTest(DIA_FAILED);
               pListener->vOnLoudspeakerTest(DIA_FAILED);
            }
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureAudio::vHandleSpeakerTest - opcode error received with error code: %d", u16ErrorCode);
         pListener->vOnTweeterTest(DIA_E_ERROR);
         pListener->vOnLoudspeakerTest(DIA_E_ERROR);
      }

      (void) poMessage->bDelete();
   }
}
