/*!
 * \file       dia_SAFeatureAudioSinkControlDiaglib.h
 *
 * \brief      SAFeature used to change the audio sink using Diaglib
 *
 * \details    SAFeature used to change the audio sink using Diaglib
 *
 * \component  Diagnosis
 *
 * \ingroup    diaSysAdaptersProject
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_AUDIO_SINK_CONTROL_DIAGLIB__
#define __INCLUDED_DIA_SAFEATURE_AUDIO_SINK_CONTROL_DIAGLIB__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_SINK_LISTENER__
#include "common/interfaces/dia_IAudioSinkListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include <common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h>
#endif

namespace dia {

class SAFeatureAudioSinkControlDiaglib
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IAudioSink,
     public dia_IDiaglibIoControlListener
{
public:
   //! constructor
   SAFeatureAudioSinkControlDiaglib ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~SAFeatureAudioSinkControlDiaglib ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnIoCtrlResult ( tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAudioSink methods
   //
   //-------------------------------------------------------------------------

   //! set the audio sink
   virtual tDiaResult setAudioSink ( dia_eAudioSink sink, dia_eAudioSoundSystem soundSystem );

protected:
   //! deprecated default constructor
   SAFeatureAudioSinkControlDiaglib ( void );

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(SAFeatureAudioSinkControlDiaglib)
};

}

#endif /* __INCLUDED_DIA_SAFEATURE_AUDIO_SINK_CONTROL_DIAGLIB__ */
