/*!
 * \file       dia_SAFeatureAudioSinkControlDiaglib.cpp
 *
 * \brief      SAFeature used to change the audio sink using Diaglib
 *
 * \details    SAFeature used to change the audio sink using Diaglib
 *
 * \component  Diagnosis
 *
 * \ingroup    diaSysAdaptersProject
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureAudioSinkControlDiaglib.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include <project/framework/sysadapters/dia_SAFeatureDiaglib.h>
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia::SAFeatureAudioSinkControlDiaglib,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//namespace dia {

//------------------------------------------------------------------------------

dia::SAFeatureAudioSinkControlDiaglib::SAFeatureAudioSinkControlDiaglib ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("SAFeatureAudioSinkControlDiaglib::SAFeatureAudioSinkControlDiaglib");
}

//-----------------------------------------------------------------------------

dia::SAFeatureAudioSinkControlDiaglib::~SAFeatureAudioSinkControlDiaglib ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia::SAFeatureAudioSinkControlDiaglib::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_AUDIO_ACTIVE_SINK);
   return DIA_SUCCESS;
}

//#define IOCONTROLID_AUDIO_ACTIVE_SINK 24
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_SET_u8Sink 0
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM1 (tU8)1
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_SET_u8SoundSystem 0
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM2 (tU8)1
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_SET_LEN (tU8)2
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_u8Sink 0
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_PARAM1 (tU8)1
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_u8SoundSystem 0
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_PARAM2 (tU8)1
//#define IOCONTROLID_AUDIO_ACTIVE_SINK_RESULT_LEN (tU8)2

//-----------------------------------------------------------------------------

tDiaResult
dia::SAFeatureAudioSinkControlDiaglib::setAudioSink ( dia_eAudioSink sink, dia_eAudioSoundSystem soundSystem )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioSinkControlDiaglib::setAudioSink()");

   if ( (sink != DIA_EN_AUDIO_SINK_SPEAKER) || (soundSystem != DIA_EN_AUDIO_SOUNDSYSTEM_SPEAKER) )
   {
      DIA_TR_ERR("dia::SAFeatureAudioSinkControlDiaglib::setAudioSink: INVALID PARAMETERS (sink=%d,soundsystem=%d)",sink,soundSystem);
      return DIA_FAILED;
   }

   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;

   trParameter paramAudioSink;
   paramAudioSink.enType  = static_cast<tenParameterType>(IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM1);
   paramAudioSink.u8Value = (tU8) sink;
   vecRequest.push_back(paramAudioSink);

   trParameter paramAudioSoundSystem;
   paramAudioSoundSystem.enType  = static_cast<tenParameterType>(IOCONTROLID_AUDIO_ACTIVE_SINK_SET_PARAM2);
   paramAudioSoundSystem.u8Value = (tU8) soundSystem;
   vecRequest.push_back(paramAudioSoundSystem);

   DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib::setAudioSink - sending sink = 0x%02x, soundSystem = 0x%02x", paramAudioSink.u8Value,paramAudioSoundSystem.u8Value);

   if ( dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_ACTIVE_SINK, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE )
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib::setAudioSink - bIOControlStart - SUCCESS.");
   }
   else
   {
      DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib::setAudioSink - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

tVoid
dia::SAFeatureAudioSinkControlDiaglib::vHandleIOControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioSinkControlDiaglib::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

tVoid
dia::SAFeatureAudioSinkControlDiaglib::vOnIoCtrlResult ( tU32 id, tenIoCtrlResult enResult, tenIoControlAction /*enActionId*/, const tDiaglibParamVector& oStartResult )
{
   dia_tclFnctTrace trc("dia::SAFeatureAudioSinkControlDiaglib::vOnIoCtrlResult()");

   dia_IAudioSinkListener* pListener = OSAL_NULL;
   if ( (querySysAdapterListener<dia_IAudioSinkListener>(&pListener) == DIA_SUCCESS) && pListener )
   {
      switch ( id )
      {
      case IOCONTROLID_AUDIO_ACTIVE_SINK:
         {
            DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib - id = IOCONTROLID_AUDIO_ACTIVE_SINK.");
            tU8 sink = static_cast<tU8>(oStartResult[0].u8Value);
            tU8 soundSystem = static_cast<tU8>(oStartResult[1].u8Value);
            DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib::vOnIoCtrlResult - sink = 0x%02x, soundSystem = 0x%02x",sink,soundSystem);
            tDiaResult result = ( enResult == EN_IO_CONTROL_OK ) ? DIA_SUCCESS : DIA_FAILED;
            DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib - %s !!", (result == DIA_SUCCESS) ? "EN_IO_CONTROL_ OK" : "EN_IO_CONTROL_NOK");
            pListener->onAudioSinkSet(result);
         }
         break;
      default:
         DIA_TR_ERR("dia::SAFeatureAudioSinkControlDiaglib - RECEIVED UNKNOWN IOCTRL ID !!");
         break;
      }
   }
   else
   {
      DIA_TR_INF("dia::SAFeatureAudioSinkControlDiaglib - NO INTERFACE OR NO LISTENER REGISTERED !!");
   }
}

//}


