/*
 * dia_SAFeatureADRContainer.cpp
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/framework/application/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ADR_LISTENER__
#include "common/interfaces/dia_IADR3Listener.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_SAFeatureADRContainer.cpp.trc.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "dia_SAFeatureADRContainer.h"

using namespace std;

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureADRContainer,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER, vHandleADRContainerResponse)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureADRContainer::dia_SAFeatureADRContainer (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureADRContainer::dia_SAFeatureADRContainer");
}

//-----------------------------------------------------------------------------

dia_SAFeatureADRContainer::~dia_SAFeatureADRContainer ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureADRContainer::sendADRContainerMessage ( std::vector<tU8>& adrMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureADRContainer::sendADRContainerMessage()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureADRContainer::sendADRContainerMessage - sending message.");

      // create CCA message instance
      midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart oMsgData;

      // populate the message with data
      for ( vector<tU8>::iterator i=adrMessage.begin(); i != adrMessage.end(); i++ )
      {
         oMsgData.GenericBytes.push_back(*i);
      }
      oMsgData.u8DataLength = (tU8) adrMessage.size();

      // send the message to the ADR3
      fi_tclVisitorMessage oMessage(oMsgData);
      mpSrvPlugin->vInitServiceData(oMessage,MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureADRContainer::vHandleADRContainerResponse ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureADRContainer::vHandleADRContainerResponse()");

   if ( !poMessage ) return;

   switch ( poMessage->u8GetOpCode() )
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("OPCODE = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         fi_tclVisitorMessage oResultMsg(poMessage);
         midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult oMethodResult;
         (tVoid) oResultMsg.s32GetData(oMethodResult);

         std::vector<tU8> adrResponse;
         for ( tU8 i=0; i<oMethodResult.u8AdrContainerResult.u8DataLength; i++ )
         {
            tU8 byteData = oMethodResult.u8AdrContainerResult.GenericBytes[i];
            adrResponse.push_back(byteData);
            DIA_TR_INF("ADR_RESPONSE[%02d]: 0x%02x", i, byteData);
         }

         dia_IADRListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IADRListener>(&pListener);
         if ( pListener )
         {
            pListener->vOnADRContainerMessageResponse(adrResponse);
         }
         else
         {
             ETG_TRACE_SYS(("dia_SAFeatureADRContainer::vHandleADRContainerResponse - No listener registered. Discarded!"));
         }
      }
      break;

   default:
      DIA_TR_INF("OPCODE NOT SUPPORTED !!");
      break;
   }

   (tVoid) poMessage->bDelete();
}

