#ifndef __INCLUDED_DIA_SIGMAVTDDSTORE__
#define __INCLUDED_DIA_SIGMAVTDDSTORE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAVTDDRECORD__
#include "project/framework/sigma/dia_SigmaVTDDRecord.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

class dia_SigmaVTDDStore
{
private:
   std::vector<dia_SigmaVTDDRecord> records;
   tU32 slots;
private:
   void init();
public:
   dia_SigmaVTDDStore(tU32 maxSlots);
   void readData(tU32 slot, std::vector<tU8>& buffer) const;
   void storeData(tU32 slot, tU32 sigNo);
   void getAsBuffer(std::vector<tU8>& buffer) const;
   std::vector<tU8>::const_iterator setFromBuffer(std::vector<tU8>::const_iterator it);
   void clear() {init();}
};

#endif