#ifndef __INCLUDED_DIA_SIGMAVTDDRECORD__
#include <project/framework/sigma/dia_SigmaVTDDRecord.h>
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif

tU32 dia_SigmaVTDDRecord::basedVoltageLogHandle = 0;
tU32 dia_SigmaVTDDRecord::standardVoltageLogHandle = 0;
tU32 dia_SigmaVTDDRecord::diagMuxOnLogHandle = 0;
tU32 dia_SigmaVTDDRecord::ignStatusLogHandle = 0;
tU32 dia_SigmaVTDDRecord::cutOffLogHandle = 0;
tU32 dia_SigmaVTDDRecord::odbDiagMuxOnLogHandle = 0;
tU32 dia_SigmaVTDDRecord::gadeLogHandle = 0;
tU32 dia_SigmaVTDDRecord::wakeUpSleepLogHandle = 0;
tU32 dia_SigmaVTDDRecord::refuseToSleepLogHandle = 0;

dia_SigmaVTDDRecord::dia_SigmaVTDDRecord(): 
   dia_SigmaRecord(RECORD_SIZE, 0xff) 
{
}

dia_SigmaVTDDRecord::dia_SigmaVTDDRecord(tU8 sigNo): 
   dia_SigmaRecord(RECORD_SIZE, 0) 
{
   addData(sigNo, SIGNO_OFFSET);
}

void dia_SigmaVTDDRecord::setData(tS32 timeOffset)
{
   dia_DataLogger* pDataLogger = dia_DataLogger::getInstance();
   if (pDataLogger) 
   {
      dia_DataLoggerRecord dlr;
      pDataLogger->getData(dlr, timeOffset);
      tU32 offset = calcTimeOffset(timeOffset);
      eCanGen canGen = dia_Sigma::getCanGen();
      if(canGen == AIVI_CAN_GEN_3) // gen3
      {
         std::vector<tU8> cutOut;
         tU32 byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(basedVoltageLogHandle),   BASED_VOLTAGE_BYTE_START,     BASED_VOLTAGE_BIT_START,   BASED_VOLTAGE_BIT_SIZE, offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(diagMuxOnLogHandle),           DIAG_MUX_ON_BYTE_START,       DIAG_MUX_ON_BIT_START,     DIAG_MUX_ON_BIT_SIZE,   offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(wakeUpSleepLogHandle),         WAKE_UP_SLEEP_BYTE_START,     WAKE_UP_SLEEP_BIT_START,   WAKE_UP_SLEEP_BIT_SIZE, offset, cutOut);
         addData(cutOut, byteStart);
      }
      else if(canGen == AIVI_CAN_GEN_5) // gen5
      {
         std::vector<tU8> cutOut;
         tU32 byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(basedVoltageLogHandle),   BASED_VOLTAGE_BYTE_START,     BASED_VOLTAGE_BIT_START,   BASED_VOLTAGE_BIT_SIZE, offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(diagMuxOnLogHandle),           DIAG_MUX_ON_BYTE_START,       DIAG_MUX_ON_BIT_START,     DIAG_MUX_ON_BIT_SIZE,   offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(ignStatusLogHandle),           IGN_STATUS_BYTE_START,        IGN_STATUS_BIT_START,      IGN_STATUS_BIT_SIZE,    offset, cutOut);
         addData(cutOut, byteStart);
      }
      else if(canGen == AIVI_CAN_GEN_6) // gen6
      {
         std::vector<tU8> cutOut;
         tU32 byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(basedVoltageLogHandle),   BASED_VOLTAGE_BYTE_START,     BASED_VOLTAGE_BIT_START,   BASED_VOLTAGE_BIT_SIZE, offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(ignStatusLogHandle),           IGN_STATUS_BYTE_START_C1A,    IGN_STATUS_BIT_START_C1A,  IGN_STATUS_BIT_SIZE_C1A,offset, cutOut);
         addData(cutOut, byteStart);
         cutOut.clear();
         byteStart = dia_SigmaRecord::makeCutOut(dlr.getItemData(gadeLogHandle),                GADE_BYTE_START_C1A,          GADE_BIT_START_C1A,        GADE_BIT_SIZE_C1A,      offset, cutOut);
         addData(cutOut, byteStart);//Coverity Fix(CID:143890)
      }
   }
}
