#ifndef __INCLUDED_DIA_SIGMAREQUEST__
#include "project/framework/sigma/dia_SigmaRequest.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include "common/framework/datalogger/dia_DataLogger.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAVSSDRECORD__
#include "project/framework/sigma/dia_SigmaVSSDRecord.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif


dia_SigmaRequest::dia_SigmaRequest(): 
   sigmaDataStore(0), 
   isTriggered(false), 
   count(0),
   syncObj("dia_SigmaRequest_LK")
{
}

dia_SigmaRequest::~dia_SigmaRequest()
{
   sigmaDataStore = 0;
}

void dia_SigmaRequest::storeData()
{
   dia_LockScope lock(this->syncObj);
   dia_tclFnctTrace oTrace("dia_SigmaRequest::storeData");
   ++this->count;
   static const tU32 maxCount = dia_DataLogger::futurePeriod/dia_DataLogger::resolution;
   if(this->count >= maxCount)
   {
      this->count = 0;
      this->stop();
      if(this->sigmaDataStore != 0)
      {
         this->sigmaDataStore->store(triggerFrames, info, isTriggered);
         this->sigmaDataStore->saveDataStore();
         this->sigmaDataStore = 0;
      }
      DIA_TR_INF("dia_SigmaRequest::storeData => deleting frames");
      triggerFrames.clear();
      this->info.clear();
   }
}

void dia_SigmaRequest::request(dia_SigmaDataStore& dataStore, dia_SIGMATriggerFrame const& triggerFrame, bool triggered)
{
   dia_LockScope lock(this->syncObj);
   dia_tclFnctTrace oTrace("dia_SigmaRequest::request");
   if(triggerFrames.size() >= dia_SigmaVSSDRecord::maxTriggerFrames)
   {
      DIA_TR_INF("dia_SigmaRequest::request => max frames reached");
      return;
   }
   if(hasDtc(triggerFrame.getDtc()))
   {
      DIA_TR_INF("dia_SigmaRequest::request => duplicate DTC in trigger frame");
      return;
   }
   this->triggerFrames.push_back(triggerFrame);
   this->info.push_back(getCount());
   if(triggerFrames.size() == 1)
   {
      DIA_TR_INF("dia_SigmaRequest::request => starting request timer");
      this->sigmaDataStore = &dataStore;
      this->isTriggered= triggered;
      this->start();
   }
}

bool dia_SigmaRequest::hasDtc(tU32 dtc) const
{
   for(int i = 0; i < this->triggerFrames.size(); ++i)
   {
      if(this->triggerFrames[i].getDtc() == dtc)
      {
         return true;
      }
   }
   return false;
}