#ifndef __INCLUDED_DIA_SIGMARECORD__
#define __INCLUDED_DIA_SIGMARECORD__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

class dia_SigmaRecord
{
public:
   dia_SigmaRecord();
   dia_SigmaRecord(tU32 size, tU8 defChar): data(size, defChar) {}
   dia_SigmaRecord(dia_SigmaRecord const& src) {src.getAsBuffer(this->data);}
   dia_SigmaRecord& operator=(dia_SigmaRecord const& src)  {src.getAsBuffer(this->data); return *this;}
private:
   std::vector<tU8> data;
public:
   void addData(tU8 src, tU32 byteStart);
   void addData(std::vector<tU8> const& src, tU32 byteStart);
   void getAsBuffer(std::vector<tU8>& buffer) const;
   tU8 getData(tU32 byteStart) const {return this->data[byteStart];}
   std::vector<tU8>::const_iterator setFromBuffer(std::vector<tU8>::const_iterator it); 
   static tU32 shiftLeft(tU32 src, tS32 shift);
   static tU32 shiftRight(tU32 src, tS32 shift);
   static tU32 bytePosition(tU32 byteStart, tU32 bitStart, tU32 bizSize, tU32 offset);
   static tU32 byteCount(tU32 byteStart, tU32 bitStart, tU32 bizSize, tU32 offset);
   static tU32 bitPosition(tU32 byteStart, tU32 bitStart, tU32 bizSize, tU32 offset);
   static tU32 makeCutOut(std::vector<tU8> const& src, tU32 byteStart, tU32 bitStart, tU32 bitSize, tU32 offset, std::vector<tU8>& cutOut);
};

#endif