#ifndef __INCLUDED_DIA_SIGMADATASTORE__
#define __INCLUDED_DIA_SIGMADATASTORE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAVSSDSTORE__
#include "project/framework/sigma/dia_SigmaVSSDStore.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAVTDDSTORE__
#include "project/framework/sigma/dia_SigmaVTDDStore.h"
#endif

#ifndef __INCLUDED_DIA_SIGMATRIGGERFRAME__
#include "project/framework/sigma/dia_SigmaTriggerFrame.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

class dia_SigmaDataStore
{
private:
   static const tU32 firstOverwrittenTriggerSlot = 2;
   static const tU32 maxTriggeredSlots = 5;
   static const tU32 firstNonTriggeredSlot = 5;
   static const tU32 maxNonTriggeredSlots = 11;
   dia_SigmaVSSDStore vssd;
   dia_SigmaVTDDStore vtdd;
   tU32 nextTriggeredSlot;
   tU32 nextNonTriggeredSlot;
   tU32 sigmaNumber;
   mutable dia_Lock syncObj;
private:
   tU32 getNextTriggeredSlot();
   tU32 getNextNonTriggeredSlot();
   void appendVSSDData(std::vector<tU8>& buffer, tU32 firstSlot, tU32 lastSlot) const;
   void appendVTDDData(std::vector<tU8>& buffer, tU32 slot) const;
public:
   dia_SigmaDataStore(dia_SigmaDataStore const&);
   dia_SigmaDataStore const& operator=(dia_SigmaDataStore const&);//coverity fix:52376:
   dia_SigmaDataStore();
   ~dia_SigmaDataStore();
   dia_SigmaDataStore const& operator==(dia_SigmaDataStore const&);

   std::vector<tU8>::size_type retrieve(tU32 did, std::vector<tU8>& buffer) const;
   void store(std::vector<dia_SIGMATriggerFrame> const& triggerFrames, std::vector<tU32> const& info, bool triggered);
   void saveDataStore() const;
   void loadDataStore();
   void clear();
};

#endif
