#ifndef __INCLUDED_DIA_SIGMADATASTORE__
#include "project/framework/sigma/dia_SigmaDataStore.h"
#endif
#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGERITEM__
#include "common/framework/datalogger/dia_DataLoggerItem.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include "common/framework/datalogger/dia_DataLogger.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_SIGMACSM__
#include "project/framework/sigma/dia_SigmaCSM.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include <project/framework/config/dia_defsProjectConfig.h>
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_FILE__
#include <common/framework/config/dia_PropertyBagFile.h>
#endif

dia_SigmaDataStore::dia_SigmaDataStore():
   vssd(maxTriggeredSlots + maxNonTriggeredSlots),
   vtdd(maxTriggeredSlots + maxNonTriggeredSlots),
   nextTriggeredSlot(0),
   nextNonTriggeredSlot(dia_SigmaDataStore::firstNonTriggeredSlot),
   sigmaNumber(0),
   syncObj("dia_Sigma_LK")
{
   dia_tclFnctTrace oTrace("dia_SigmaDataStore::dia_SigmaDataStore");
   dia_DataLogger* pDataLogger = dia_DataLogger::getInstance();
   if (pDataLogger)
   {
   
//Task 239541 , Task 243961
#if 0
      DIA_TR_INF("dia_SigmaDataStore::dia_SigmaDataStore: adding logged items");
      eCanGen canGen = dia_Sigma::getCanGen();
      // Mileage
      dia_SigmaVSSDRecord::setMileageLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DistanceTotalizer, 4)));
      // IGN_Status
      tU32 ignStatusLogHandle = pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_IgnitionSupplyConfirmation, 1));
      dia_SigmaVSSDRecord::setIgnStatusLogHandle(ignStatusLogHandle);
      if(canGen == AIVI_CAN_GEN_3) // gen3
      {
         DIA_TR_INF("dia_SigmaDataStore::dia_SigmaDataStore: adding logged items for CAN gen 3");
         dia_SigmaVSSDRecord::setMileageUnitLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_Cluster_MarketInformation, 1)));
         // Based/Battery Vol
         dia_SigmaVTDDRecord::setBasedVoltageLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BatteryVoltage, 1)));
         // DiagMuxOn
         dia_SigmaVTDDRecord::setDiagMuxOnLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DiagMuxOn_84, 1)));
         // BCM_WakeUpSleepCommoand
         dia_SigmaVTDDRecord::setWakeUpSleepLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BCM_WakeUpSleepCommand, 1)));
      }
      else if(canGen == AIVI_CAN_GEN_5) // gen5
      {
         DIA_TR_INF("dia_SigmaDataStore::dia_SigmaDataStore: adding logged items for CAN gen 5");
         dia_SigmaVSSDRecord::setMileageUnitLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DistanceUnit, 1)));
         // Based/Battery Vol
         dia_SigmaVTDDRecord::setBasedVoltageLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BatteryVoltage, 1)));
         // DiagMuxOn
         dia_SigmaVTDDRecord::setDiagMuxOnLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DiagMuxOn_BCM, 1)));
         // IGN_Status
         dia_SigmaVTDDRecord::setIgnStatusLogHandle(ignStatusLogHandle);
      }
      else if(canGen == AIVI_CAN_GEN_6) // gen6
      {
         DIA_TR_INF("dia_SigmaDataStore::dia_SigmaDataStore: adding logged items for CAN gen 6");
         // Based/Battery Vol
         dia_SigmaVTDDRecord::setBasedVoltageLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BatteryVoltage, 1)));
         // IGN_Status
         dia_SigmaVTDDRecord::setIgnStatusLogHandle(ignStatusLogHandle);
         // GADE
         dia_SigmaVTDDRecord::setGADELogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_GADE, 1)));
      }
      else
      {
         DIA_TR_ERR("dia_SigmaDataStore::dia_SigmaDataStore: unsupported CAN generation encountered!: %d", canGen);
      }
      // ECU/Standard Vol
      // dia_SigmaVTDDRecord::setStandardVoltageLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BatteryVoltage, 2)));
      // CutOffSW
      // dia_SigmaVTDDRecord::setCutOffLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DeliveryModeInformation_v2, 1)));
      // ODB_DiagMuxOn
      // dia_SigmaVTDDRecord::setODBDiagMuxOnLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_DiagMuxOn, 1)));
      // USM_RefusetoSleep
      // dia_SigmaVTDDRecord::setRefuseToSleepLogHandle(pDataLogger->addLoggedItem(dia_CSMWrapper::createCSMLogItem(CSM_C_ASIG_RX_BCM_WakeUpSleepCommand, 1)));
#endif
   }
}

dia_SigmaDataStore::~dia_SigmaDataStore()
{
   // delete items
}

tU32 dia_SigmaDataStore::getNextTriggeredSlot()
{
   tU32 result = this->nextTriggeredSlot;
   ++this->nextTriggeredSlot;
   if(this->nextTriggeredSlot == dia_SigmaDataStore::maxTriggeredSlots)
   {
      this->nextTriggeredSlot = dia_SigmaDataStore::firstOverwrittenTriggerSlot;
   }
   return result;
}

tU32 dia_SigmaDataStore::getNextNonTriggeredSlot()
{
   tU32 result = this->nextNonTriggeredSlot;
   ++this->nextNonTriggeredSlot;
   if(this->nextNonTriggeredSlot >= dia_SigmaDataStore::maxNonTriggeredSlots)
   {
      this->nextNonTriggeredSlot = dia_SigmaDataStore::firstNonTriggeredSlot;
   }
   return result;
}

void dia_SigmaDataStore::appendVSSDData(std::vector<tU8>& buffer, tU32 firstSlot, tU32 lastSlot) const
{
   std::vector<tU8> slotData;
   for(tU32 slot = firstSlot; slot <= lastSlot; ++slot)
   {
      slotData.clear();
      this->vssd.readData(slot, slotData);
      buffer.insert(buffer.end(), slotData.begin(), slotData.end()); //lint !e864 Info: expression possibly depends on order of evaluation
   }
}

void dia_SigmaDataStore::appendVTDDData(std::vector<tU8>& buffer, tU32 slot) const
{
   this->vtdd.readData(slot, buffer);
}

std::vector<tU8>::size_type dia_SigmaDataStore::retrieve(tU32 did, std::vector<tU8>& buffer) const
{
   dia_LockScope lock(this->syncObj);
   if(did == DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_00)
   {
      DIA_TR_INF("dia_SigmaDataStore::retrieve DID %d", did);
      appendVSSDData(buffer, 0, 4);
   }
   else if(did == DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_01)
   {
      appendVSSDData(buffer, 5, 9);
   }
   else if(did == DIA_C_U16_DID_AIVI_VEHICLE_SNAPSHOT_DATA_FRAMES_02)
   {
      appendVSSDData(buffer, 10, 15);
   }
   else if  (
            (did >= DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_01)
            && 
            (did <= DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_32)
            )
   {
      appendVTDDData(buffer, did - DIA_C_U16_DID_AIVI_VEHICLE_TIME_DOMAIN_DATA_SET_01);
   }
   return buffer.size();
}

void dia_SigmaDataStore::store(std::vector<dia_SIGMATriggerFrame> const& triggerFrames, std::vector<tU32> const& info, bool triggered)
{
   dia_tclFnctTrace oTrace("dia_SigmaDataStore::store");
   dia_LockScope lock(this->syncObj);
   tU32 slot = triggered? getNextTriggeredSlot(): getNextNonTriggeredSlot();
   DIA_TR_INF("dia_SigmaDataStore::store => storing to slot %d", slot);
   this->vssd.storeData(slot, this->sigmaNumber, triggered, triggerFrames, info);
   this->vtdd.storeData(slot, this->sigmaNumber);
   this->sigmaNumber = (this->sigmaNumber == 255)? 0: this->sigmaNumber + 1;
}

void dia_SigmaDataStore::saveDataStore() const
{
   dia_tclFnctTrace oTrace("dia_SigmaDataStore::saveDataStore");
   dia_LockScope lock(this->syncObj);
   std::vector<tU8> db;

   DIA_TR_INF("dia_SigmaDataStore::saveDataStore: nextTriggeredSlot = %d", this->nextTriggeredSlot);
   db.push_back(this->nextTriggeredSlot & 0xff);
   DIA_TR_INF("dia_SigmaDataStore::saveDataStore: nextNonTriggeredSlot = %d", this->nextTriggeredSlot);
   db.push_back(this->nextNonTriggeredSlot & 0xff);
   DIA_TR_INF("dia_SigmaDataStore::saveDataStore: sigmaNumber = %d", this->nextTriggeredSlot);
   db.push_back(this->sigmaNumber & 0xff);

   std::vector<tU8> ssd;
   this->vssd.getAsBuffer(ssd);
   db.insert(db.end(), ssd.begin(), ssd.end()); //lint !e864 Info: expression possibly depends on order of evaluation
   std::vector<tU8> tdd;
   this->vtdd.getAsBuffer(tdd);
   db.insert(db.end(), tdd.begin(), tdd.end()); //lint !e864 Info: expression possibly depends on order of evaluation
   // write via configmanager
   dia_PropertyBagFile propBag;
   propBag.setProperty(DIA_PROP_AIVI_SIGMA_DATA, db);
}

void dia_SigmaDataStore::loadDataStore()
{
   dia_tclFnctTrace oTrace("dia_SigmaDataStore::loadDataStore");
   dia_LockScope lock(this->syncObj);
   std::vector<tU8> db;
   _BP_TRY_BEGIN
   {
      // read via configmanager
      dia_PropertyBagFile propBag;
      propBag.getProperty(DIA_PROP_AIVI_SIGMA_DATA, db);
      if(db.size() > 0)
      {
         std::vector<tU8>::const_iterator it = db.begin();
         this->nextTriggeredSlot = *it++;
         DIA_TR_INF("dia_SigmaDataStore::loadDataStore: nextTriggeredSlot = %d", this->nextTriggeredSlot);
         this->nextNonTriggeredSlot = *it++;
         DIA_TR_INF("dia_SigmaDataStore::loadDataStore: nextNonTriggeredSlot = %d", this->nextTriggeredSlot);
         this->sigmaNumber = *it++;
         DIA_TR_INF("dia_SigmaDataStore::loadDataStore: sigmaNumber = %d", this->nextTriggeredSlot);
         it = this->vssd.setFromBuffer(it);
         this->vtdd.setFromBuffer(it);
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("dia_SigmaDataStore::loadDataStore: EXCEPTION FAILED");
   }
   _BP_CATCH_END
}

void dia_SigmaDataStore::clear()
{
   nextTriggeredSlot = 0;
   nextNonTriggeredSlot = dia_SigmaDataStore::firstNonTriggeredSlot;
   sigmaNumber = 0;
   this->vssd.clear();
   this->vtdd.clear();
}
