#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif
#ifndef __INCLUDED_DIA_SIGMACSM__
#include "project/framework/sigma/dia_SigmaCSM.h"
#endif
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif
#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include <boost/bind.hpp> 

DIA_IMPL_SINGLETON(dia_Sigma)

dia_Sigma* getInstanceOfSigma ( void )
{
   return dia_Sigma::getInstance();
}

void releaseInstanceOfSigma ( void )
{
   dia_Sigma::deleteInstance();
}

const tU32 SigmaDTCTriggers::dtcAmpTemperatureUp;
const tU32 SigmaDTCTriggers::dtcAVCommunication;
const tU32 SigmaDTCTriggers::dtcCANCommunication;
const tU32 SigmaDTCTriggers::dtcHighVoltageError;
const tU32 SigmaDTCTriggers::dtcHUHighTemperature;
const tU32 SigmaDTCTriggers::dtcLowVoltageError;

SigmaDTCTriggers::SigmaDTCTriggers()
{
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcAmpTemperatureUp);
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcAVCommunication);
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcCANCommunication);
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcHighVoltageError);
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcHUHighTemperature);
   this->triggeredDTCs.push_back(SigmaDTCTriggers::dtcLowVoltageError);
}

bool SigmaDTCTriggers::isDTCTrigger(tU32 dtc) const
{
   std::vector<tU32>::const_iterator it = std::find(this->triggeredDTCs.begin(), this->triggeredDTCs.end(), dtc);
   return (it != this->triggeredDTCs.end());
}

dia_Sigma::dia_Sigma()
{
   dia_tclFnctTrace oTrace("dia_Sigma::dia_Sigma");
   this->data.loadDataStore();
}

bool dia_Sigma::isConfigured()
{
   tU8 configData[DIA_AIVI_VARIANT_CODING_LENGTH] = {0};
   if(dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, configData, DIA_AIVI_VARIANT_CODING_LENGTH) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### AIVI VARIANT CODING NOT AVAILABLE !!! #####");
      return false;
   }
   const tS32 diagnosisByte = 3;
   const tU8 sigmaMask = 0x01;
   tU8 sigmaBit = configData[diagnosisByte] & sigmaMask;

   return (sigmaBit != 0);
}


void dia_Sigma::start()
{
   dia_tclFnctTrace oTrace("dia_Sigma::start");
   dia_CSMWrapper::getInstance()->init();
   dia_CSMWrapper::getInstance()->registerForTriggerFrame();
   setSysAdapterListener<dia_IErrorLogListener>(this);
}

void dia_Sigma::stop()
{
   unsetSysAdapterListener<dia_IErrorLogListener>(this);
   dia_CSMWrapper::getInstance()->unregisterForTriggerFrame();
}

void dia_Sigma::localDTCEvent(tU32 dtc, bool triggered)
{
   dia_tclFnctTrace oTrace("dia_Sigma::localDTCEvent");
   dia_SIGMATriggerFrame triggerFrame(dtc, dia_Sigma::ecu);
   if(triggered)
   {
      triggerFrame.send();
   }
   this->dataRequest.request(this->data, triggerFrame, triggered);
}

std::vector<tU8>::size_type dia_Sigma::getData(tU16 did, std::vector<tU8>& buffer) const
{
   dia_tclFnctTrace oTrace("dia_Sigma::getData");
   return this->data.retrieve(did, buffer);
}

void dia_Sigma::localTriggerDTCEvent(tU32 dtc) 
{
   localDTCEvent(dtc, true);
}

void dia_Sigma::externalTriggerEvent(dia_SIGMATriggerFrame triggerFrame) 
{
   if(triggerFrame.isSameEcu(dia_Sigma::ecu) == false)
   {
      this->dataRequest.request(this->data, triggerFrame, true);
   }
}

void dia_Sigma::vOnFailedDTCList ( std::list<tU32>& failedDTCs )
{
   dia_tclFnctTrace oTrace("dia_Sigma::vOnFailedDTCList");
   std::for_each(failedDTCs.begin(), failedDTCs.end(), ::boost::bind(&dia_Sigma::disptachTriggerFrame, this, _1)); //lint !e864 Info: expression possibly depends on order of evaluation
}

void dia_Sigma::disptachTriggerFrame(tU32 dtc)
{
   dia_tclFnctTrace oTrace("dia_Sigma::disptachTriggerFrame");
   if(this->dtcTriggers.isDTCTrigger(dtc))
   {
      localTriggerDTCEvent(dtc);
   }
   else
   {
      localNonTriggerDTCEvent<dia_Sigma::nonTriggeredEvents>(dtc);
   }
}

void dia_Sigma::vOnClearResult()
{
   clearData();
   this->data.saveDataStore();
}

void dia_Sigma::clearData()
{
   this->data.clear();
}

eCanGen dia_Sigma::getCanGen()
{
   tU8 propValue = 0;
   static eCanGen canGen = AIVI_CAN_GEN_UNKNOWN;
   if(canGen == AIVI_CAN_GEN_UNKNOWN)
   {
	   // CID - 143610 Fix
	   if (dia_getProperty(DIA_PROP_AIVI_CAN_GEN_NUMBER, propValue) == DIA_SUCCESS )
	   {
		   canGen = static_cast<eCanGen>(propValue);
	   }
   }
   return canGen;
}
