/**
 * \file      dia_SecurityLevelAIVI.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    stc2hi
 * \date      Aug 29, 2016
 *
 * \copyright Robert Bosch Car Multimedia 2016
 */


#ifndef __INCLUDED_DIA_SECURITY_LEVEL_AIVI__
#define __INCLUDED_DIA_SECURITY_LEVEL_AIVI__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL__
#include "common/framework/security/dia_SecurityLevel.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__
#include "project/interfaces/dia_IAIVISecurityListener.h"
#endif

class dia_SecurityLevelAIVI
   : public dia_SecurityLevel,
     public dia_IAIVISecurityListenerImpl
{

public:
   //! class constructor
   dia_SecurityLevelAIVI ( dia_SecurityLevelConfiguration& config );
   //! class destructor
   virtual ~dia_SecurityLevelAIVI ( void );

   //! method used to retrieve the seed value
   virtual tDiaResult getSeed ( void );
   //! method used to deliver a key
   virtual tDiaResult acceptKey ( std::vector<tU8>& keyValue );

   virtual void initialize ( void );

   //! called by the session control object to notify about a session change
   virtual void onSessionChange ( tU8 newSession, tU8 oldSession );

   virtual void vOnEcuSerialNumber ( const std::vector<tU8>& );
   virtual void vOnStaticKey ( const std::vector<tU8>& );

protected:

   //! generate the seed
   tDiaResult generateSeed ( void );

   //
   // FSM methods
   //
   virtual void vFsmEvaluateOperationMode ( void* /*pArg*/ );
   virtual void vFsmCalculateSeed ( void* pArg );
   virtual void vFsmSendSeed ( void* pArg );
   virtual bool isKeyInvalid ( void* pArg );
   virtual void vFsmValidateKey ( void* pArg );

protected:
   //! Current Session (Programming or Extended)
   tU8 mSessNum;

   //! vector to store the generated PUN (8 bytes)
   std::vector<tU8> mPUN;

   //! vector to store the SecuredSrvData
   std::vector<tU8> mSecuredSrvData;

   //! vector to store the SessionKey
   std::vector<tU8> mSessionKey;

   bool mbIsKeyInvalid;
};


#endif /* __INCLUDED_DIA_SECURITY_LEVEL_AIVI__ */
