/*
 * dia_CMCSecurityLevelDoip.cpp
 *
 *  Created on: Apr 17, 2019
 *      Author: mky6kor
 */
#ifndef __INCLUDED_DIA_CMC_SECURITY_LEVEL_DOIP__
#include "project/framework/security/dia_CMCSecurityLevelDoip.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL_AIVI__
#include "dia_SecurityLevelAIVI.h"
#endif

#ifndef __INCLUDED_DIA_RANDOM_GENERATOR__
#include "common/framework/utils/dia_RandomGenerator.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY__
#include "project/interfaces/dia_IAIVISecurity.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#include "bpcl.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SM
#include "trcGenProj/Header/dia_CMCSecurityLevelDoip.cpp.trc.h"
#endif


#include "common/depricated/dia_tclDiagSession.h"

#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_PUN_LEN 16
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECRET_SEED_LEN 16
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN 16
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SESSION_KEY_LEN 32
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_STATIC_KEY_LEN 16 //(AES 128)
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECRET_KEY_LEN 16
#define DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_TESTER_IDENTIFICATION_LEN 256


dia_CMCSecurityLevelDoip::dia_CMCSecurityLevelDoip(dia_SecurityLevelConfiguration& config)
	: dia_SecurityLevel(DIA_NAME_SECURITY_LEVEL_PROJECT_02, config),
	  mbIsKeyInvalid(true)
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::dia_CMCSecurityLevelDoip");
	mNeedToRunSeedKeyPolicy = true;
	mIsLevelUnderSessionControl = true;
}


dia_CMCSecurityLevelDoip::~dia_CMCSecurityLevelDoip()
{
	// TODO Auto-generated destructor stub
	DIA_TR_INF("dia_CMCSecurityLevelDoip::~dia_CMCSecurityLevelDoip()");
}

void
dia_CMCSecurityLevelDoip::initialize ( void )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::initialize");

   dia_SecurityLevel::initialize();

   (void) acceptEvent(dia_SecurityLevelFSM::evOperationModeUpdate, 0 );
}

//-----------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelDoip::getSeed ( void )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::getSeed");

   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("mStatus = 0x%x", mStatus);

   if (mStatus == DIA_EN_SECURITY_LEVEL_STATUS_ACTIVE)
   {
      std::vector<tU8> seedValue;
      for (unsigned i = 0; i < DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN; i++)
      {
         seedValue.push_back(0);
      }
      notifySeedResult(DIA_SUCCESS, seedValue);

      return DIA_SUCCESS;
   }
   acceptSeed();

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_CMCSecurityLevelDoip::vFsmCalculateSeed ( void* /*pArg*/ )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::vFsmCalculateSeed");

   tDiaResult retCode = generateSeed();

   if (retCode == DIA_SUCCESS)
   {

      retCode = DIA_FAILED;

         // Send internal request to get the StaticKey needed to encrypt the SecretSeed

         dia_IAIVISecurity* pInterface = OSAL_NULL;
         if ( (querySysAdapterInterface<dia_IAIVISecurity>(&pInterface) == DIA_SUCCESS) && pInterface )
         {
            (void) setSysAdapterListener<dia_IAIVISecurityListener>(this);

            if (pInterface->getStaticKey4CMCSecLevDoip() == DIA_SUCCESS)
            {
               retCode = DIA_SUCCESS;
            }
         }

         if (retCode != DIA_SUCCESS)
         {
            DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vFsmCalculateSeed: FAILED to get StaticKey");
         }
   }
   else
   {
      DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vFsmCalculateSeed: generateSeed FAILED");
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelDoip::generateSeed ( void )
{
   dia_tclFnctTrace oTrace("dia_CMCSecurityLevelDoip::generateSeed");

   tDiaResult retCode = DIA_FAILED;

   // initialize the seed attribute
   initializeSeed();

   // STD-SEC-TS.0200(1): When a SecuritySeed is requested to the UDS_Server, it generates and store a eight bytes PUN into its own memory.

   dia_RandomGenerator* pRandomGenerator = getInstanceOfRandomGenerator();
   if ( pRandomGenerator == NULL )
   {
      DIA_TR_ERR("### FAILED TO GET INSTANCE OF RANDOM GENERATOR ###");
      return retCode;
   }

   tU32 random1  = pRandomGenerator->getRandomNumber();
   OSAL_s32ThreadWait(random1 >> 24);
   tU32 random2  = pRandomGenerator->getRandomNumber();
   OSAL_s32ThreadWait(random2 >> 24);
   tU32 random3  = pRandomGenerator->getRandomNumber();
   OSAL_s32ThreadWait(random3 >> 24);
   tU32 random4  = pRandomGenerator->getRandomNumber();

   DIA_TR_INF("--- dia_CMCSecurityLevelDoip::generateSeed: rng1=0x%08x rng2=0x%08x rng3=0x%08x rng4=0x%08x", random1, random2, random3, random4);

   mPUN.clear();

   mPUN.push_back((tU8) (random1 >> 24));
   mPUN.push_back((tU8) (random1 >> 16));
   mPUN.push_back((tU8) (random1 >> 8));
   mPUN.push_back((tU8) random1);
   mPUN.push_back((tU8) (random2 >> 24));
   mPUN.push_back((tU8) (random2 >> 16));
   mPUN.push_back((tU8) (random2 >> 8));
   mPUN.push_back((tU8) random2);
   mPUN.push_back((tU8) (random3 >> 24));
   mPUN.push_back((tU8) (random3 >> 16));
   mPUN.push_back((tU8) (random3 >> 8));
   mPUN.push_back((tU8) random3);
   mPUN.push_back((tU8) (random4 >> 24));
   mPUN.push_back((tU8) (random4 >> 16));
   mPUN.push_back((tU8) (random4 >> 8));
   mPUN.push_back((tU8) random4);

   mSeed = mPUN;
   if (mSeed.size() == DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECRET_SEED_LEN)
   {
      mIsSeedValid = TRUE;
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("### INVALID SEED LENGTH GENERATED ###");
   }

   return retCode;
}

//-----------------------------------------------------------------------------


bool
dia_CMCSecurityLevelDoip::isKeyInvalid ( void* pArg )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::isKeyInvalid");

   return mbIsKeyInvalid;
}

//------------------------------------------------------------------------------

void
dia_CMCSecurityLevelDoip::vOnStaticKey ( const std::vector<tU8>& staticKey )
{
   dia_tclFnctTrace oTrace("dia_CMCSecurityLevelDoip::vOnStaticKey");

   (void) unsetSysAdapterListener<dia_IAIVISecurityListener>(this);

   ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vOnStaticKey: StaticKey Length: %d Data: %02x", staticKey.size(),
         ETG_LIST_LEN(staticKey.size()), ETG_LIST_PTR_T8(staticKey.data())));

   //Clearing the vectors
   mSecuredSrvData.clear();
   mSessionKey.clear();

   if (staticKey.size() == DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_STATIC_KEY_LEN)
   {
      //STD-SEC-TS.0202(1): The SecuritySeed is an encryption of SecretSeed. This encryption algorithm is Encrypt StaticKey

      ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vOnStaticKey: SecretSeed Length: %d Data: %02x",
            mSeed.size(), ETG_LIST_LEN(mSeed.size()), ETG_LIST_PTR_T8(mSeed.data())));

      tU8 aSecuritySeed[DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN];
      tU8* iv = 0;
      if (BPCL_OK == BPCL_AES_Encrypt(BPCL_AES_MODE_CBC, BPCL_AES_OP_ARGKEY, BPCL_AES_KEYSIZE_128,
                      (tU8*) staticKey.data(), 0, iv, mSeed.data(), aSecuritySeed, mSeed.size()))

      {
         for (int i = 0; i < DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN; i++)
         {
        	 mSessionKey.push_back(aSecuritySeed[i]);
        	 mSecuredSrvData.push_back(aSecuritySeed[i]);
         }
         //Clearing the array
         memset(aSecuritySeed,0,sizeof(aSecuritySeed));

         ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vOnStaticKey: SecuritySeed for mSeed Length: %d Data: %02x",
        		 DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN, ETG_LIST_LEN(mSecuredSrvData.size()), ETG_LIST_PTR_T8(mSecuredSrvData.data())));

         if (BPCL_OK == BPCL_AES_Encrypt(BPCL_AES_MODE_CBC, BPCL_AES_OP_ARGKEY, BPCL_AES_KEYSIZE_128,
                               (tU8*) staticKey.data(), 0, iv, mSecuredSrvData.data(), aSecuritySeed, mSecuredSrvData.size()))
         {
        	for (int i = 0; i < DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN; i++) mSessionKey.push_back(aSecuritySeed[i]);

            ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vOnStaticKey: SecuritySeed for Secured Data  Length: %d Data: %02x",
            		DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SECURITY_SEED_LEN, ETG_LIST_LEN(sizeof(aSecuritySeed)), ETG_LIST_PTR_T8(aSecuritySeed)));


            ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vOnStaticKey: Session Key (encrypted) Length: %d Data: %02x",
                        		mSessionKey.size(), ETG_LIST_LEN(mSessionKey.size()), ETG_LIST_PTR_T8(mSessionKey.data())));

            //Send the SecuritySeed
            (void) acceptEvent(dia_SecurityLevelFSM::evOnSeedAvailable,0);
         }
         else
         {
            DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vOnStaticKey: BPCL_AES_Encrypt FAILED for Secured Data");
         }
      }
      else
      {
         DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vOnStaticKey: BPCL_AES_Encrypt FAILED for Seed");
      }
   }
   else
   {
      DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vOnStaticKey: incorrect StaticKey length=%d", staticKey.size());
   }

}

//-----------------------------------------------------------------------------
void
dia_CMCSecurityLevelDoip::acceptSeed ( void )
{
   dia_tclFnctTrace oTrace("dia_CMCSecurityLevelDoip::acceptSeed");
   (void) acceptEvent(dia_SecurityLevelFSM::evSeedRequested, 0 );
}

//-----------------------------------------------------------------------------
void
dia_CMCSecurityLevelDoip::vFsmSendSeed ( void* /*pArg*/ )
{
	 dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::vFsmSendSeed");
	  notifySeedResult(DIA_SUCCESS, mSeed);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelDoip::acceptKey ( std::vector<tU8>& keyValue )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::acceptKey");

   mErrorCode = DIA_E_NOERROR;

   if (!(keyValue.size()))
   {
      DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::acceptKey FAILED with invalid key size = %d", keyValue.size());
      mErrorCode = DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   }
   else
   {
      if ((mPUN.size() == DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_PUN_LEN) && (mSessionKey.size() == DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SESSION_KEY_LEN))
      {
         ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::acceptKey: SecurityKey Length: %d Data: %02x",
               keyValue.size(), ETG_LIST_LEN(keyValue.size()), ETG_LIST_PTR_T8(keyValue.data())));

         (void) acceptEvent(dia_SecurityLevelFSM::evKeyReceived, (tVoid*) &keyValue);
      }
      else
      {
         mErrorCode = DIA_FAILED;
      }
   }

   return mErrorCode;
}

//------------------------------------------------------------------------------

void
dia_CMCSecurityLevelDoip::vFsmValidateKey ( void* pArg )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelDoip::vFsmValidateKey");

   mbIsKeyInvalid = true;

   if ( pArg != NULL )
   {
      std::vector<tU8>* pSecurityKey = (std::vector<tU8>*) pArg;
      std::vector<tU8>& pSecurityKeyRef=*pSecurityKey;

         mbIsKeyInvalid = false;
         int i;
         for (i = 0; i < mSessionKey.size(); i++)
         {
            if (mSessionKey[i] != pSecurityKeyRef[i])
            {
               DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vFsmValidateKey: FAILED to compare with Session key at %d (0x%02x != 0x%02x)",
                     i, mSessionKey[i], pSecurityKeyRef[i]);
               mbIsKeyInvalid = true;
               break;
            }
         }
         if(mbIsKeyInvalid == false)
         {
        	 std::vector<tU8> testerIdentification;
        	 testerIdentification.clear();
        	 for(int j = DIA_C_U16_CMC_SECURITY_LEVEL_DOIP_SESSION_KEY_LEN; j < pSecurityKeyRef.size(); j++)
        	 {
        		 testerIdentification.push_back(pSecurityKeyRef[j]);
        	 }

        	 ETG_TRACE_COMP(("--- dia_CMCSecurityLevelDoip::vFsmValidateKey: Tester Identification Length: %d Data: %02x",
        	    testerIdentification.size(), ETG_LIST_LEN(testerIdentification.size()), ETG_LIST_PTR_T8(testerIdentification.data())));
        	 tU32 propLength = testerIdentification.size();
        	 tU8 u8propData[propLength] = {0};
        	 (void) ::memset(u8propData,0,propLength);

        	 for(int i=0; i<testerIdentification.size(); i++)
        	 {
        		 u8propData[i]=testerIdentification[i];
        	 }
        	 tDiaResult retCode = dia_setProperty(DIA_PROP_CENTER_CMC_19_SECURITY_TESTER_IDENTIFICATION,u8propData,testerIdentification.size());

        	 if (retCode != DIA_SUCCESS)
        	 {
        	    DIA_TR_ERR("!!! dia_CMCSecurityLevelDoip::vFsmValidateKey: Storing of Tester Identification FAILED");
        	 }
         }

   } //if ( pArg != NULL )

   if ( mbIsKeyInvalid == true )
   {
      DIA_TR_ERR("##### INVALID SECURITY KEY RECEIVED #####");
   }

   acceptEvent(dia_SecurityLevelFSM::evOnKeyValidationDone,0);
}

//-----------------------------------------------------------------------------
