/*
 * dia_CMCSecurityLevelCISInstallationContainer.h
 *
 *  Created on: jan 22, 2020
 *      Author: urm7kor
 */


#ifndef __INCLUDED_DIA_CMC_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER__
#define __INCLUDED_DIA_CMC_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY_LEVEL__
#include "common/framework/security/dia_SecurityLevel.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

class dia_CMCSecurityLevelCISInstallationContainer
   : public dia_SecurityLevel
     {
public:
	   //! class constructor
	   dia_CMCSecurityLevelCISInstallationContainer(dia_SecurityLevelConfiguration& config);

	   //! class destructor
	   virtual ~dia_CMCSecurityLevelCISInstallationContainer(void);

	   //! method used to retrieve the seed value
	   virtual tDiaResult getSeed ( void );

	   //! method used to deliver a key
	   virtual tDiaResult acceptKey ( std::vector<tU8>& keyValue );

	   //! initialize the state machine(fsm)
	   virtual void initialize ( void );

	   //!Receives the generated seed
	   virtual void acceptSeed ( void);

	   //!Retrieves the static key needed to encrypt the Secret seed
	   virtual void vOnStaticKey ( const std::vector<tU8>& );

protected:

	   //! generate the seed
	   tDiaResult generateSeed ( void );

	   //
	   // FSM methods
	   //!Request to get the StaticKey needed to encrypt the SecretSeed
	   virtual void vFsmCalculateSeed ( void* pArg );

	   //!forwards the secret seed to notify the seed result
	   virtual void vFsmSendSeed ( void* pArg );

	   //!checks the status of the key
	   virtual bool isKeyInvalid ( void* pArg );

	   //!checks the validity of the key(calculated key and send key by tester )
	   virtual void vFsmValidateKey ( void* pArg );


protected:

	   //! vector to store the generated PUN (16 bytes)
	   std::vector<tU8> mPUN;
	   std::vector<tU8> mSessionKey;
	   bool mbIsKeyInvalid;

};

#endif /* __INCLUDED_DIA_CMC_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER__ */
