/*
 * dia_RequestDownloadHandlerAIVI.h
 *
 *  Created on: Dec 15, 2016
 *      Author: kaa1hi
 */


#ifndef __INCLUDED_DIA_REQ_DNL_AIVI_HANDLER__
#define __INCLUDED_DIA_REQ_DNL_AIVI_HANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class dia_MessageBuffer;

class dia_RequestDownloadHandlerAIVI
   : public dia_MessageHandler,
     public dia_IErrorLogListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RequestDownloadHandlerAIVI);//coverity fix:70914,70908
public:
   //! class constructor
   dia_RequestDownloadHandlerAIVI ( void );

   //! class constructor with next handler passed
   dia_RequestDownloadHandlerAIVI ( dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~dia_RequestDownloadHandlerAIVI ( void );

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );

   //! send request to DiagLog to get DTC status (must be called from save thread).
   void getStatusDTC(const tU32 u32DTCMask);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IErrorLogListenerImpl methods
   //
   //-------------------------------------------------------------------------

   //! deliver response for getStatusByDTC (evaluate of DTC status, set property of DTC status, forward mpActiveMessageBuffer - DownloadRequest to UDS engine)
   virtual void vOnReadStatusByDTCResult ( const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList );

protected:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

protected:
   //!
   bool mIsSetupDone;

   //! internal
   //tDiaResult mErrorCode;
   //! active diagnosis request
   dia_MessageBuffer* mpActiveMessageBuffer;

   //mapping of logical address from RequestDownload to DTC Group
   std::map<tU32, tU16> mLogicAddrToDtcGroupRepo;

   //mapping of DTC FTB Programming to Property ID.
   std::map<tU32, tU32> mDtcProgrammingToPropertyIDRepo;

   tU32 mLastDTCNumber;
};

#endif /* __INCLUDED_DIA_REQ_DNL_AIVI_HANDLER__ */
