/**
 * \file      dia_PredicateProgrammingSession.h
 *
 * \brief     Predicate implementation to not execute a test in case of Programming Session.
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Jan 06, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2017
 */


#ifndef __INCLUDED_DIA_PREDICATE_PROGRAMMING_SERVICE__
#define __INCLUDED_DIA_PREDICATE_PROGRAMMING_SERVICE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE__
#include "common/framework/application/dia_Predicate.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include "common/interfaces/dia_ISessionListener.h"
#endif

#define DIA_PRED_PROGRAMMING_SESSION   "DIA_PREDICATE_CLASS_PROGRAMMING_SESSION"

//-----------------------------------------------------------------------------

class dia_PredicateProgrammingSession
   : public dia_Predicate,
     public dia_ISessionListenerImpl
{
   DIA_DECL_PREDICATE_CLASS(DIA_PRED_PROGRAMMING_SESSION);

public:
   dia_PredicateProgrammingSession ( void );

   //! observer pattern
   virtual void update ( const std::vector<tU32>& args );
   //! prototype pattern
   virtual dia_Predicate* clone (void );

protected:
   //! copy constructor
   dia_PredicateProgrammingSession ( const dia_PredicateProgrammingSession& obj );
   //! assignment operator
   dia_PredicateProgrammingSession& operator = ( const dia_PredicateProgrammingSession& obj );
    //! destructor
   virtual ~dia_PredicateProgrammingSession ( void );

protected:
   //! check if the predicate is matched (always match, because this functionality is not used here).
   virtual tDiaResult match ( void ) { mIsMatched = TRUE; return DIA_SUCCESS; }
   //! check preconditions (return true if preconditions are fulfilled)
   virtual bool checkPreConditions(void);

protected:
   bool mPreCondition;

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISessionListenerImpl methods
   //
   //-------------------------------------------------------------------------
   virtual void vOnSessionChanged ( tU8 newSession, tU8 /*oldSession*/ );
};

#endif /* __INCLUDED_DIA_PREDICATE_PROGRAMMING_SERVICE__ */
