/**
 * \file      dia_PredicateProgrammingSession.cpp
 *
 * \brief     Predicate implementation to not execute a test in case of Programming Session.
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Jan 06, 2017
 *
 * \copyright Robert Bosch Car Multimedia 2017
 */

#ifndef __INCLUDED_DIA_PREDICATE_PROGRAMMING_SERVICE__
#include "project/framework/platform/session/dia_PredicateProgrammingSession.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

//-----------------------------------------------------------------------------
//CID - 117822 and 71139 Fix
dia_PredicateProgrammingSession::dia_PredicateProgrammingSession ( void )
   : dia_Predicate(dia_PredicateProgrammingSession::getClassIdentifier()/*cid*/,dia_getHashCodeFromString(dia_composeStlString("%s_0x%02X",dia_PredicateProgrammingSession::getClassName(),(int) DIA_C_U8_UDS_SESSION_PROGRAMMING) /*uid*/)),
     mPreCondition(true /*there is default session after reset*/)
{
   dia_tclFnctTrace trc("dia_PredicateProgrammingSession::dia_PredicateProgrammingSession(void)");

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->addListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_PredicateProgrammingSession::dia_PredicateProgrammingSession => ERROR: Unable to register for Session changes");
   }
}

//-----------------------------------------------------------------------------

dia_PredicateProgrammingSession::dia_PredicateProgrammingSession ( const dia_PredicateProgrammingSession& obj )
   : dia_Predicate(obj),
     mPreCondition(obj.mPreCondition)
{
   dia_tclFnctTrace trc("dia_PredicateProgrammingSession::dia_PredicateProgrammingSession(const dia_PredicateProgrammingSession& obj)");

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->addListener(this);
   }
   else
   {
      DIA_TR_ERR("!!! dia_PredicateProgrammingSession::dia_PredicateProgrammingSession => ERROR: Unable to register for Session changes");
   }
}

//-----------------------------------------------------------------------------

dia_PredicateProgrammingSession&
dia_PredicateProgrammingSession::operator = ( const dia_PredicateProgrammingSession& obj )
{
   if ( this != &obj )
   {
      mUID           = obj.mUID;
      mClassID       = obj.mClassID;
      mIsMatched     = obj.mIsMatched;
      mPreCondition  = obj.mPreCondition;
   }
   return *this;
}

//-----------------------------------------------------------------------------

dia_PredicateProgrammingSession::~dia_PredicateProgrammingSession ( void )
{
   DIA_TR_INF("dia_PredicateProgrammingSession::~dia_PredicateProgrammingSession(void)");
   //Coverity Fix:180715
   _BP_TRY_BEGIN
   {
	   dia_EngineServer* pEngine = 0;
	   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
	   {
		   pEngine->getSessionController()->removeListener(this);
	   }
   }
   _BP_CATCH_ALL
   {
	  //DIA_TR_INF("EXCEPTION CAUGHT: dia_PredicateProgrammingSession::~dia_PredicateProgrammingSession !!!");
      //DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

bool
dia_PredicateProgrammingSession::checkPreConditions ( void )
{
   dia_tclFnctTrace trc("dia_PredicateProgrammingSession::checkPreConditions");

   DIA_TR_INF("dia_PredicateProgrammingSession::checkPreConditions returned %s.", ( mPreCondition ) ? "TRUE" : "FALSE");

   return mPreCondition;
}

dia_Predicate*
dia_PredicateProgrammingSession::clone (void )
{
   return OSAL_NEW dia_PredicateProgrammingSession(*this);
}

void
dia_PredicateProgrammingSession::update ( const std::vector<tU32>& args )
{
   /* This is empty method, because there is no need to send a message to this predicate object.
    * Notification about a new session will be delivered to vOnSessionChanged. */
}

//------------------------------------------------------------------------------

void
dia_PredicateProgrammingSession::vOnSessionChanged ( tU8 newSession, tU8 /*oldSession*/ )
{
   dia_tclFnctTrace oTrace("dia_PredicateProgrammingSession::vOnSessionChanged");

   mPreCondition = ( DIA_C_U8_UDS_SESSION_PROGRAMMING == newSession) ? false : true;

   DIA_TR_INF("### PROGRAMMING SESSION IS %s ###", ( DIA_C_U8_UDS_SESSION_PROGRAMMING == newSession ) ? "ACTIVE" : "INACTIVE");
}
