/*
 * dia_ASFComponentSystemSettingsPrj.cpp
 *
 *  Created on: 03.07.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_CONFIGURATION__
#include <common/framework/sysset/dia_SystemSettingsConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#include <common/framework/sysadapters/dia_SAFeatureSystemSettingsASF.h>

#include "dia_ASFComponentSystemSettingsPrj.h"

static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASF[] =
{
    //  { "diagSystemSettingProfileMngrPort", "DIA_SrvSysSetASF_ProfMngr", "DIA_SAFeatureSystemSettingASF_ProfileMngr", "DIA_SYSSET_ID_PROFILEMNGR", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },//Center CM-C 19:Component disabled for Project specific requirements.
      { "diagsystemSettingHMIAppMasterPort", "DIA_SrvSysSetASF_HmiMaster", "DIA_SAFeatureSystemSettingASF_HmiMaster", "DIA_SYSSET_ID_HMI_MASTER", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
    //  { "diagsystemSettingHMIAppHomeScreenPort", "DIA_SrvSysSetASF_HmiHome", "DIA_SAFeatureSystemSettingASF_HmiHome", "DIA_SYSSET_ID_HMI_HOMESCREEN", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },//Center CM-C 19:Component disabled for Project specific requirements.
      { "diagsystemSettingHMIAppPhonePort", "DIA_SrvSysSetASF_HmiPhone", "DIA_SAFeatureSystemSettingASF_HmiPhone", "DIA_SYSSET_ID_HMI_PHONE", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
      { "diagsystemSettingHMIAppSystemPort", "DIA_SrvSysSetASF_HmiSys", "DIA_SAFeatureSystemSettingASF_HmiSystem", "DIA_SYSSET_ID_HMI_SYSTEM", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
     // { "diagsystemSettingHMIAppTelematicsPort", "DIA_SrvSysSetASF_HmiTel", "DIA_SAFeatureSystemSettingASF_HmiTelem", "DIA_SYSSET_ID_HMI_TELEMATICS", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },//Center CM-C 19:Component disabled for Project specific requirements.
      { "diagsystemSettingHMIAppMediaPort", "DIA_SrvSysSetASF_HmiMedia", "DIA_SAFeatureSystemSettingASF_HmiMedia", "DIA_SYSSET_ID_HMI_MEDIA", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
     // { "diagsystemSettingHMIAppVehiclePort", "DIA_SrvSysSetASF_HmiVeh", "DIA_SAFeatureSystemSettingASF_HmiVehicle", "DIA_SYSSET_ID_HMI_VEHICLE", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },//Center CM-C 19:Component disabled for Project specific requirements.
      { "diagsystemSettingSWUpdatePort", "DIA_SrvSysSetASF_SwUpd", "DIA_SAFeatureSystemSettingASF_SwUpdate", "DIA_SYSSET_ID_SWUPDATE", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION, 0 },
     // { "diagsystemSettingHMIAppTestmodePort", "DIA_SrvSysSetASF_HmiTM", "DIA_SAFeatureSystemSettingASF_HmiTestm", "DIA_SYSSET_ID_HMI_TESTMODE", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
      { "diagsystemSettingHMIAppTunerPort", "DIA_SrvSysSetASF_HmiTuner", "DIA_SAFeatureSystemSettingASF_HmiTuner", "DIA_SYSSET_ID_HMI_TUNER", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },
 //     { "diagsystemSettingPmAppPort", "DIA_SysSetASF_PmApp", "DIA_SAFeatureSystemSettingASF_PmApp", "DIA_SYSSET_ID_PmApp", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CUSTOMER, 0 },
	//  { "diasystemSettingCfgmgrPort", "DIA_SrvSysSetASF_CfgMgr", "DIA_SAFeatureSystemSettingASF_CfgMgr", "DIA_SYSSET_ID_CFGMGR", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION, 0 }//Center CM-C 19:Component disabled for Project specific requirements.
};

static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASFNavi[] =
{
      { "diagsystemSettingHMIAppNavigationPort", "DIA_SrvSysSetASF_HmiNav", "DIA_SAFeatureSystemSettingASF_HmiNavi", "DIA_SYSSET_ID_HMI_NAVIGATION", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0}
};

static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASFSds[] =
{
      { "diagsystemSettingHMIAppSdsPort", "DIA_SrvSysSetASF_HmiSds", "DIA_SAFeatureSystemSettingASF_HmiSds", "DIA_SYSSET_ID_HMI_SDS", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 }
};

static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASFManagedApps[] =
{
      { "diagSystemSettingGatewayPort", "DIA_SrvSysSetASF_Gateway", "DIA_SAFeatureSystemSettingASF_Gateway", "DIA_SYSSET_ID_GenericGateway", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 }
};

#ifdef VARIANT_S_FTR_ENABLE_RIVIE
static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASFSuggestionManager[] =
{
     // { "diagSystemSettingSuggestionManagerServerPort", "DIA_SrvSysSetASF_SuggServ", "DIA_SAFeatureSystemSettingASF_SuggServ", "DIA_SYSSET_ID_SUGGESTIONMNGR_SERVER", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 },//Center CM-C 19:Component disabled for Project specific requirements.
//      { "diagSystemSettingSuggestionManagerClientMQTTPort", "DIA_SrvSysSetASF_SuggClMQTT", "DIA_SAFeatureSystemSettingASF_SuggClMQTT", "DIA_SYSSET_ID_SUGGESTIONMNGR_CLIENT_MQTT", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 }
};
#endif

#define VARIANT_CODING_PROP_LEN 32
#define TUNER_BITS ((tU8)0x30)
#define TUNER_XM  ((tU8)0x10)
#define TUNER_DAB ((tU8)0x20)
#define VR_BYTE   (25)
#define VR_BITS   ((tU8)0x03)
#define TTS_BIT   (4)
#define AllianceVoiceRecognitionModeTypePresent  ((tU8)0x02)

static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASFSxm[] =
{
      { "diagsystemSettingHMIAppSxmPort", "DIA_SrvSysSetASF_HmiSxm", "DIA_SAFeatureSystemSettingASF_HmiSxm", "DIA_SYSSET_ID_HMI_SXM", DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION|DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT, 0 }
};

//------------------------------------------------------------------------------

namespace asf {

class dia_SystemAdapterServicePluginSystemSettingsASF : public dia_SystemAdapterServicePluginASF< SystemSettings1Proxy >
{
public:

   //! default constructor
   dia_SystemAdapterServicePluginSystemSettingsASF ( tCString name, const boost::shared_ptr<SystemSettings1Proxy>& proxy, const std::shared_ptr<dia_SystemAdapterASF>& adapter )
      : dia_SystemAdapterServicePluginASF(name, proxy, adapter)
   {}

   //! class destructor
   virtual ~dia_SystemAdapterServicePluginSystemSettingsASF ( void )
   {}

   //! ServiceAvailableIF implementation
   virtual void onAvailable ( const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange );
   virtual void onUnavailable ( const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange );
};

//------------------------------------------------------------------------------

void
dia_SystemAdapterServicePluginSystemSettingsASF::onAvailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if (proxy == mProxy)
   {
      switch (stateChange.getCurrentState())
      {
         case ServiceState__Available:
            {
               mCondVar.signal(DIA_C_CONDVAR_EVENT_01,TRUE);
               mIsAvailable = true;
            }
            break;

         default:
            break;
      }
   }
}

//----------------------------------------------------------------------------------------

void
dia_SystemAdapterServicePluginSystemSettingsASF::onUnavailable(const ::boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if (proxy == mProxy)
   {
      switch (stateChange.getCurrentState())
      {
         case ServiceState__Disconnected:
         case ServiceState__Suspended:
            {
               mCondVar.signal(DIA_C_CONDVAR_EVENT_01,FALSE);
               mIsAvailable = false;
            }
            break;

         default:
            break;
      }
   }
}

//------------------------------------------------------------------------------

dia_ASFComponentSystemSettingsPrj::dia_ASFComponentSystemSettingsPrj ( void )
{
   dia_tclFnctTrace trc("dia_ASFComponentSystemSettingsPrj::dia_ASFComponentSystemSettingsPrj");

   for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASF)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
   {
      mConfig.push_back(&arSystemSettingsConfigurationASF[i]);
   }

   // Try to load additional ASF SystemSetting Modules depending on the A-IVI Variant
   tU8 aiviVariantCoding[DIA_AIVI_VARIANT_CODING_LENGTH] = { 0 };
   tDiaResult getPropRes = dia_getProperty(DIA_PROP_AIVI_VARIANT_CODING, aiviVariantCoding, DIA_AIVI_VARIANT_CODING_LENGTH);
   if (getPropRes != DIA_SUCCESS)
   {
      DIA_TR_ERR("##### FAILED TO GET PROPERTY FOR A-IVI VARIANTS #####");
   }
   else
   {
      tU8 currentVariantType = (aiviVariantCoding[0] & 0x0F);
      switch (currentVariantType)
      {
         case 2: //DA
            break;
         default: //Navi or not configured
            for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASFNavi)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
            {
               mConfig.push_back(&arSystemSettingsConfigurationASFNavi[i]);
            }
            break;
      }

      bool bManagedApps = ((aiviVariantCoding[7] & 0x01) == 0x01)? true: false;
      if (bManagedApps)
      {
         for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASFManagedApps)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
         {
            mConfig.push_back(&arSystemSettingsConfigurationASFManagedApps[i]);
         }
      }
   }

   // Try to load additional ASF SystemSetting Modules depending on the CM Variant
   tU8 cmVariantCoding[VARIANT_CODING_PROP_LEN] = { 0 };
   getPropRes = dia_getProperty(DIA_PROP_CM_VARIANT_CODING, cmVariantCoding, VARIANT_CODING_PROP_LEN);
   if (getPropRes != DIA_SUCCESS)
   {
      DIA_TR_ERR("##### FAILED TO GET PROPERTY FOR CM VARIANTS #####");
   }
   else
   {
      tU8 hw_type = cmVariantCoding[4] & TUNER_BITS;
      switch(hw_type)
      {
         case TUNER_XM:
           /* Disabled the SXM module since the Component is not available */
            for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASFSxm)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
           {
             mConfig.push_back(&arSystemSettingsConfigurationASFSxm[i]);
           }
            break;
#if 0 //No separate HMI App for DAB
         case TUNER_DAB:
            break;
#endif
         default:
            break;
      }
   }

   // Try to load additional ASF SystemSetting Modules depending on "System Information Common"
   tU8 systemInfoCommon[64] = { 0 };
   getPropRes = dia_getProperty(DIA_PROP_AIVI_SYSTEM_INFO_COMMON, systemInfoCommon, sizeof(systemInfoCommon));
   if (getPropRes != DIA_SUCCESS)
   {
      DIA_TR_ERR("##### FAILED TO GET PROPERTY 'System Info Common' #####");
   }
   else
   {
      tU8 voiceRecognition = systemInfoCommon[VR_BYTE] & VR_BITS;
      bool bTTS = ((systemInfoCommon[VR_BYTE] & (1 << TTS_BIT)) == (1 << TTS_BIT))? true: false;

      DIA_TR_INF("dia_ASFComponentSystemSettingsPrj: VR = %d, TTS = %d", voiceRecognition, bTTS);

      if ((voiceRecognition == AllianceVoiceRecognitionModeTypePresent) || bTTS)
      {
         for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASFSds)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
         {
            mConfig.push_back(&arSystemSettingsConfigurationASFSds[i]);
         }
      }
   }
//Center CM-C 19:Below macro has been disabled in ai_diagnosis_project_prod.xml as per the Project specific requirements
#ifdef __ENABLE_FEATURE_SYSSET_INCLUDE_SUGGESTION_MANAGER__
   for (tU32 i = 0; i < (sizeof(arSystemSettingsConfigurationASFSuggestionManager)/sizeof(dia_SystemSettingsConfigurationASF)); i++)
   {
      mConfig.push_back(&arSystemSettingsConfigurationASFSuggestionManager[i]);
   }
#endif

   if (mConfig.size())
   {
      //
      // System Adapter object
      //
      //dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	   std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter (createSystemAdapter());

      //
      // create service plugin and feature for each connection
      //

      std::list<const dia_SystemSettingsConfigurationASF*>::const_iterator cfgIter = mConfig.begin();
      for ( ; cfgIter != mConfig.end(); cfgIter++ )
      {
         const dia_SystemSettingsConfigurationASF* pConfigItem = *cfgIter;

         // create proxy object
         ::boost::shared_ptr<SystemSettings1Proxy> proxy = SystemSettings1Proxy::createProxy (
               pConfigItem->mPortName.c_str(), *pSystemAdapter);

         // create service plugin
         dia_SystemAdapterServicePluginSystemSettingsASF* pSASystemSettingService1 = new dia_SystemAdapterServicePluginSystemSettingsASF(
               pConfigItem->mSAServicePluginName.c_str(), proxy, pSystemAdapter);

         if ( pSASystemSettingService1 && (pSystemAdapter->addServicePlugin(proxy, *pSASystemSettingService1) == DIA_SUCCESS))
         {
            dia_SAFeatureSystemSettingsASF* pSAFeatureSystemSetting1 = new dia_SAFeatureSystemSettingsASF (
                  pConfigItem->mSAFeatureName.c_str(),
                  pConfigItem->mSystemSettingID.c_str(),
                  pConfigItem->mSystemSettingTypeMask,
                  *pSASystemSettingService1
            );

            if ( pSAFeatureSystemSetting1 && (pSASystemSettingService1->addFeature(*pSAFeatureSystemSetting1) == DIA_SUCCESS))
            {
               if ( getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSystemSetting1) != DIA_SUCCESS )
               {
                  DIA_TR_ERR("!!! Error: Failed to add module \"%s\" to system settings manager",pSAFeatureSystemSetting1->getName());
               }

               // store pointer of created object in repository to delete it on system shutdown
               mModuleRep.push_back(pSAFeatureSystemSetting1);
            }
         } //lint !e429: custodial pointer is freed when the list is full or by destroy function
      }
   }
   else
   {
      DIA_TR_ERR("!!! Error: ASF System Settings configuration is empty !!");
   }
}

//------------------------------------------------------------------------------

dia_ASFComponentSystemSettingsPrj::~dia_ASFComponentSystemSettingsPrj()
{
}

} //namespace asf

