/*!
 * \file       dia_ASFComponentSubsystemDiagnosisServer.cpp
 *
 * \brief      ASF Component to implement the Subsystem Diagnosis Stub.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponent
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_SERVER__
#include "dia_ASFComponentSubsystemDiagnosisServer.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include <string.h>
#include <cstdarg>
#include <cerrno>
#include <ifaddrs.h>
#include <arpa/inet.h>
#include <linux/if_packet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
//#include <libexplain/setsockopt.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fstream>     //lint !e537 : repeatedly included header file without standard include guard
#include <stdlib.h>    //lint !e537 !e451 : repeatedly included header file without standard include guard
#include <sys/wait.h>


static const std::string AVDECC_FILES_DELETE_PATH("/var/opt/bosch/persistent/avdecc/");

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentSubsystemDiagnosisServer::dia_ASFComponentSubsystemDiagnosisServer ( void )
   : SubsystemDiagnosisStub("SubsystemDiagnosisServerPort"),
	 poNode(NULL),
     DoIP_Tester(DIA_S_SUBSYSTEM_DOIP_CLIENT_ETH_NAME, DIA_C_SUBSYSTEM_DOIP_CLIENT_PORT_NUMBER, DIA_C_SUBSYSTEM_DOIP_CLIENT_TESTER_ADDR, cfg)
{
   et_vTraceOpen();
   
   dia::ScopeTrace trc("dia_ASFComponentSubsystemDiagnosisServer::dia_ASFComponentSubsystemDiagnosisServer");
   /*
   oIEDelayTimer.s32Create();
	mIEDelayTimerID = oIEDelayTimer.getID();*/
}

//------------------------------------------------------------------------------

dia_ASFComponentSubsystemDiagnosisServer::~dia_ASFComponentSubsystemDiagnosisServer()
{
	/*oIEDelayTimer.removeTimerListener(this);
	oIEDelayTimer.s32Delete();
	mIEDelayTimerID = 0xFFFFFFFF; */

	delete poNode;
	poNode = NULL;
}

//------------------------------------------------------------------------------

void
dia_ASFComponentSubsystemDiagnosisServer::onStartUDPBroadcastClientRequest (const ::boost::shared_ptr< StartUDPBroadcastClientRequest >& request)
{
   dia::ScopeTrace trc("dia_ASFComponentSubsystemDiagnosisServer::onStartUDPBroadcastClientRequest");
	tDiaResult result = DIA_FAILED;
	result = Start();
   sendStartUDPBroadcastClientResponse((result == DIA_SUCCESS)? 0: 1);
}

void
dia_ASFComponentSubsystemDiagnosisServer::onDiscoverEntitiesRequest (const ::boost::shared_ptr< DiscoverEntitiesRequest >& request)
{
	dia::ScopeTrace trc("dia_ASFComponentSubsystemDiagnosisServer::onDiscoverEntitiesRequest");
	//::std::vector< DiscoverEntitiesResponseNodeListStruct > nodeList;
	/*
	oIEDelayTimer.addTimerListener(this);
	oIEDelayTimer.s32SetTime(0,0);
	oIEDelayTimer.s32SetTime(2000, 0);
*/
	nodeList.clear();
	vdiscoverEntities();
	//sendDiscoverEntitiesResponse(((result == DIA_SUCCESS)? 0: 1), nodeList);
}

void
dia_ASFComponentSubsystemDiagnosisServer::onDiscoverEntitiesResultsRequest (const ::boost::shared_ptr< DiscoverEntitiesResultsRequest >& /* request */)
{
	dia_tclFnctTrace oTrace("dia_ASFComponentSubsystemDiagnosisServer::onDiscoverEntitiesResultsRequest(...)");
	tDiaResult result = DIA_SUCCESS;
	//sendDiscoverEntitiesResultsResponse(((result == DIA_SUCCESS)? 0: 1), nodeList); 
	//Stop();
	sendDiscoverEntitiesResultsResponse( 0, nodeList);
}

void
dia_ASFComponentSubsystemDiagnosisServer::onAvdeccFilesDeleteRequest (const ::boost::shared_ptr< AvdeccFilesDeleteRequest >& request)
{
   dia::ScopeTrace trc("dia_ASFComponentSubsystemDiagnosisServer::onAvdeccFilesDeleteRequest");
   tDiaResult result = DIA_FAILED;
   result = avdecc_filesDelete();
   sendAvdeccFilesDeleteResponse((result == DIA_SUCCESS)? 0: 1);
}
//------------------------------------------------------------------------------

DoIP_Node* 
dia_ASFComponentSubsystemDiagnosisServer::vAddNode(DoIP_Node* node)
{
	//dia_tclFnctTrace oTrace("dia_ASFComponentSubsystemDiagnosisServer::vAddNode(DoIP_Node* node)");
	return NULL;
}

//------------------------------------------------------------------------------

DoIP_Node* 
dia_ASFComponentSubsystemDiagnosisServer::vAddNode(tU16 /*testerAddress*/, sockaddr_in /*IP*/, tU16 /*logAddr*/, tU32 /*maxDataSize*/)
{
	//dia_tclFnctTrace oTrace("dia_ASFComponentSubsystemDiagnosisServer::vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, tU32 maxDataSize)");
	
	DoIP_Node* poNode = NULL;
	/*
	DoIP_NodeType nodeType;

	poNode = new DoIP_Node(testerAddress,IP,logAddr,nullptr,nullptr,nullptr,nodeType,maxDataSize,nullptr);
	
	if(!poNode){
	oDoIP_Nodes.push_back(poNode);}
	*/
	return (poNode);
}

//------------------------------------------------------------------------------

DoIP_Node* 
dia_ASFComponentSubsystemDiagnosisServer::vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize)
{
	//dia_tclFnctTrace oTrace("dia_ASFComponentSubsystemDiagnosisServer::vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize)");
	//DoIP_Node* poNode = NULL;
	
	DoIP_Cfg doipCfg;

	poNode = new DoIP_Node(testerAddress,IP,logAddr,EID,GID,VIN,nodeType,maxDataSize,doipCfg);
	
	//DIA_TR_INF("dia_ASFComponentSubsystemDiagnosisServer:vAddNode -- 0x%08X", IP.sin_addr.s_addr);

	if(poNode)
	{
		//DIA_TR_INF("dia_ASFComponentSubsystemDiagnosisServer:vAddNode -- 0x%02X", poNode->logicalAddr);
		//oDoIP_Nodes.push_back(poNode);
		vAddNode(IP,logAddr,EID,GID,VIN,nodeType,maxDataSize);
	}

	return (poNode);
}

void 
dia_ASFComponentSubsystemDiagnosisServer::vAddNode(sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize)
{
	//dia_tclFnctTrace oTrace("dia_ASFComponentSubsystemDiagnosisServer::vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize)");
	
	DIA_TR_INF("dia_ASFComponentSubsystemDiagnosisServer:vAddNode -- [IP :0x%08X] [LOGICAL ADDR: 0x%02X]",  IP.sin_addr.s_addr, logAddr);
	
	//subsystem s;
	//DiscoverEntitiesResponseNodeListStruct node;
	/*
	s.sin_family = IP.sin_family;
	
	s.sin_port = IP.sin_port;
	s.s_addr = IP.sin_addr.s_addr;
	for(int i=0; i<8; i++)
	{
		s.sin_zero[i] = IP.sin_zero[i];
	}
	s.logAdr = logAddr;
	for(int i=0; i<8; i++)
	{
		s.EID[i] = EID[i];
	}
	for(int i=0; i<8; i++)
	{
		s.GID[i] = GID[i];
	}
	for(int i=0; i<17; i++)
	{
		s.VIN[i] = VIN[i];
	} */
	
	
	::std::vector<uint8> e4;
	for(int i=0; i<8; i++)
	{
		e4.push_back(IP.sin_zero[i]);
	}
	DiscoverEntitiesResultsResponseNodeListElem4Struct elem4(e4);
	::std::vector<uint8> e6;
	for(int i=0; i<8; i++)
	{
		e6.push_back(EID[i]);
	}
	DiscoverEntitiesResultsResponseNodeListElem6Struct elem6(e6);
	::std::vector<uint8> e7;
	for(int i=0; i<8; i++)
	{
		e7.push_back(GID[i]);
	}
	DiscoverEntitiesResultsResponseNodeListElem7Struct elem7(e7);
	::std::vector<uint8> e8;
	for(int i=0; i<17; i++)
	{
		e8.push_back(VIN[i]);
	}
	DiscoverEntitiesResultsResponseNodeListElem8Struct elem8(e8);
	
	
	
	DiscoverEntitiesResultsResponseNodeListStruct node ((int32)IP.sin_family, 
													   (int32)IP.sin_port, 
													   (int32)IP.sin_addr.s_addr, 
													   e4,
													   (int32)logAddr, 
													   e6, e7,e8);
	nodeList.push_back(node);

	//DIA_TR_INF("dia_ASFComponentSubsystemDiagnosisServer:vAddNode -- 0x%02X", logAddr);
	//arSubsystem.push_back(s);
}

bool dia_ASFComponentSubsystemDiagnosisServer::avdecc_filesDelete(void)
{
	tDiaResult retCode = DIA_FAILED;

	dia_FileDir avdeccFilesDelete(AVDECC_FILES_DELETE_PATH);

	std::string cmd_string = "rm -rf " + AVDECC_FILES_DELETE_PATH + "*" ;

	if(avdeccFilesDelete.doesExist())
	 {
		int ret = system(cmd_string.c_str());
		DIA_TR_ERR("  +-->Return value of system() command is:%d",ret);
		// Evaluate the system command execution result
		if ( WIFSIGNALED(ret) && ((WTERMSIG(ret) == SIGINT) || (WTERMSIG(ret) == SIGQUIT)) )
		{
			DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR COPY COMMAND");
			retCode = DIA_FAILED;
		}

		if(ret == 0)
		{
			DIA_TR_INF("Avdecc Files Deletion...  Successful!!!");
			retCode = DIA_SUCCESS;
		}
		else{
			DIA_TR_INF("Avdecc Files Deletion...  UnSuccessful!!!");
			retCode = DIA_FAILED;
		}
	 }
	else
	{
		DIA_TR_INF("Avdecc Files: Either Source Path or Destination path not Exit!!!");
		retCode = DIA_SUCCESS;
	}


	return retCode;
}



} //namespace asf
