/*!
 * \file       dia_ASFComponentSubsystemDiagnosisClient.h
 *
 * \brief      ASF Component to implement the Subsystem Diagnosis Proxy.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponent
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_CLIENT__
#define __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_CLIENT__

#include "dia_ASFComponent.h"

namespace asf {

class dia_ASFComponentSubsystemDiagnosisClient
   : public dia_ASFComponent
{
   friend BaseComponent* ComponentFactory<dia_ASFComponentSubsystemDiagnosisClient>::getComponent();

private:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentSubsystemDiagnosisClient>::getComponent()
   dia_ASFComponentSubsystemDiagnosisClient();

public:
   //! default class destructor
   virtual ~dia_ASFComponentSubsystemDiagnosisClient();
};

} //namespace asf

#endif /* __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_CLIENT__ */