/*
 * dia_ASFComponentSdsGuiPopup.cpp
 *
 *  Created on: Apr 18, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATURESDSGUIPOPUP_H_
#include <project/framework/sysadapters/dia_SAFeatureSdsGuiPopup.h>
#endif

#ifndef SDS_GUI_FI_POPUPSERVICEPROXY_H
#include <sds_gui_fi/PopUpServiceProxy.h>
#endif

#include "dia_ASFComponentSdsGuiPopup.h"

using namespace sds_gui_fi::PopUpService;


namespace asf {

dia_ASFComponentSdsGuiPopup::dia_ASFComponentSdsGuiPopup()
{
	dia_tclFnctTrace oTrace("--> dia_ASFComponentSdsGuiPopup::dia_ASFComponentSdsGuiPopup");

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentSdsGuiPopup::dia_ASFComponentSdsGuiPopup. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentSdsGuiPopup::dia_ASFComponentSdsGuiPopup. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	//dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
	::boost::shared_ptr< PopUpServiceProxy > proxy =  PopUpServiceProxy::createProxy("sdsGuiPopupPort", *pSystemAdapter);

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< PopUpServiceProxy >* pSASdsGuiPopupService = dia_ASFComponent::createSystemAdapterServicePlugin<PopUpServiceProxy>("DIA_SASdsGuiPopupSrv", proxy, pSystemAdapter);

	//
	// Feature Plugins
	//
	dia_SAFeatureSdsGuiPopup* pSAFeatureSdsGuiPopup = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSdsGuiPopup, PopUpServiceProxy>(pSASdsGuiPopupService);

	if ( pSAFeatureSdsGuiPopup )
	{
	  if (assignInterfaceAndNotifier<dia_ISdsGuiPopup, dia_ISdsGuiPopupListener, dia_ISdsGuiPopupNotifier>(pSAFeatureSdsGuiPopup) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentSdsGuiPopup::dia_ASFComponentSdsGuiPopup. Error: assignInterfaceAndNotifier failed");
	  }
	}
#endif
}

//------------------------------------------------------------------------------

dia_ASFComponentSdsGuiPopup::~dia_ASFComponentSdsGuiPopup()
{
}

//------------------------------------------------------------------------------

} //namespace asf
