/*
 * dia_ASFComponentSdsDiagnosisService.cpp
 *
 *  Created on: August 24, 2017
 *      Author: nlk1kor
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATURESDSDIAGNOSISSERVICE_H_
#include <project/framework/sysadapters/dia_SAFeatureSdsDiagnosisService.h>
#endif

#ifndef SDS_GUI_FI_SDSDIAGNOSISSERVICEPROXY_H
#include <sds_gui_fi/SdsDiagnosisServiceProxy.h>
#endif

#include "dia_ASFComponentSdsDiagnosisService.h"

using namespace sds_gui_fi::SdsDiagnosisService;


namespace asf {

dia_ASFComponentSdsDiagnosisService::dia_ASFComponentSdsDiagnosisService()
{
	dia_tclFnctTrace oTrace("--> dia_ASFComponentSdsDiagnosisService::dia_ASFComponentSdsDiagnosisService");

#ifdef VARIANT_S_FTR_ENABLE_NPIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentSdsDiagnosisService::dia_ASFComponentSdsDiagnosisService. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentSdsDiagnosisService::dia_ASFComponentSdsDiagnosisService. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	::boost::shared_ptr< SdsDiagnosisServiceProxy > proxy =  SdsDiagnosisServiceProxy::createProxy("SdsDiagnosisServicePort", *pSystemAdapter);

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< SdsDiagnosisServiceProxy >* pSASdsDiagnosisService = dia_ASFComponent::createSystemAdapterServicePlugin<SdsDiagnosisServiceProxy>("DIA_SASdsDiagnosisServiceSrv", proxy, pSystemAdapter);

	//
	// Feature Plugins
	//
	dia_SAFeatureSdsDiagnosisService* pSAFeatureSdsDiagnosisService = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSdsDiagnosisService,SdsDiagnosisServiceProxy>(pSASdsDiagnosisService);

	if ( pSAFeatureSdsDiagnosisService )
	{
	  if (assignInterfaceAndNotifier<dia_ISdsDiagnosisService, dia_ISdsDiagnosisServiceListener, dia_ISdsDiagnosisServiceNotifier>(pSAFeatureSdsDiagnosisService) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentSdsDiagnosisService::dia_ASFComponentSdsDiagnosisService. Error: assignInterfaceAndNotifier failed");
	  }
	}
#endif
}

//------------------------------------------------------------------------------

dia_ASFComponentSdsDiagnosisService::~dia_ASFComponentSdsDiagnosisService()
{
}

//------------------------------------------------------------------------------

} //namespace asf
