/*
 * dia_ASFComponentHmiNavigation.cpp
 *
 *  Created on: May 17, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATUREHMINAVIGATION_H_
#include <project/framework/sysadapters/dia_SAFeatureHMINavigation.h>
#endif

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICEPROXY_H
#include <org/bosch/cm/navigation/NavigationServiceProxy.h>
#endif


#include "dia_ASFComponentHmiNavigation.h"

using namespace org::bosch::cm::navigation::NavigationService;

namespace asf {

dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation() {
	dia_tclFnctTrace oTrace("--> dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation");

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	//dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
	::boost::shared_ptr< NavigationServiceProxy > proxy =  NavigationServiceProxy::createProxy("hmiNavigationPort", *pSystemAdapter);

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< NavigationServiceProxy >* pSAHMINavigationService = dia_ASFComponent::createSystemAdapterServicePlugin<NavigationServiceProxy>("DIA_SAHMINavigationSrv", proxy, pSystemAdapter);

	//
	// Feature Plugins
	//
	dia_SAFeatureHMINavigation* pSAFeatureHMINavigation = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureHMINavigation, NavigationServiceProxy>(pSAHMINavigationService);

	if ( pSAFeatureHMINavigation )
	{
	  if (assignInterfaceAndNotifier<dia_IHMINavigation, dia_IHMINavigationListener, dia_IHMINavigationNotifier>(pSAFeatureHMINavigation) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation. Error: assignInterfaceAndNotifier failed");
	  }
	}
   else
   {
      DIA_TR_ERR("dia_ASFComponentHmiNavigation::dia_ASFComponentHmiNavigation pSAFeatureHMINavigation NULL");
   }
#endif
}

dia_ASFComponentHmiNavigation::~dia_ASFComponentHmiNavigation() {
	// TODO Auto-generated destructor stub
}

} //namespace asf
