/*
 * dia_ASFComponentHmiMonitor.cpp
 *
 *  Created on: Apr 12, 2016
 *      Author: jas1hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef DIA_SAFEATUREHMIMONITOR_H_
#include <project/framework/sysadapters/dia_SAFeatureHMIMonitor.h>
#endif

#ifndef BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICEPROXY_H
#include <bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceProxy.h>
#endif

#include "dia_ASFComponentHmiMonitor.h"

using namespace bosch::cm::ai::nissan::hmi::hmimonitorservice::HmiMonitorService;


namespace asf {

dia_ASFComponentHmiMonitor::dia_ASFComponentHmiMonitor()
{
	dia_tclFnctTrace oTrace("--> dia_ASFComponentHmiMonitor::dia_ASFComponentHmiMonitor");

#ifdef VARIANT_S_FTR_ENABLE_RNAIVI
	dia_Factory* pFactory = getInstanceOfFactory();
	if ( !pFactory )
	{
	  DIA_TR_ERR("dia_ASFComponentHmiMonitor::dia_ASFComponentHmiMonitor. Error: Failed to get pointer to global factory !!");
	  return;
	}

	tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
	if ( retCode != DIA_SUCCESS )
	{
	  DIA_TR_ERR("dia_ASFComponentHmiMonitor::dia_ASFComponentHmiMonitor. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
	  return;
	}

	//
	// asf System Adapter object
	//
	//dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
	std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
	::boost::shared_ptr< HmiMonitorServiceProxy > proxy =  HmiMonitorServiceProxy::createProxy("hmiMonitorPort", *pSystemAdapter);

	//
	// Service Plugins
	//
	dia_SystemAdapterServicePluginASF< HmiMonitorServiceProxy >* pSAHMIMonitorService = dia_ASFComponent::createSystemAdapterServicePlugin<HmiMonitorServiceProxy>("DIA_SAHMIMonitorSrv", proxy, pSystemAdapter);

	//
	// Feature Plugins
	//
	dia_SAFeatureHMIMonitor* pSAFeatureHMIMonitor = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureHMIMonitor, HmiMonitorServiceProxy>(pSAHMIMonitorService);

	if ( pSAFeatureHMIMonitor )
	{
	  if (assignInterfaceAndNotifier<dia_IHMIMonitor, dia_IHMIMonitorListener, dia_IHMIMonitorNotifier>(pSAFeatureHMIMonitor) != DIA_SUCCESS)
	  {
		 DIA_TR_ERR("dia_ASFComponentHmiMonitor::dia_ASFComponentHmiMonitor. Error: assignInterfaceAndNotifier failed");
	  }
	}
#endif
}

//------------------------------------------------------------------------------

dia_ASFComponentHmiMonitor::~dia_ASFComponentHmiMonitor()
{
}

//------------------------------------------------------------------------------

} //namespace asf
