///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SubsystemDiagnosisFSM.h
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_SubsystemDiagnosis.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SUBSYSTEMDIAGNOSISFSM__
#define __INCLUDED_DIA_SUBSYSTEMDIAGNOSISFSM__

namespace dia_SubsystemDiagnosisFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evActivate,
   evChkPowerMode,
   evChkRoutingActivation,
   evChkTCPSocket,
   evConnect,
   evConnectFailed,
   evConnectSuccess,
   evDeactivate,
   evDEDTimeout,
   evEvalRoutedReq,
   evEvaluateActivation,
   evEvaluateDeactivation,
   evIdentifyResult,
   evIdentifyStart,
   evOnPMResponse,
   evOnRAResponse,
   evOnRoutingDelayTimeout,
   evOnRoutingResponse,
   evPMRDelayTimeout,
   evPreCondChkDone,
   evRADelayTimeout,
   evReadSubNodeRequest,
   evRequestConnectReady,
   evRequestConnectValid,
   evRequestIdentifyReady,
   evRequestIdentifyValid,
   evRequestRouteReady,
   evRequestRouteValid,
   evReset,
   evRouteRequest,
   evRouteResponseFinal,
   evRouteResponseWait,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActivatingState;
   friend class ConnectingState;
   friend class DeactivatingState;
   friend class DisconnectingState;
   friend class IdentifyingState;
   friend class RoutingState;
   friend class SubsystemActiveState;
   friend class SubsystemConnectedState;
   friend class SubsystemIdentifiedState;
   friend class SubsystemInactiveState;
   friend class TopLevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void postprocessConnect ( void* pArg ) = 0;
   virtual void postprocessIdentify ( void* pArg ) = 0;
   virtual void postprocessRoute ( void* pArg ) = 0;
   virtual void prepareDeactivate ( void* pArg ) = 0;
   virtual void preprocessConnect ( void* pArg ) = 0;
   virtual void preprocessIdentify ( void* pArg ) = 0;
   virtual void preprocessRoute ( void* pArg ) = 0;
   virtual void sendIdentifyResultNokResponse ( void* pArg ) = 0;
   virtual void sendIdentifyResultOkResponse ( void* pArg ) = 0;
   virtual void sendIdentifyResultRunningResponse ( void* pArg ) = 0;
   virtual void sendIdentifyStartNokResponse ( void* pArg ) = 0;
   virtual void sendIdentifyStartRunningResponse ( void* pArg ) = 0;
   virtual void sendSubNodeListResponse ( void* pArg ) = 0;
   virtual void sendSubsystemConnectNegResponse ( void* pArg ) = 0;
   virtual void sendSubsystemConnectPosResponse ( void* pArg ) = 0;
   virtual void sendSubsystemRoutingNegResponse ( void* pArg ) = 0;
   virtual void sendSubsytemSessionNegResponse ( void* pArg ) = 0;
   virtual void sendSubsytemSessionPosResponse ( void* pArg ) = 0;
   virtual void validateConnectRequest ( void* pArg ) = 0;
   virtual void validateIdentifyRequest ( void* pArg ) = 0;
   virtual void validateRouteRequest ( void* pArg ) = 0;
   virtual void validateRouteResponse ( void* pArg ) = 0;
   virtual void vFsmActivateSubsystemSession ( void* pArg ) = 0;
   virtual void vFsmCheckConnectPreconditions ( void* pArg ) = 0;
   virtual void vfsmCloseCurrentConnectiontoNode ( void* pArg ) = 0;
   virtual void vFsmCreateTCPSocketandConnect ( void* pArg ) = 0;
   virtual void vFsmDeactivateSubsystemSession ( void* pArg ) = 0;
   virtual void vFsmDeactivationFailed ( void* pArg ) = 0;
   virtual void vFsmDisconnect ( void* pArg ) = 0;
   virtual void vFsmDiscoverEntities ( void* pArg ) = 0;
   virtual void vFsmOnPMRTimeout ( void* pArg ) = 0;
   virtual void vFsmOnRATimeout ( void* pArg ) = 0;
   virtual void vFsmOnRequestRoutingDone ( void* pArg ) = 0;
   virtual void vFsmOnSessionDeactivated ( void* pArg ) = 0;
   virtual void vFsmOnSubsystemWaitResponse ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmRouteRcvdRequest ( void* pArg ) = 0;
   virtual void vFsmRouteRcvdResponse ( void* pArg ) = 0;
   virtual void vFsmSendReqSessionSwitch2Extended ( void* pArg ) = 0;
   virtual void vFsmStartDEDelayTimer ( void* pArg ) = 0;
   virtual void vFsmStartPMRDelayTimer ( void* pArg ) = 0;
   virtual void vFsmStartRADelayTimer ( void* pArg ) = 0;
   virtual void vFsmStartSubsystemRoutingDelayTimer ( void* pArg ) = 0;
   virtual void vFsmStopDEDelayTimer ( void* pArg ) = 0;
   virtual void vFsmStopPMRDelayTimer ( void* pArg ) = 0;
   virtual void vFsmStopRADelayTimer ( void* pArg ) = 0;
   virtual void vFsmStopSubsystemRoutingDelayTimer ( void* pArg ) = 0;
   virtual void vFsmTriggerESR ( void* pArg ) = 0;
   virtual void vFsmTriggerPMR ( void* pArg ) = 0;
   virtual void vFsmTriggerRAR ( void* pArg ) = 0;

   // FSM guards
   virtual bool areConnectConditionsOk ( void* pArg ) = 0;
   virtual bool areIdentifyConditionsOk ( void* pArg ) = 0;
   virtual bool areRouteConditionsOk ( void* pArg ) = 0;
   virtual bool bIsActivationComplete ( void* pArg ) = 0;
   virtual bool bIsDeactivationComplete ( void* pArg ) = 0;
   virtual bool bIsEntityAlreadyConnected ( void* pArg ) = 0;
   virtual bool bIsEntityListEmpty ( void* pArg ) = 0;
   virtual bool bIsPowerModeOk ( void* pArg ) = 0;
   virtual bool bIsPreCondChkOk ( void* pArg ) = 0;
   virtual bool bIsRequestRouted ( void* pArg ) = 0;
   virtual bool bIsRoutingActivationOk ( void* pArg ) = 0;
   virtual bool bIsTCPSocketOk ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SubsystemDiagnosisFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
