///////////////////////////////////////////////////////////////////////////////
//
// File: dia_CISStartupLogoInstallationFSM.h
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_CISStartupLogoInstallationFSM.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_CISSTARTUPLOGOINSTALLATIONFSM__
#define __INCLUDED_DIA_CISSTARTUPLOGOINSTALLATIONFSM__

namespace dia_CISStartupLogoInstallationFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evChkPowerMode,
   evChkRoutingActivation,
   evChkTCPSocket,
   evConnectFailed,
   evConnectSuccess,
   evDataError,
   evDataTransfer,
   evDataTransferred,
   evDoIPClientActivated,
   evError,
   evFinalise,
   evNegativeResponse,
   evNxtLogoTrnsfr,
   evOnPowerModeResponse,
   evOnResponseRoutingActivation,
   evPositiveResponse,
   evReqResultsInstallLogo,
   evRequestInstallLogo,
   evRequestInstallLogoValid,
   evRespRcvd,
   evSessionChange,
   evTimeoutDiagRequest,
   evTimeoutPowerMode,
   evTimeoutRoutingActivation,
   evVehicleChecked,
   evVehicleListValidated,
   evVITimeout,
   evWaitResponse,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class FinaliseLogoTransferState;
   friend class GetDataBlockState;
   friend class InstallationActiveState;
   friend class NotActiveState;
   friend class ProcessDownloadState;
   friend class RequestDownloadState;
   friend class RequestSeedState;
   friend class SecurityUnlockState;
   friend class SendKeyState;
   friend class SessionSwitchState;
   friend class SetUpDoIPComSystemState;
   friend class StartupLogoTransferState;
   friend class ToplevelLogoInstallationState;
   friend class TransferDataState;
   friend class TransferExitState;
   friend class TransferringDataState;
   friend class VehicleConnectState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void assembleData ( void* pArg ) = 0;
   virtual void calcKey ( void* pArg ) = 0;
   virtual void chkIfLogoTrnsfrToAllDone ( void* pArg ) = 0;
   virtual void chkVehicle ( void* pArg ) = 0;
   virtual void closeCurrentConnection ( void* pArg ) = 0;
   virtual void connectToVehicle ( void* pArg ) = 0;
   virtual void evaluateRequestDownloadResponse ( void* pArg ) = 0;
   virtual void evaluateResponseTransferData ( void* pArg ) = 0;
   virtual void evaluateResponseTransferExit ( void* pArg ) = 0;
   virtual void getNextBlock ( void* pArg ) = 0;
   virtual void onFailedPowerMode ( void* pArg ) = 0;
   virtual void onFailedRoutingActivation ( void* pArg ) = 0;
   virtual void onRoutingActivationSuccess ( void* pArg ) = 0;
   virtual void postprocessLogoInstallation ( void* pArg ) = 0;
   virtual void postprocessRequestDownloadResp ( void* pArg ) = 0;
   virtual void postprocessSecurityUnlock ( void* pArg ) = 0;
   virtual void postprocessSeedResponse ( void* pArg ) = 0;
   virtual void postprocessSessionSwitch ( void* pArg ) = 0;
   virtual void postprocessTransferDataResp ( void* pArg ) = 0;
   virtual void postprocessTransferExitResp ( void* pArg ) = 0;
   virtual void postprocessVehicleConnected ( void* pArg ) = 0;
   virtual void prepareDownload ( void* pArg ) = 0;
   virtual void prepareLogoInstallation ( void* pArg ) = 0;
   virtual void prepareNextLogoTransfer ( void* pArg ) = 0;
   virtual void prepareSecurityUnlock ( void* pArg ) = 0;
   virtual void prepareTransferData ( void* pArg ) = 0;
   virtual void reset ( void* pArg ) = 0;
   virtual void selectVehicleForLogoDownload ( void* pArg ) = 0;
   virtual void sendErr_AlreadyRequested ( void* pArg ) = 0;
   virtual void sendErr_ConditionsNotCorrect ( void* pArg ) = 0;
   virtual void sendErr_InstallationAborted ( void* pArg ) = 0;
   virtual void sendRequestDownload ( void* pArg ) = 0;
   virtual void sendRequestExtSessionChange ( void* pArg ) = 0;
   virtual void sendRequestPowerMode ( void* pArg ) = 0;
   virtual void sendRequestRoutingActivation ( void* pArg ) = 0;
   virtual void sendRequestSecurityKey ( void* pArg ) = 0;
   virtual void sendRequestSecuritySeed ( void* pArg ) = 0;
   virtual void sendRequestTransferData ( void* pArg ) = 0;
   virtual void sendRequestTransferExit ( void* pArg ) = 0;
   virtual void sendReqVI ( void* pArg ) = 0;
   virtual void sendRoutineFinalResponse ( void* pArg ) = 0;
   virtual void sendRoutineRunningResponse ( void* pArg ) = 0;
   virtual void setInstallationActivated ( void* pArg ) = 0;
   virtual void startDoIPClient ( void* pArg ) = 0;
   virtual void startTimerPowerMode ( void* pArg ) = 0;
   virtual void startTimerRequestDownload ( void* pArg ) = 0;
   virtual void startTimerRoutingActivation ( void* pArg ) = 0;
   virtual void startTimerSecurityKey ( void* pArg ) = 0;
   virtual void startTimerSecuritySeed ( void* pArg ) = 0;
   virtual void startTimerSessionSwitch ( void* pArg ) = 0;
   virtual void startTimerTransferData ( void* pArg ) = 0;
   virtual void startTimerTransferExit ( void* pArg ) = 0;
   virtual void startTimerVI ( void* pArg ) = 0;
   virtual void stopLogoInstallation ( void* pArg ) = 0;
   virtual void stopTimerPowerMode ( void* pArg ) = 0;
   virtual void stopTimerRequestDownload ( void* pArg ) = 0;
   virtual void stopTimerRoutingActivation ( void* pArg ) = 0;
   virtual void stopTimerSecurityKey ( void* pArg ) = 0;
   virtual void stopTimerSecuritySeed ( void* pArg ) = 0;
   virtual void stopTimerSessionSwitch ( void* pArg ) = 0;
   virtual void stopTimerTransferData ( void* pArg ) = 0;
   virtual void stopTimerTransferExit ( void* pArg ) = 0;
   virtual void validateLogoInstallationRequest ( void* pArg ) = 0;
   virtual void validateSecurityKeyReponse ( void* pArg ) = 0;
   virtual void validateSecuritySeedReponse ( void* pArg ) = 0;
   virtual void validateSessionChangeReponse ( void* pArg ) = 0;
   virtual void validateVehicleList ( void* pArg ) = 0;
   virtual void vHandleDataError ( void* pArg ) = 0;
   virtual void vHandleFinalResponse ( void* pArg ) = 0;
   virtual void vHandleRequestDownloadError ( void* pArg ) = 0;
   virtual void vHandleRequestDownloadTimeout ( void* pArg ) = 0;
   virtual void vHandleRequestSeedError ( void* pArg ) = 0;
   virtual void vHandleSecurityKeyError ( void* pArg ) = 0;
   virtual void vHandleSecurityKeyTimeout ( void* pArg ) = 0;
   virtual void vHandleSecuritySeedTimeout ( void* pArg ) = 0;
   virtual void vHandleSessionChangeError ( void* pArg ) = 0;
   virtual void vHandleSessionChangeTimeout ( void* pArg ) = 0;
   virtual void vHandleSessionRequest ( void* pArg ) = 0;
   virtual void vHandleTransferDataError ( void* pArg ) = 0;
   virtual void vHandleTransferDataTimeout ( void* pArg ) = 0;
   virtual void vHandleTransferExitError ( void* pArg ) = 0;
   virtual void vHandleTransferExitTimeout ( void* pArg ) = 0;
   virtual void vHandleVehicleConnectError ( void* pArg ) = 0;

   // FSM guards
   virtual bool areInstallationConditionsOk ( void* pArg ) = 0;
   virtual bool bFsmIsDataTransferComplete ( void* pArg ) = 0;
   virtual bool bIsPowerModeOk ( void* pArg ) = 0;
   virtual bool bIsRoutingActivationOk ( void* pArg ) = 0;
   virtual bool isClientActivationOk ( void* pArg ) = 0;
   virtual bool isFinalResponseReady ( void* pArg ) = 0;
   virtual bool isTCPSocketOk ( void* pArg ) = 0;
   virtual bool isVehicleListEmpty ( void* pArg ) = 0;
   virtual bool isVehicleListValid ( void* pArg ) = 0;
   virtual bool isVehicleValid ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_CISStartupLogoInstallationFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
