///////////////////////////////////////////////////////////////////////////////
//
// File: dia_CISStartupLogoInstallationFSM.cpp
//
// Generated by SMC 4.5.5 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_CISStartupLogoInstallationFSM.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_CISSTARTUPLOGOINSTALLATIONFSM__
#include "dia_CISStartupLogoInstallationFSM.h"
#endif

namespace dia_CISStartupLogoInstallationFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDoIPClientActivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNxtLogoTrnsfr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnPowerModeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnResponseRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogoValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVehicleChecked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVehicleListValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVITimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinaliseLogoTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class FinaliseLogoTransferState
   : public FsmState
{
public:
   //! default constructor
   FinaliseLogoTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNxtLogoTrnsfr ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* FinaliseLogoTransferState::mStateName = "FinaliseLogoTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetDataBlockState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GetDataBlockState
   : public FsmState
{
public:
   //! default constructor
   GetDataBlockState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GetDataBlockState::mStateName = "GetDataBlock";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InstallationActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class InstallationActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   InstallationActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* InstallationActiveState::mStateName = "InstallationActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class NotActiveState
   : public FsmState
{
public:
   //! default constructor
   NotActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogoValid ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* NotActiveState::mStateName = "NotActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessDownloadState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessDownloadState
   : public FsmSuperState
{
public:
   //! default constructor
   ProcessDownloadState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ProcessDownloadState::mStateName = "ProcessDownload";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestDownloadState
   : public FsmState
{
public:
   //! default constructor
   RequestDownloadState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestDownloadState::mStateName = "RequestDownload";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestSeedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RequestSeedState
   : public FsmState
{
public:
   //! default constructor
   RequestSeedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RequestSeedState::mStateName = "RequestSeed";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityUnlockState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecurityUnlockState
   : public FsmSuperState
{
public:
   //! default constructor
   SecurityUnlockState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecurityUnlockState::mStateName = "SecurityUnlock";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendKeyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SendKeyState
   : public FsmState
{
public:
   //! default constructor
   SendKeyState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SendKeyState::mStateName = "SendKey";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SessionSwitchState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SessionSwitchState
   : public FsmState
{
public:
   //! default constructor
   SessionSwitchState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SessionSwitchState::mStateName = "SessionSwitch";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SetUpDoIPComSystemState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SetUpDoIPComSystemState
   : public FsmState
{
public:
   //! default constructor
   SetUpDoIPComSystemState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDoIPClientActivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVehicleListValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVITimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SetUpDoIPComSystemState::mStateName = "SetUpDoIPComSystem";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartupLogoTransferState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class StartupLogoTransferState
   : public FsmSuperState
{
public:
   //! default constructor
   StartupLogoTransferState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* StartupLogoTransferState::mStateName = "StartupLogoTransfer";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelLogoInstallationState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelLogoInstallationState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelLogoInstallationState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions

protected:
   static const char* mStateName;
};

const char* ToplevelLogoInstallationState::mStateName = "ToplevelLogoInstallation";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferDataState
   : public FsmSuperState
{
public:
   //! default constructor
   TransferDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferDataState::mStateName = "TransferData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferExitState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferExitState
   : public FsmState
{
public:
   //! default constructor
   TransferExitState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferExitState::mStateName = "TransferExit";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferringDataState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TransferringDataState
   : public FsmState
{
public:
   //! default constructor
   TransferringDataState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRespRcvd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWaitResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TransferringDataState::mStateName = "TransferringData";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: VehicleConnectState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class VehicleConnectState
   : public FsmState
{
public:
   //! default constructor
   VehicleConnectState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnPowerModeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnResponseRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeoutRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVehicleChecked ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* VehicleConnectState::mStateName = "VehicleConnect";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    FinaliseLogoTransferState oFinaliseLogoTransferState;
    GetDataBlockState oGetDataBlockState;
    InstallationActiveState oInstallationActiveState;
    NotActiveState oNotActiveState;
    ProcessDownloadState oProcessDownloadState;
    RequestDownloadState oRequestDownloadState;
    RequestSeedState oRequestSeedState;
    SecurityUnlockState oSecurityUnlockState;
    SendKeyState oSendKeyState;
    SessionSwitchState oSessionSwitchState;
    SetUpDoIPComSystemState oSetUpDoIPComSystemState;
    StartupLogoTransferState oStartupLogoTransferState;
    ToplevelLogoInstallationState oToplevelLogoInstallationState;
    TransferDataState oTransferDataState;
    TransferExitState oTransferExitState;
    TransferringDataState oTransferringDataState;
    VehicleConnectState oVehicleConnectState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evChkPowerMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkPowerMode *** 
}

void
FsmState::evChkRoutingActivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkRoutingActivation *** 
}

void
FsmState::evChkTCPSocket ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChkTCPSocket *** 
}

void
FsmState::evConnectFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnectFailed *** 
}

void
FsmState::evConnectSuccess ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evConnectSuccess *** 
}

void
FsmState::evDataError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataError *** 
}

void
FsmState::evDataTransfer ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransfer *** 
}

void
FsmState::evDataTransferred ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTransferred *** 
}

void
FsmState::evDoIPClientActivated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDoIPClientActivated *** 
}

void
FsmState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evError *** 
}

void
FsmState::evFinalise ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFinalise *** 
}

void
FsmState::evNegativeResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNegativeResponse *** 
}

void
FsmState::evNxtLogoTrnsfr ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNxtLogoTrnsfr *** 
}

void
FsmState::evOnPowerModeResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnPowerModeResponse *** 
}

void
FsmState::evOnResponseRoutingActivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnResponseRoutingActivation *** 
}

void
FsmState::evPositiveResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPositiveResponse *** 
}

void
FsmState::evReqResultsInstallLogo ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReqResultsInstallLogo *** 
}

void
FsmState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestInstallLogo *** 
}

void
FsmState::evRequestInstallLogoValid ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestInstallLogoValid *** 
}

void
FsmState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRespRcvd *** 
}

void
FsmState::evSessionChange ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSessionChange *** 
}

void
FsmState::evTimeoutDiagRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeoutDiagRequest *** 
}

void
FsmState::evTimeoutPowerMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeoutPowerMode *** 
}

void
FsmState::evTimeoutRoutingActivation ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeoutRoutingActivation *** 
}

void
FsmState::evVehicleChecked ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evVehicleChecked *** 
}

void
FsmState::evVehicleListValidated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evVehicleListValidated *** 
}

void
FsmState::evVITimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evVITimeout *** 
}

void
FsmState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evWaitResponse *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinaliseLogoTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

FinaliseLogoTransferState::FinaliseLogoTransferState ( void )
{}

void
FinaliseLogoTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.closeCurrentConnection(pArg);
   s.chkIfLogoTrnsfrToAllDone(pArg);
}

void
FinaliseLogoTransferState::evFinalise ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleFinalResponse(pArg);
   // this is an internal transition
}

void
FinaliseLogoTransferState::evNxtLogoTrnsfr ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.prepareNextLogoTransfer(pArg);
   b.setState(b.oStartupLogoTransferState,pArg);
}

void
FinaliseLogoTransferState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendRoutineRunningResponse(pArg);
   // this is an internal transition
    }
}

void
FinaliseLogoTransferState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
FinaliseLogoTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GetDataBlockState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GetDataBlockState::GetDataBlockState ( void )
{}

void
GetDataBlockState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.getNextBlock(pArg);
   s.assembleData(pArg);
}

void
GetDataBlockState::evDataError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleDataError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
GetDataBlockState::evDataTransfer ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsDataTransferComplete(pArg) )
   {
        b.oProcessDownloadState.entry(b,s,pArg);
        b.setState(b.oTransferExitState,pArg);
    }
    else
    {
   b.setState(b.oTransferringDataState,pArg);
    }
}

void
GetDataBlockState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
GetDataBlockState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
GetDataBlockState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
GetDataBlockState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InstallationActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

InstallationActiveState::InstallationActiveState ( void )
{}

void
InstallationActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.setInstallationActivated(pArg);
}

void
InstallationActiveState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendRoutineRunningResponse(pArg);
   // this is an internal transition
    }
}

void
InstallationActiveState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
InstallationActiveState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: NotActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

NotActiveState::NotActiveState ( void )
{}

void
NotActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.reset(pArg);
}

void
NotActiveState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateLogoInstallationRequest(pArg);
   // this is an internal transition
}

void
NotActiveState::evRequestInstallLogoValid ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.areInstallationConditionsOk(pArg) )
   {
        // transition Actions
        s.prepareLogoInstallation(pArg);
        s.sendRoutineRunningResponse(pArg);
        b.setState(b.oInstallationActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendErr_ConditionsNotCorrect(pArg);
   // this is an internal transition
    }
}

void
NotActiveState::evSessionChange ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleSessionRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessDownloadState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessDownloadState::ProcessDownloadState ( void )
{}

void
ProcessDownloadState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.prepareDownload(pArg);
}

void
ProcessDownloadState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
ProcessDownloadState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
ProcessDownloadState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
ProcessDownloadState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestDownloadState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestDownloadState::RequestDownloadState ( void )
{}

void
RequestDownloadState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startTimerRequestDownload(pArg);
   s.sendRequestDownload(pArg);
}

void
RequestDownloadState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
RequestDownloadState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerRequestDownload(pArg);
   s.vHandleRequestDownloadError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestDownloadState::evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerRequestDownload(pArg);
   s.postprocessRequestDownloadResp(pArg);
   b.setState(b.oTransferDataState,pArg);
}

void
RequestDownloadState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
RequestDownloadState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
RequestDownloadState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.evaluateRequestDownloadResponse(pArg);
   // this is an internal transition
}

void
RequestDownloadState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
RequestDownloadState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleRequestDownloadTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestDownloadState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RequestSeedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RequestSeedState::RequestSeedState ( void )
{}

void
RequestSeedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startTimerSecuritySeed(pArg);
   s.sendRequestSecuritySeed(pArg);
}

void
RequestSeedState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
RequestSeedState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSecuritySeed(pArg);
   s.vHandleRequestSeedError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestSeedState::evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSecuritySeed(pArg);
   s.postprocessSeedResponse(pArg);
   b.setState(b.oSendKeyState,pArg);
}

void
RequestSeedState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
RequestSeedState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
RequestSeedState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateSecuritySeedReponse(pArg);
   // this is an internal transition
}

void
RequestSeedState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
RequestSeedState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleSecuritySeedTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RequestSeedState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityUnlockState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecurityUnlockState::SecurityUnlockState ( void )
{}

void
SecurityUnlockState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.prepareSecurityUnlock(pArg);
}

void
SecurityUnlockState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
SecurityUnlockState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
SecurityUnlockState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
SecurityUnlockState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendKeyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SendKeyState::SendKeyState ( void )
{}

void
SendKeyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.calcKey(pArg);
   s.startTimerSecurityKey(pArg);
   s.sendRequestSecurityKey(pArg);
}

void
SendKeyState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
SendKeyState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSecurityKey(pArg);
   s.vHandleSecurityKeyError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SendKeyState::evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSecurityKey(pArg);
   s.postprocessSecurityUnlock(pArg);
   b.oStartupLogoTransferState.entry(b,s,pArg);
   b.setState(b.oProcessDownloadState,pArg);
}

void
SendKeyState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
SendKeyState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
SendKeyState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateSecurityKeyReponse(pArg);
   // this is an internal transition
}

void
SendKeyState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
SendKeyState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleSecurityKeyTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SendKeyState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SessionSwitchState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SessionSwitchState::SessionSwitchState ( void )
{}

void
SessionSwitchState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startTimerSessionSwitch(pArg);
   s.sendRequestExtSessionChange(pArg);
}

void
SessionSwitchState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
SessionSwitchState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSessionSwitch(pArg);
   s.vHandleSessionChangeError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SessionSwitchState::evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerSessionSwitch(pArg);
   s.postprocessSessionSwitch(pArg);
   b.setState(b.oSecurityUnlockState,pArg);
}

void
SessionSwitchState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
SessionSwitchState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
SessionSwitchState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.validateSessionChangeReponse(pArg);
   // this is an internal transition
}

void
SessionSwitchState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
SessionSwitchState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleSessionChangeTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
SessionSwitchState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SetUpDoIPComSystemState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SetUpDoIPComSystemState::SetUpDoIPComSystemState ( void )
{}

void
SetUpDoIPComSystemState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startDoIPClient(pArg);
}

void
SetUpDoIPComSystemState::evDoIPClientActivated ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isClientActivationOk(pArg) )
   {
        // transition Actions
        s.startTimerVI(pArg);
        s.sendReqVI(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.sendErr_InstallationAborted(pArg);
   // this is an internal transition
    }
}

void
SetUpDoIPComSystemState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendRoutineRunningResponse(pArg);
   // this is an internal transition
    }
}

void
SetUpDoIPComSystemState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
SetUpDoIPComSystemState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
SetUpDoIPComSystemState::evVehicleListValidated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isVehicleListValid(pArg) )
   {
        b.setState(b.oStartupLogoTransferState,pArg);
    }
    else
    {
   // transition Actions
   s.sendErr_InstallationAborted(pArg);
   // this is an internal transition
    }
}

void
SetUpDoIPComSystemState::evVITimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.isVehicleListEmpty(pArg) )
   {
        // transition Actions
        s.sendErr_InstallationAborted(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.validateVehicleList(pArg);
   // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartupLogoTransferState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

StartupLogoTransferState::StartupLogoTransferState ( void )
{}

void
StartupLogoTransferState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.selectVehicleForLogoDownload(pArg);
}

void
StartupLogoTransferState::evError ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
StartupLogoTransferState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.sendRoutineRunningResponse(pArg);
   // this is an internal transition
    }
}

void
StartupLogoTransferState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
StartupLogoTransferState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelLogoInstallationState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelLogoInstallationState::ToplevelLogoInstallationState ( void )
{}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferDataState::TransferDataState ( void )
{}

void
TransferDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.prepareTransferData(pArg);
}

void
TransferDataState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
TransferDataState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
TransferDataState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
TransferDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferExitState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferExitState::TransferExitState ( void )
{}

void
TransferExitState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startTimerTransferExit(pArg);
   s.sendRequestTransferExit(pArg);
}

void
TransferExitState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
TransferExitState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerTransferExit(pArg);
   s.vHandleTransferExitError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferExitState::evPositiveResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerTransferExit(pArg);
   s.postprocessTransferExitResp(pArg);
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
TransferExitState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
TransferExitState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
TransferExitState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.evaluateResponseTransferExit(pArg);
   // this is an internal transition
}

void
TransferExitState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
TransferExitState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleTransferExitTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferExitState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TransferringDataState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TransferringDataState::TransferringDataState ( void )
{}

void
TransferringDataState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.startTimerTransferData(pArg);
   s.sendRequestTransferData(pArg);
}

void
TransferringDataState::evDataTransferred ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsDataTransferComplete(pArg) )
   {
        b.oProcessDownloadState.entry(b,s,pArg);
        b.setState(b.oTransferExitState,pArg);
    }
    else
    {
   b.setState(b.oGetDataBlockState,pArg);
    }
}

void
TransferringDataState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
TransferringDataState::evNegativeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerTransferData(pArg);
   s.vHandleTransferDataError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferringDataState::evPositiveResponse ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerTransferData(pArg);
   s.postprocessTransferDataResp(pArg);
   // this is an internal transition
}

void
TransferringDataState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
TransferringDataState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
TransferringDataState::evRespRcvd ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.evaluateResponseTransferData(pArg);
   // this is an internal transition
}

void
TransferringDataState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
TransferringDataState::evTimeoutDiagRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleTransferDataTimeout(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TransferringDataState::evWaitResponse ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: VehicleConnectState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

VehicleConnectState::VehicleConnectState ( void )
{}

void
VehicleConnectState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.chkVehicle(pArg);
}

void
VehicleConnectState::evChkPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsPowerModeOk(pArg) )
   {
        // transition Actions
        s.startTimerRoutingActivation(pArg);
        s.sendRequestRoutingActivation(pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
VehicleConnectState::evChkRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsRoutingActivationOk(pArg) )
   {
        // transition Actions
        s.onRoutingActivationSuccess(pArg);
        // trigger events
        FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

        event = dia_CISStartupLogoInstallationFSM::evConnectSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
VehicleConnectState::evChkTCPSocket ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isTCPSocketOk(pArg) )
   {
        // transition Actions
        s.startTimerPowerMode(pArg);
        s.sendRequestPowerMode(pArg);
        // this is an internal transition
    }
    else
    {
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
VehicleConnectState::evConnectFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vHandleVehicleConnectError(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evError; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
VehicleConnectState::evConnectSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.postprocessVehicleConnected(pArg);
   b.setState(b.oSessionSwitchState,pArg);
}

void
VehicleConnectState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
}

void
VehicleConnectState::evOnPowerModeResponse ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerPowerMode(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evChkPowerMode; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
VehicleConnectState::evOnResponseRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopTimerRoutingActivation(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evChkRoutingActivation; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
VehicleConnectState::evReqResultsInstallLogo ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isFinalResponseReady(pArg) )
   {
        // transition Actions
        s.sendRoutineFinalResponse(pArg);
        b.setState(b.oNotActiveState,pArg);
    }
}

void
VehicleConnectState::evRequestInstallLogo ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.sendErr_AlreadyRequested(pArg);
   // this is an internal transition
}

void
VehicleConnectState::evSessionChange ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.stopLogoInstallation(pArg);
   s.postprocessLogoInstallation(pArg);
   b.setState(b.oNotActiveState,pArg);
}

void
VehicleConnectState::evTimeoutPowerMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.onFailedPowerMode(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
VehicleConnectState::evTimeoutRoutingActivation ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.onFailedRoutingActivation(pArg);
   // trigger events
   FsmEvent event = dia_CISStartupLogoInstallationFSM::evUnknown;

   event = dia_CISStartupLogoInstallationFSM::evConnectFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
VehicleConnectState::evVehicleChecked ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isVehicleValid(pArg) )
   {
        // transition Actions
        s.connectToVehicle(pArg);
        // this is an internal transition
    }
    else
    {
   b.oInstallationActiveState.entry(b,s,pArg);
   b.setState(b.oFinaliseLogoTransferState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oFinaliseLogoTransferState.initState(&oInstallationActiveState);
    oGetDataBlockState.initState(&oTransferDataState);
    oInstallationActiveState.initSuperState(&oToplevelLogoInstallationState, &oSetUpDoIPComSystemState, false);
    oNotActiveState.initState(&oToplevelLogoInstallationState);
    oProcessDownloadState.initSuperState(&oStartupLogoTransferState, &oRequestDownloadState, false);
    oRequestDownloadState.initState(&oProcessDownloadState);
    oRequestSeedState.initState(&oSecurityUnlockState);
    oSecurityUnlockState.initSuperState(&oStartupLogoTransferState, &oRequestSeedState, false);
    oSendKeyState.initState(&oSecurityUnlockState);
    oSessionSwitchState.initState(&oStartupLogoTransferState);
    oSetUpDoIPComSystemState.initState(&oInstallationActiveState);
    oStartupLogoTransferState.initSuperState(&oInstallationActiveState, &oVehicleConnectState, false);
    oToplevelLogoInstallationState.initSuperState(0, &oNotActiveState, false);
    oTransferDataState.initSuperState(&oProcessDownloadState, &oGetDataBlockState, false);
    oTransferExitState.initState(&oProcessDownloadState);
    oTransferringDataState.initState(&oTransferDataState);
    oVehicleConnectState.initState(&oStartupLogoTransferState);

    setState(oToplevelLogoInstallationState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evChkPowerMode:
            if ( mpState ) mpState->evChkPowerMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evChkRoutingActivation:
            if ( mpState ) mpState->evChkRoutingActivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evChkTCPSocket:
            if ( mpState ) mpState->evChkTCPSocket(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnectFailed:
            if ( mpState ) mpState->evConnectFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evConnectSuccess:
            if ( mpState ) mpState->evConnectSuccess(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataError:
            if ( mpState ) mpState->evDataError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransfer:
            if ( mpState ) mpState->evDataTransfer(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTransferred:
            if ( mpState ) mpState->evDataTransferred(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDoIPClientActivated:
            if ( mpState ) mpState->evDoIPClientActivated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evError:
            if ( mpState ) mpState->evError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFinalise:
            if ( mpState ) mpState->evFinalise(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNegativeResponse:
            if ( mpState ) mpState->evNegativeResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNxtLogoTrnsfr:
            if ( mpState ) mpState->evNxtLogoTrnsfr(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnPowerModeResponse:
            if ( mpState ) mpState->evOnPowerModeResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnResponseRoutingActivation:
            if ( mpState ) mpState->evOnResponseRoutingActivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPositiveResponse:
            if ( mpState ) mpState->evPositiveResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReqResultsInstallLogo:
            if ( mpState ) mpState->evReqResultsInstallLogo(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestInstallLogo:
            if ( mpState ) mpState->evRequestInstallLogo(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestInstallLogoValid:
            if ( mpState ) mpState->evRequestInstallLogoValid(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRespRcvd:
            if ( mpState ) mpState->evRespRcvd(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSessionChange:
            if ( mpState ) mpState->evSessionChange(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeoutDiagRequest:
            if ( mpState ) mpState->evTimeoutDiagRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeoutPowerMode:
            if ( mpState ) mpState->evTimeoutPowerMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeoutRoutingActivation:
            if ( mpState ) mpState->evTimeoutRoutingActivation(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evVehicleChecked:
            if ( mpState ) mpState->evVehicleChecked(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evVehicleListValidated:
            if ( mpState ) mpState->evVehicleListValidated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evVITimeout:
            if ( mpState ) mpState->evVITimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evWaitResponse:
            if ( mpState ) mpState->evWaitResponse(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evChkPowerMode",
      "evChkRoutingActivation",
      "evChkTCPSocket",
      "evConnectFailed",
      "evConnectSuccess",
      "evDataError",
      "evDataTransfer",
      "evDataTransferred",
      "evDoIPClientActivated",
      "evError",
      "evFinalise",
      "evNegativeResponse",
      "evNxtLogoTrnsfr",
      "evOnPowerModeResponse",
      "evOnResponseRoutingActivation",
      "evPositiveResponse",
      "evReqResultsInstallLogo",
      "evRequestInstallLogo",
      "evRequestInstallLogoValid",
      "evRespRcvd",
      "evSessionChange",
      "evTimeoutDiagRequest",
      "evTimeoutPowerMode",
      "evTimeoutRoutingActivation",
      "evVehicleChecked",
      "evVehicleListValidated",
      "evVITimeout",
      "evWaitResponse",
   };

   return eventNames[event];
}


} // namespace
