#ifndef __INCLUDED_FACTORY_PLUGIN_UDD__
#define __INCLUDED_FACTORY_PLUGIN_UDD__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#include <common/framework/udd/dia_DoIP.h>
#include <common/framework/udd/dia_CommChannelDoIP.h>
class dia_MessageHandler;
class dia_TraceMonitor;
class dia_DoipStack {
public:
   dia_DoipStack();
   ~dia_DoipStack();
   tDiaResult setup(dia::dia_DoIPCfg const &doipCfg);
   tDiaResult shutdown();
private:
   dia::dia_DoIP *_server;
};

class dia_FactoryPluginUdd
   : public dia_FactoryPlugin
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginUdd);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_FactoryPluginUdd);//Coverity Fix(CID:47751 & 48262)
public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level );

protected:
   //! class constructor
   dia_FactoryPluginUdd ( void );
   //! class destructor
   virtual ~dia_FactoryPluginUdd ( void );

   //! tear down all objects created by this class
// tDiaResult tearDownObjects ( tVoid );

   tDiaResult makeChannelINC ( void );
   tDiaResult makeChannelTCP ( void );
   tDiaResult makeChannelDoIP();
   tDiaResult makeChannelCSMProxy ( void ) const;
   tDiaResult makeChannelTTFIS ( void );

   tDiaResult shutdownChannelINC ( void ) const;
   tDiaResult shutdownChannelTCP ( void ) const;
   tDiaResult shutdownChannelDoIP();
   tDiaResult shutdownChannelCSMProxy ( void ) const;
   tDiaResult shutdownChannelTTFIS ( void );

protected:
   dia::dia_DoIPCfg const &getDoipCfg();
   //! list of routine control objects
   std::list<dia_MessageHandler*> mHandlerRep;
   //! trace controller
   dia_TraceMonitor* mpTraceMonitor;
   dia_DoipStack *doipStack;
};

#endif
