/*!
 * \file       dia_FactoryPluginUdd.cpp
 *
 * \brief      Factory for UDD specific classes
 *
 * \details    Factory for UDD specific classes
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreUDD
 *
 * \copyright  (c) 2013-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

//#define __ENABLE_FEATURE_DOIP__
#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include <common/framework/application/dia_common_application.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDD__
#include <common/framework/udd/dia_common_udd.h>
#endif

#ifndef __INCLUDED_DIA_COMMCHANNEL_INC__
#include <common/framework/udd/dia_CommChannelINC.h>
#endif

#ifndef __INCLUDED_DIA_COMMCHANNEL_TCP__
#include <common/framework/udd/dia_CommChannelTCP.h>
#endif
#include <common/framework/udd/dia_CommChannelDoIP.h>

#ifndef __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__
#include <common/interfaces/dia_ITraceListener.h>
#endif

#ifndef __INCLUDED_DIA_TRACE_MONITOR__
#include <common/framework/trace/dia_TraceMonitor.h>
#endif

#ifndef __INCLUDED_DIA_TRACE_PLUGIN_UDS__
#include <common/framework/trace/dia_TracePluginUDS.h>
#endif

#ifndef __INCLUDED_DIA_TRACE_PLUGIN_CMD__
#include <common/framework/trace/dia_TracePluginCMD.h>
#endif

#ifndef __INCLUDED_DIA_TRACE_PLUGIN_SECURITY__
#include <common/framework/trace/dia_TracePluginSecurity.h>
#endif

#include "dia_FactoryPluginUdd.h"

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_MULTIPLE_READ_DATA_BY_ID_HANDLER__
#include <common/framework/protocols/uds/dia_MultipleReadDataByIDHandler.h>
#endif

#ifndef __INCLUDED_DIA_APP_STATE_HANDLER__
#include <common/framework/protocols/uds/dia_AppStateHandler.h>
#endif
#ifndef __INCLUDED_DIA_APP_RUNLEVEL_HANDLER__
#include <common/framework/protocols/uds/dia_AppRunLevelHandler.h>
#endif
#ifndef __INCLUDED_DIA_REQ_DNL_AIVI_HANDLER__
#include <project/framework/protocols/uds/dia_RequestDownloadHandlerAIVI.h>
#endif

#ifndef __INCLUDED_DIA_CUSTOMER_DIAG_HANDLER_SPEED_LIMIT_AIVI__
#include <project/framework/protocols/uds/dia_CustomerDiagHandlerSpeedLimitAIVI.h>
#endif

#ifndef __INCLUDED_DIA_ALDSTATUS_HANDLER__
#include <common/framework/protocols/uds/dia_ALDStatusHandler.h>
#endif

#ifndef __INCLUDED_DIA_SOCKET_CONFIGURATION__
#include <common/framework/application/dia_SocketConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_SOCKET__
#include <common/framework/application/dia_Socket.h>
#endif
#ifndef DIA_LASTDIAGERRORHANDLER_H_
#include <common/framework/protocols/uds/dia_LastDiagErrorHandler.h>
#endif
#ifndef __INCLUDED_DIA_OPMODE_HANDLER__
#include <common/framework/protocols/uds/dia_OpModeHandler.h>
#endif
#ifndef __INCLUDED_DIA_UTILITIES_
#include <common/framework/utils/dia_utilities.h>
#endif


#undef DIA_DOIP_SA_LOCAL
#undef DIA_DOIP_SA_TESTER
#undef DIA_DOIP_GID
#undef DIA_DOIP_ETH_NAME

#define DIA_DOIP_SA_LOCAL  0x0200
#define DIA_DOIP_SA_TESTER 0x0FF1
#define DIA_DOIP_GID "000101030001"
#define DIA_DOIP_ETH_NAME "ethernet"



DIA_IMPL_SINGLETON(dia_FactoryPluginUdd)

//-----------------------------------------------------------------------------

dia_FactoryPluginUdd::dia_FactoryPluginUdd ( void )
   : dia_FactoryPlugin("dia_FactoryPluginUdd",DIA_EN_FACTORY_PLUGIN_TYPE_UDD),
   mpTraceMonitor(0),
   doipStack(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginUdd::~dia_FactoryPluginUdd ( void )
{
   delete mpTraceMonitor;
         // (tVoid) tearDownObjects();

         mpTraceMonitor = 0;

   delete doipStack;
   doipStack = 0;
   
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginUdd::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF UDD FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      (void) makeChannelTTFIS();
      (void)makeChannelINC();
#ifdef __ENABLE_FEATURE_DOIP__
      (void) makeChannelDoIP();
#else
      (void) makeChannelTCP();
#endif
      (void) makeChannelCSMProxy();
   }

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      (void) shutdownChannelCSMProxy();
#ifdef __ENABLE_FEATURE_DOIP__
      (void) shutdownChannelDoIP();
#else
      (void) shutdownChannelTCP();
#endif
      (void) shutdownChannelINC();
      (void) shutdownChannelTTFIS();

      // destroy all system setting plugins
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_MessageHandler,mHandlerRep)
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::makeChannelINC ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::makeChannelINC");

   tDiaResult retCode = DIA_FAILED;

   udd_DriverFacade* pUDDFacade = getInstanceOfFacadeUDD();
   if ( pUDDFacade )
   {
      dia_CommChannelINC* pChannel = getInstanceOfCommChannelINC();
      if ( pChannel )
      {
         //---------------------------------------------------------------------------------------------------
         // 1. dia::AppRunLevelHandler     --> defer processing if current runlevel does not allow processing of the message
         // 2. dia::AppStateChangeHandler  --> defer message if application state change is currently in progress
         // 3. dia::ALDStatusHandler       --> defer message if device is programming session and upcomming diagnosis request is not switch session.
         // 4. dia_MultipleReadDataByIDHandler --> check multi DID read requests and split them into separate single read requests
         // 5. dia_RequestDownloadHandlerAIVI
         // 6. dia_CustomerDiagHandlerSpeedLimitAIVI
         //---------------------------------------------------------------------------------------------------

          dia_MessageHandler* pHandlerOpMode = new dia::OpModeHandler;
          if (pHandlerOpMode)
          {
             mHandlerRep.push_back(pHandlerOpMode);
             pChannel->setHandler(pHandlerOpMode);
          }
          else
          {
             DIA_TR_ERR("### ERR: pHandlerOpMode is NULL !!! ###");
          }
         dia_MessageHandler* pHandlerRunLevel = new dia::AppRunLevelHandler;
         if ( pHandlerRunLevel )
         {
            mHandlerRep.push_back(pHandlerRunLevel);
             if (pHandlerOpMode) pHandlerOpMode->setHandler(pHandlerRunLevel);
         }
         else
         {
            DIA_TR_ERR("### ERR: pHandlerRunLevel is NULL !!! ###");
         }

         dia_MessageHandler* pHandlerAppState = new dia_AppStateHandler();
         if ( pHandlerAppState )
         {
            mHandlerRep.push_back(pHandlerAppState);
            if (pHandlerRunLevel) pHandlerRunLevel->setHandler(pHandlerAppState);
         }
         else
         {
            DIA_TR_ERR("### ERR: pHandlerAppState is NULL !!! ###");
         }

         dia_MessageHandler* pHandlerALDStatus = new dia::ALDStatusHandler();
         if ( pHandlerALDStatus )
         {
            mHandlerRep.push_back(pHandlerALDStatus);
            if (pHandlerAppState) pHandlerAppState->setHandler(pHandlerALDStatus);
         }
         else
         {
            DIA_TR_ERR("### ERR: pHandlerALDStatus is NULL !!! ###");
         }

         dia_MessageHandler* pHandlerMultipleReadDataByID = new dia_MultipleReadDataByIDHandler();
         if ( pHandlerMultipleReadDataByID )
         {
            mHandlerRep.push_back(pHandlerMultipleReadDataByID);
            if (pHandlerALDStatus) pHandlerALDStatus->setHandler(pHandlerMultipleReadDataByID);
         }
         else
         {
            DIA_TR_ERR("### ERR: pHandlerMultipleReadDataByID is NULL !!! ###");
         }
         /*
         dia_MessageHandler* pHandlerRequestDownloadAIVI = OSAL_NEW dia_RequestDownloadHandlerAIVI();
         if ( pHandlerRequestDownloadAIVI )
         {
            mHandlerRep.push_back(pHandlerRequestDownloadAIVI);
            if (pHandlerMultipleReadDataByID) pHandlerMultipleReadDataByID->setHandler(pHandlerRequestDownloadAIVI);
         }
         else
         {
            DIA_TR_ERR("### ERR: pHandlerRequestDownloadAIVI is NULL !!! ###");
         }

         dia_MessageHandler* pCustomerDiagHandlerSpeedLimitAIVI = OSAL_NEW dia_CustomerDiagHandlerSpeedLimitAIVI();
         if ( pCustomerDiagHandlerSpeedLimitAIVI )
         {
            mHandlerRep.push_back(pCustomerDiagHandlerSpeedLimitAIVI);
            if (pHandlerRequestDownloadAIVI) pHandlerRequestDownloadAIVI->setHandler(pCustomerDiagHandlerSpeedLimitAIVI);
         }
         else
         {
            DIA_TR_ERR("### ERR: pCustomerDiagHandlerSpeedLimitAIVI is NULL !!! ###");
         }
         	 */
         pUDDFacade->assign(*pChannel);
      } //lint !e429 custodial pointer is freed by this factory class

      DIA_TR_INF("### Setup Communication Channel INC ###");

      udd_CommChannel* pUdsCanDriver = 0;
      if ( pUDDFacade->queryCommChannel(UDD_CHANNEL_UID_UDS_CAN,&pUdsCanDriver) == DIA_SUCCESS )
      {
         if ( pUdsCanDriver->connect(UDD_CHANNEL_UID_UDS_CAN) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("### ERR: Unable to connect to communication channel (INC) !!! ###");
         }
      }
      else
      {
         DIA_TR_ERR(("### ERROR: communication channel (INC) not available !!! ###"));
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::shutdownChannelINC ( void ) const
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::shutdownChannelINC");

   tDiaResult retCode = DIA_FAILED;

   udd_DriverFacade* pUDDFacade = getInstanceOfFacadeUDD();
   if ( pUDDFacade )
   {
      udd_CommChannel* pUDSCustomerDriver = 0;
      if ( pUDDFacade->queryCommChannel(UDD_CHANNEL_UID_UDS_CAN,&pUDSCustomerDriver) == DIA_SUCCESS )
      {
         if ( pUDSCustomerDriver->disconnect(UDD_CHANNEL_UID_UDS_CAN) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("### ERR: Unable to disconnect communication channel (INC) !!! ###");
         }
      }
      else
      {
         DIA_TR_ERR(("### ERROR: communication channel (INC) not available !!! ###"));
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::makeChannelTCP ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::makeChannelTCP");

   tDiaResult retCode = DIA_FAILED;

   udd_DriverFacade* pUDDFacade = getInstanceOfFacadeUDD();
   if ( pUDDFacade )
   {
      dia_CommChannelTCP* pTCP = dia_CommChannelTCP::getInstance();
      if ( pTCP )
      {
         dia_MessageHandler* pHandler = OSAL_NEW dia_MultipleReadDataByIDHandler();
         if ( pHandler )
         {
            mHandlerRep.push_back(pHandler);
            pTCP->setHandler(pHandler);
         }

         pUDDFacade->assign(*pTCP);
      } //lint !e429 custodial pointer is freed by this factory class

      DIA_TR_INF("### Setup Communication Channel TCP ###");

      udd_CommChannel* pUdsTcpDriver = 0;
      if ( pUDDFacade->queryCommChannel(UDD_CHANNEL_UID_UDS_TCPIP,&pUdsTcpDriver) == DIA_SUCCESS )
      {
         if ( pUdsTcpDriver->connect(UDD_CHANNEL_UID_UDS_TCPIP) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("### ERR: Unable to connect to communication channel (TCP) !!! ###");
         }
      }
      else
      {
         DIA_TR_ERR(("### ERROR: communication channel (INC) not available !!! ###"));
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::shutdownChannelTCP ( void ) const
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::shutdownChannelTCP");
   return DIA_SUCCESS;
}
dia::dia_DoIPCfg const &dia_FactoryPluginUdd::getDoipCfg(){
   static dia::dia_DoipChannelCreator creator;
   static const dia::dia_DoIPCfg::TargetSA_to_RoutingActivationTarget dia_DoIPTargets[] = {
      {DIA_DOIP_SA_LOCAL, {DOIP_LOCAL, DIA_DOIP_SA_LOCAL, 0, 0, DIA_DOIP_BUS_NUMBER_ETH}}
   };
   static const dia::dia_DoIPCfg::RouteNumber_to_RouteCfg dia_DoIPRoutes[] = {
      {DIA_DOIP_ROUTE_NUMBER_LOCAL, false}
   };
   static const dia::dia_DoIPCfg::RouteNumber_to_RouteTarget dia_DoIPRouteTargets[] = {
      {DIA_DOIP_ROUTE_NUMBER_LOCAL, DIA_DOIP_SA_LOCAL}
   };
   static const dia::dia_DoIPCfg::TesterSA_to_TesterCfg  dia_DoIPTesters[] = {
      {DIA_DOIP_SA_TESTER, 20}
   };
   static const dia::dia_DoIPCfg::TesterSA_to_RouteNumber dia_DoIPTesterRoutes[] = {
      {DIA_DOIP_SA_TESTER, DIA_DOIP_ROUTE_NUMBER_LOCAL}   
   };
   std::vector<tU8> eidBin;
   std::string eidHexString("");
   //~ if (DIA_SUCCESS==dia_getProperty(DIA_PROP_ECU_UID, eidBin)) {
      //~ if (eidBin.size()>=6) {
         //~ eidBin.resize(6);
      //~ }
      //~ eidHexString=dia_nsUtilities::convertArray2HexString(eidBin);
   //~ }
   DIA_TR_INF("dia_FactoryPluginUdd::getDoipCfg():  EID=%s", eidHexString.c_str());
   static const dia::dia_DoIPLocalCfg dia_DoIPLocalCfg = {
      DIA_DOIP_ETH_NAME,
      //      "lo",
      DIA_DOIP_BUS_NUMBER_ETH,
      DIA_DOIP_PORT,
      DIA_DOIP_SA_LOCAL,
      eidHexString,
      DIA_DOIP_GID,
      DIA_DOIP_VIN
   };
   static dia::dia_IDoIPChannelCreator *dia_DoIPChannelCreators[]= {
      &creator
   };
   static dia::dia_DoIPCfg dia_DoIPConfig = {
      &dia_DoIPLocalCfg,
      DIA_NUM_ARR_ELEMS(dia_DoIPTargets),
      dia_DoIPTargets,
      DIA_NUM_ARR_ELEMS(dia_DoIPRoutes),
      dia_DoIPRoutes,
      DIA_NUM_ARR_ELEMS(dia_DoIPRouteTargets),
      dia_DoIPRouteTargets,
      DIA_NUM_ARR_ELEMS(dia_DoIPTesters),
      dia_DoIPTesters,
      DIA_NUM_ARR_ELEMS(dia_DoIPTesterRoutes),
      dia_DoIPTesterRoutes,
      DIA_NUM_ARR_ELEMS(dia_DoIPChannelCreators),
      dia_DoIPChannelCreators,
   };
   return dia_DoIPConfig;
}
tDiaResult
dia_FactoryPluginUdd::makeChannelDoIP ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::makeChannelDoIP");
   tDiaResult retCode = DIA_FAILED;
   doipStack=new dia_DoipStack();
   doipStack->setup(getDoipCfg());
   udd_DriverFacade* pUDDFacade = getInstanceOfFacadeUDD();
   if ( pUDDFacade )
   {
      dia::dia_CommChannelDoIP* pCommChannelDoIP =
         dia::dia_CommChannelDoIP::createInstance(UDD_CHANNEL_UID_UDS_DOIP, DIA_DOIP_P2_TIME,
                                                  DIA_DOIP_P2EXT_TIME, DIA_DOIP_S3_TIME);
      if ( pCommChannelDoIP )
      {
         dia_MessageHandler* pHandler = OSAL_NEW dia_MultipleReadDataByIDHandler();
         if ( pHandler )
         {
            mHandlerRep.push_back(pHandler);
            pCommChannelDoIP->setHandler(pHandler);
         }
         pUDDFacade->assign(*pCommChannelDoIP);
      } //lint !e429 custodial pointer is freed by this factory class
      DIA_TR_INF("### Setup Communication Channel DoIP ###");
      udd_CommChannel* pUdsDoIPDriver = 0;
      if ( pUDDFacade->queryCommChannel(UDD_CHANNEL_UID_UDS_DOIP,&pUdsDoIPDriver) == DIA_SUCCESS )
      {
         if ( pUdsDoIPDriver->connect(UDD_CHANNEL_UID_UDS_DOIP) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("### ERR: Unable to connect to communication channel (DoIP) !!! ###");
         }
      }
      else
      {
         DIA_TR_ERR(("### ERROR: communication channel (DoIP) not available !!! ###"));
      }
   }
   return retCode;
}
tDiaResult
dia_FactoryPluginUdd::shutdownChannelDoIP ( void )
{
   if (doipStack) {
      doipStack->shutdown();
   }
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::shutdownChannelDoIP");
   return DIA_SUCCESS;
}
tDiaResult
dia_FactoryPluginUdd::makeChannelCSMProxy ( void ) const
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::makeChannelCSMProxy");
#ifdef __ENABLE_FEATURE_UDD_DRIVER_VIA_CSMPROXY__
   tDiaResult retCode = DIA_FAILED;
   udd_DriverFacade* pUDDFacade = getInstanceOfFacadeUDD();
   if ( pUDDFacade )
   {
      dia_CommChannelUDSviaCAN* pChannel = dia_CommChannelUDSviaCAN::getInstance();
      if ( pChannel )
      {
         dia_MessageHandler* pHandler = OSAL_NEW dia_MultipleReadDataByIDHandler();
         if ( pHandler )
         {
            mHandlerRep.push_back(pHandler);
            pChannel->setHandler(pHandler);
         }
         pUDDFacade->assign(*pChannel);
      }
      DIA_TR_INF("### Setup Communication Channel CSMProxy ###");
      udd_CommChannel* pUdsCanDriver = 0;
      if ( pUDDFacade->queryCommChannel(UDD_CHANNEL_UID_UDS_CAN,&pUdsCanDriver) == DIA_SUCCESS )
      {
         if ( pUdsCanDriver->connect(UDD_CHANNEL_UID_UDS_CAN) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("### ERR: Unable to connect to communication channel (CSMProxy) !!! ###");
         }
      }
      else
      {
         DIA_TR_ERR(("### ERROR: communication channel (CSMProxy) not available !!! ###"));
      }
   }
   return retCode;
#else
   return DIA_SUCCESS;
#endif
}
tDiaResult
dia_FactoryPluginUdd::shutdownChannelCSMProxy ( void ) const
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginSystemSettings::shutdownChannelCSMProxy");
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::makeChannelTTFIS ( void )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginUdd::makeChannelTTFIS");

   (void) assignNotifier<dia_ITraceListener, dia_ITraceNotifier>();

   mpTraceMonitor = OSAL_NEW dia_TraceMonitor(getInstanceOfFactory()->makeDriver(DIA_EN_DRVTYPE_TRACE));

   if ( mpTraceMonitor )
   {
      if ( mpTraceMonitor->open() == DIA_SUCCESS )
      {
         DIA_TR_INF("DIA_TRACE_CHANNEL SUCCESSFULLY OPENED AND CONFIGURED !!!");

         dia_TracePluginUDS* pPluginUDS = OSAL_NEW dia_TracePluginUDS;
         if ( pPluginUDS)
         {
         dia_MessageHandler* pHandlerLastDiagError = new dia_LastDiagErrorHandler();
                if ( pHandlerLastDiagError )
                {
                   mHandlerRep.push_back(pHandlerLastDiagError);
                   pPluginUDS->setHandler(pHandlerLastDiagError);
         dia_MessageHandler* pHandler = OSAL_NEW dia_MultipleReadDataByIDHandler();
                   if ( pHandler )
         {
            mHandlerRep.push_back(pHandler);
                      pHandlerLastDiagError->setHandler(pHandler);
                   }
                }
         }

         mpTraceMonitor->addTracePlugin(pPluginUDS);
         mpTraceMonitor->addTracePlugin(OSAL_NEW dia_TracePluginSecurity);
         mpTraceMonitor->addTracePlugin(OSAL_NEW dia_TracePluginCMD);
      } //lint !e429: custodial pointer is freed in destructors
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginUdd::shutdownChannelTTFIS ( void )
{
   if ( mpTraceMonitor )
   {
      (void) mpTraceMonitor->close();
      OSAL_DELETE mpTraceMonitor;
      mpTraceMonitor = 0;
   }

   return DIA_SUCCESS;
}


dia_DoipStack::dia_DoipStack():
      _server(NULL) //Coverity Fix(CID:177428)
{
   dia_tclFnctTrace oTrace("dia_DoipStack::dia_DoipStack");
}
dia_DoipStack::~dia_DoipStack() {
   dia_tclFnctTrace oTrace("dia_DoipStack::~dia_DoipStack");
}
tDiaResult dia_DoipStack::setup(dia::dia_DoIPCfg const &cfg) {
   dia_tclFnctTrace oTrace("dia_DoipStack::setup");
   tDiaResult retCode = DIA_SUCCESS;
   _server=dia::dia_DoIP::getInstance();
   _server->configure(cfg);
   _server->startCommunication();
   return retCode;
}
tDiaResult dia_DoipStack::shutdown() {
   tDiaResult retCode = DIA_SUCCESS;
   delete _server;
   _server=0;
   return retCode;
}
