/*
 * dia_FactoryPluginTrace.cpp
 *
 *  Created on: Nov 10, 2016
 *      Author: jas1hi
 */

#ifndef DIA_TRACECMDFACTORYPROJECT_H_
#include "project/framework/trace/dia_TraceCmdFactoryProject.h"
#endif

#include "dia_FactoryPluginTrace.h"


DIA_IMPL_SINGLETON(dia_FactoryPluginTrace)

dia_FactoryPluginTrace::dia_FactoryPluginTrace()
: dia_FactoryPlugin("dia_FactoryPluginTrace", DIA_EN_FACTORY_PLUGIN_TYPE_TRACE),
  mpTraceCmdFactoryProject(NULL)
{
}

dia_FactoryPluginTrace::~dia_FactoryPluginTrace()
{
	_BP_TRY_BEGIN
	{
	  if ( mpTraceCmdFactoryProject )
	  {
		 // (tVoid) tearDownObjects();

		 OSAL_DELETE mpTraceCmdFactoryProject;
		 mpTraceCmdFactoryProject = NULL;
	  }
	}
	_BP_CATCH_ALL
	{
	  DIA_TR_ERR("EXCEPTION CAUGHT: dia_FactoryPluginTrace::~dia_FactoryPluginTrace !!!");
	  DIA_ASSERT_ALWAYS();
	}
	_BP_CATCH_END
}

tDiaResult dia_FactoryPluginTrace::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginTrace::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF TRACE FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      (void) makeTraceCmdFactoryProject();
   }

   setInitializationLevel(level);
   DIA_TR_INF("dia_FactoryPluginTrace::setup. ##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

tDiaResult dia_FactoryPluginTrace::tearDown ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginTrace::tearDown");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_4 || level == DIA_EN_INITLEVEL_ALL )
   {
      (void) destroyTraceCmdFactoryProject();
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("dia_FactoryPluginTrace::tearDown. ##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

void dia_FactoryPluginTrace::makeTraceCmdFactoryProject ( void )
{
	mpTraceCmdFactoryProject = OSAL_NEW dia_TraceCmdFactoryProject();

	if ( mpTraceCmdFactoryProject )
	{
	  if ( mpTraceCmdFactoryProject->init() == DIA_SUCCESS )
	  {
		 DIA_TR_INF("dia_FactoryPluginTrace::makeTraceCmdFactoryProject. Successfully initialized !!!");
	  }
	}
}

void dia_FactoryPluginTrace::destroyTraceCmdFactoryProject ( void )
{
	if ( mpTraceCmdFactoryProject )
	{
	  (void) mpTraceCmdFactoryProject->deinit();
	  OSAL_DELETE mpTraceCmdFactoryProject;
	  mpTraceCmdFactoryProject = NULL;
	}
}
